/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jms.ConnectionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.client.OrderModifier;
import org.marketcetera.client.config.SpringConfig;
import org.marketcetera.trade.Order;
import org.mockito.Mockito;

public class ClientOrderModifierTest {
    @Test
    public void testSpringConfig() throws Exception {
        ConnectionFactory mockIncomingFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        ConnectionFactory mockOutgoingFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        SpringConfig config = new SpringConfig(mockIncomingFactory, mockOutgoingFactory, null);
        config.afterPropertiesSet();
        Assert.assertTrue((boolean)config.getOrderModifiers().isEmpty());
        config = new SpringConfig(mockIncomingFactory, mockOutgoingFactory, new ArrayList());
        config.afterPropertiesSet();
        Assert.assertTrue((boolean)config.getOrderModifiers().isEmpty());
        OrderModifier modifier1 = new OrderModifier(){

            public boolean modify(Order inOrder) {
                throw new UnsupportedOperationException();
            }
        };
        config = new SpringConfig(mockIncomingFactory, mockOutgoingFactory, Arrays.asList(modifier1));
        config.afterPropertiesSet();
        Assert.assertTrue((boolean)Arrays.equals(new OrderModifier[]{modifier1}, config.getOrderModifiers().toArray()));
        OrderModifier modifier2 = new OrderModifier(){

            public boolean modify(Order inOrder) {
                throw new UnsupportedOperationException();
            }
        };
        config = new SpringConfig(mockIncomingFactory, mockOutgoingFactory, Arrays.asList(modifier1, modifier2));
        config.afterPropertiesSet();
        Assert.assertTrue((boolean)Arrays.equals(new OrderModifier[]{modifier1, modifier2}, config.getOrderModifiers().toArray()));
        config.setOrderModifiers(null);
        Assert.assertTrue((boolean)config.getOrderModifiers().isEmpty());
        OrderModifier modifier3 = new OrderModifier(){

            public boolean modify(Order inOrder) {
                throw new UnsupportedOperationException();
            }
        };
        OrderModifier modifier4 = new OrderModifier(){

            public boolean modify(Order inOrder) {
                throw new UnsupportedOperationException();
            }
        };
        config.setOrderModifiers(Arrays.asList(modifier3, modifier4));
        Assert.assertTrue((boolean)Arrays.equals(new OrderModifier[]{modifier3, modifier4}, config.getOrderModifiers().toArray()));
        config.setOrderModifiers(new ArrayList());
        Assert.assertTrue((boolean)config.getOrderModifiers().isEmpty());
    }
}

