/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.test.EqualityAssert;

@ClassVersion(value="$Id: ClientParametersTest.java 16154 2012-07-14 16:34:05Z colin $")
public class ClientParametersTest {
    @Test
    public void all() {
        String user = "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e";
        String passString = "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e";
        char[] password = passString.toCharArray();
        String url = "url";
        String hostname = "host";
        int port = Short.MAX_VALUE;
        String idPrefix = "prefix";
        int heartbeatInterval = 5001;
        ClientParameters cp = new ClientParameters(new String(user), passString.toCharArray(), new String(url), new String(hostname), port, new String(idPrefix), heartbeatInterval);
        this.assertCP(cp, user, password, url, hostname, port, idPrefix, heartbeatInterval);
        ClientParameters cpNull = new ClientParameters(null, null, null, null, -1, null, -1);
        this.assertCP(cpNull, null, null, null, null, -1, null, -1);
        EqualityAssert.assertEquality((Object)cp, (Object)new ClientParameters(user, password, url, hostname, port, idPrefix, heartbeatInterval), (Object[])new Object[]{cpNull, new ClientParameters(user, "nopass".toCharArray(), url, hostname, port, idPrefix, heartbeatInterval), new ClientParameters("unuser", password, url, hostname, port, idPrefix, heartbeatInterval), new ClientParameters(user, password, "urln", hostname, port, idPrefix, heartbeatInterval), new ClientParameters(user, password, url, "hoho", port, idPrefix, heartbeatInterval), new ClientParameters(user, password, url, hostname, 90, idPrefix, heartbeatInterval), new ClientParameters(user, password, url, hostname, port, "wha", heartbeatInterval), new ClientParameters(null, password, url, hostname, port, idPrefix, heartbeatInterval), new ClientParameters(user, null, url, hostname, port, idPrefix, heartbeatInterval), new ClientParameters(user, password, null, hostname, port, idPrefix, heartbeatInterval), new ClientParameters(user, password, url, null, port, idPrefix, heartbeatInterval), new ClientParameters(user, password, url, hostname, -1, idPrefix, heartbeatInterval), new ClientParameters(user, password, url, hostname, port, null, heartbeatInterval), new ClientParameters(user + " ", password, url, hostname, port, idPrefix, heartbeatInterval), new ClientParameters(user, "pass ".toCharArray(), url, hostname, port, idPrefix, heartbeatInterval), new ClientParameters(user, password, url + " ", hostname, port, idPrefix, heartbeatInterval), new ClientParameters(user, password, url, hostname + " ", port, idPrefix, heartbeatInterval), new ClientParameters(user, password, url, hostname, port + 1, idPrefix, heartbeatInterval), new ClientParameters(user, password, url, hostname, port, " ", heartbeatInterval), new ClientParameters(user, password, url, hostname, port, idPrefix, heartbeatInterval + 1)});
        cp = new ClientParameters(user, password, url, hostname, port, idPrefix);
        this.assertCP(cp, user, password, url, hostname, port, idPrefix, 5000);
        cp = new ClientParameters(user, password, url, hostname, port);
        this.assertCP(cp, user, password, url, hostname, port, null, 5000);
    }

    private void assertCP(ClientParameters inCp, String inUser, char[] inPassword, String inUrl, String inHostname, int inPort, String inIDPrefix, int heartbeatInterval) {
        Assert.assertEquals((Object)inUser, (Object)inCp.getUsername());
        Assert.assertArrayEquals((char[])inPassword, (char[])inCp.getPassword());
        Assert.assertEquals((Object)inUrl, (Object)inCp.getURL());
        Assert.assertEquals((Object)inHostname, (Object)inCp.getHostname());
        Assert.assertEquals((long)inPort, (long)inCp.getPort());
        Assert.assertEquals((Object)inIDPrefix, (Object)inCp.getIDPrefix());
        Assert.assertEquals((long)heartbeatInterval, (long)inCp.getHeartbeatInterval());
    }
}

