/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import com.google.common.collect.Lists;
import java.beans.ExceptionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.marketcetera.client.BrokerStatusListener;
import org.marketcetera.client.Client;
import org.marketcetera.client.ClientFactory;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.OrderModifier;
import org.marketcetera.client.OrderValidationException;
import org.marketcetera.client.ReportListener;
import org.marketcetera.client.brokers.BrokersStatus;
import org.marketcetera.client.users.UserInfo;
import org.marketcetera.core.notifications.ServerStatusListener;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.event.Event;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Currency;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.ExecutionReportImpl;
import org.marketcetera.trade.FIXMessageWrapper;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Hierarchy;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.ReportBaseImpl;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.ws.tags.SessionId;

public class MockClient
implements Client {
    private final Set<ReportBase> reports = new TreeSet<ReportBase>(ReportSendingTimeComparator.INSTANCE);
    private final List<ReportBaseImpl> openOrders = Lists.newArrayList();
    private final Collection<OrderSingle> orders = new ArrayList<OrderSingle>();
    private final Collection<OrderReplace> replaces = new ArrayList<OrderReplace>();
    private final Collection<OrderCancel> cancels = new ArrayList<OrderCancel>();
    private final ClientParameters clientParameters;
    private final Collection<ReportListener> reportListeners = new LinkedHashSet<ReportListener>();
    private volatile ConnectionException getReportsSinceThrows;
    private volatile ConnectionException sendOrderSingleConnectionException = null;
    private volatile ConnectionException sendOrderReplaceConnectionException = null;
    private volatile ConnectionException sendOrderCancelConnectionException = null;
    private volatile OrderValidationException sendOrderSingleValidationException = null;
    private volatile OrderValidationException sendOrderReplaceValidationException = null;
    private volatile OrderValidationException sendOrderCancelValidationException = null;

    public MockClient(ClientParameters inClientParameters) {
        this.clientParameters = inClientParameters;
    }

    public MockClient() {
        this(null);
    }

    public SessionId getSessionId() {
        throw new UnsupportedOperationException();
    }

    public void sendOrder(OrderSingle inOrderSingle) throws ConnectionException, OrderValidationException {
        if (this.sendOrderSingleConnectionException != null) {
            throw this.sendOrderSingleConnectionException;
        }
        if (this.sendOrderSingleValidationException != null) {
            throw this.sendOrderSingleValidationException;
        }
        this.orders.add(inOrderSingle);
    }

    public void sendOrder(OrderReplace inOrderReplace) throws ConnectionException, OrderValidationException {
        if (this.sendOrderReplaceConnectionException != null) {
            throw this.sendOrderReplaceConnectionException;
        }
        if (this.sendOrderReplaceValidationException != null) {
            throw this.sendOrderReplaceValidationException;
        }
        this.replaces.add(inOrderReplace);
    }

    public void sendOrder(OrderCancel inOrderCancel) throws ConnectionException, OrderValidationException {
        if (this.sendOrderCancelConnectionException != null) {
            throw this.sendOrderCancelConnectionException;
        }
        if (this.sendOrderCancelValidationException != null) {
            throw this.sendOrderCancelValidationException;
        }
        this.cancels.add(inOrderCancel);
    }

    public void sendOrderRaw(FIXOrder inFIXOrder) throws ConnectionException, OrderValidationException {
        throw new UnsupportedOperationException();
    }

    public ReportBase[] getReportsSince(Date inDate) throws ConnectionException {
        if (this.getReportsSinceThrows != null) {
            throw this.getReportsSinceThrows;
        }
        ArrayList<ReportBase> reportsToReturn = new ArrayList<ReportBase>();
        for (ReportBase report : this.reports) {
            if (report.getSendingTime().compareTo(inDate) == -1) continue;
            reportsToReturn.add(report);
        }
        return reportsToReturn.toArray(new ReportBase[reportsToReturn.size()]);
    }

    public BigDecimal getEquityPositionAsOf(Date inDate, Equity inEquity) throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public Map<PositionKey<Equity>, BigDecimal> getAllEquityPositionsAsOf(Date inDate) throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getFuturePositionAsOf(Date inDate, Future inFuture) throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public Map<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(Date inDate) throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getOptionPositionAsOf(Date inDate, Option inOption) throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public Map<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(Date inDate) throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public Map<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(Date inDate, String ... inRootSymbols) throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public String getUnderlying(String inOptionRoot) throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getOptionRoots(String inUnderlying) throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public void addReportListener(ReportListener inListener) {
        this.reportListeners.add(inListener);
    }

    public void removeReportListener(ReportListener inListener) {
        this.reportListeners.remove(inListener);
    }

    public void addBrokerStatusListener(BrokerStatusListener inListener) {
        throw new UnsupportedOperationException();
    }

    public void removeBrokerStatusListener(BrokerStatusListener inListener) {
        throw new UnsupportedOperationException();
    }

    public void addServerStatusListener(ServerStatusListener inListener) {
        throw new UnsupportedOperationException();
    }

    public void removeServerStatusListener(ServerStatusListener inListener) {
        throw new UnsupportedOperationException();
    }

    public void addExceptionListener(ExceptionListener inListener) {
        throw new UnsupportedOperationException();
    }

    public void removeExceptionListener(ExceptionListener inListener) {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    public void reconnect() throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public void reconnect(ClientParameters inParameters) throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public ClientParameters getParameters() {
        throw new UnsupportedOperationException();
    }

    public Date getLastConnectTime() {
        throw new UnsupportedOperationException();
    }

    public BrokersStatus getBrokersStatus() throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public UserInfo getUserInfo(UserID inId, boolean inUseCache) throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public boolean isCredentialsMatch(String inUsername, char[] inPassword) {
        throw new UnsupportedOperationException();
    }

    public boolean isServerAlive() {
        throw new UnsupportedOperationException();
    }

    public void setUserData(Properties inProperties) throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public Properties getUserData() throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public Instrument resolveSymbol(String inSymbol) throws ConnectionException {
        return null;
    }

    public void deleteReport(ExecutionReportImpl inReport) throws ConnectionException {
        throw new UnsupportedOperationException();
    }

    public OrderID findRootOrderIdFor(OrderID inOrderID) {
        throw new UnsupportedOperationException();
    }

    public List<ReportBaseImpl> getOpenOrders() throws ConnectionException {
        return this.openOrders;
    }

    public BigDecimal getCurrencyPositionAsOf(Date inDate, Currency inCurrency) throws ConnectionException {
        return null;
    }

    public Map<PositionKey<Currency>, BigDecimal> getAllCurrencyPositionsAsOf(Date inDate) throws ConnectionException {
        return null;
    }

    public void addReport(FIXMessageWrapper inReport, BrokerID inBrokerID, Hierarchy inHierarchy) throws ConnectionException {
        for (ReportListener reportListener : this.reportListeners) {
            if (inReport instanceof ExecutionReport) {
                reportListener.receiveExecutionReport((ExecutionReport)inReport);
                continue;
            }
            if (!(inReport instanceof OrderCancelReject)) continue;
            reportListener.receiveCancelReject((OrderCancelReject)inReport);
        }
    }

    public void sendEvent(Event inEvent) {
        throw new UnsupportedOperationException();
    }

    public ClientParameters getClientParameters() {
        return this.clientParameters;
    }

    public Collection<ReportListener> getReportListeners() {
        return this.reportListeners;
    }

    public Set<ReportBase> getReports() {
        return this.reports;
    }

    public Collection<OrderSingle> getOrders() {
        return this.orders;
    }

    public Collection<OrderReplace> getReplaces() {
        return this.replaces;
    }

    public Collection<OrderCancel> getCancels() {
        return this.cancels;
    }

    public void sendToListeners(ReportBase inReport) {
        for (ReportListener reportListener : this.reportListeners) {
            if (inReport instanceof ExecutionReport) {
                reportListener.receiveExecutionReport((ExecutionReport)inReport);
                continue;
            }
            if (inReport instanceof OrderCancelReject) {
                reportListener.receiveCancelReject((OrderCancelReject)inReport);
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    public void setGetReportsSinceException(ConnectionException inException) {
        this.getReportsSinceThrows = inException;
    }

    public void setSendOrderSingleException(ConnectionException inException) {
        this.sendOrderSingleConnectionException = inException;
    }

    public void setSendOrderReplaceConnectionException(ConnectionException inSendOrderReplaceConnectionException) {
        this.sendOrderReplaceConnectionException = inSendOrderReplaceConnectionException;
    }

    public void setSendOrderCancelConnectionException(ConnectionException inSendOrderCancelConnectionException) {
        this.sendOrderCancelConnectionException = inSendOrderCancelConnectionException;
    }

    public void setSendOrderSingleValidationException(OrderValidationException inSendOrderSingleValidationException) {
        this.sendOrderSingleValidationException = inSendOrderSingleValidationException;
    }

    public void setSendOrderReplaceValidationException(OrderValidationException inSendOrderReplaceValidationException) {
        this.sendOrderReplaceValidationException = inSendOrderReplaceValidationException;
    }

    public void setSendOrderCancelValidationException(OrderValidationException inSendOrderCancelValidationException) {
        this.sendOrderCancelValidationException = inSendOrderCancelValidationException;
    }

    public void reset() {
        this.reportListeners.clear();
        this.reports.clear();
        this.orders.clear();
        this.replaces.clear();
        this.cancels.clear();
        this.openOrders.clear();
        this.setGetReportsSinceException(null);
        this.setSendOrderSingleException(null);
        this.setSendOrderReplaceConnectionException(null);
        this.setSendOrderCancelConnectionException(null);
        this.setSendOrderSingleValidationException(null);
        this.setSendOrderReplaceValidationException(null);
        this.setSendOrderCancelValidationException(null);
    }

    public void addOrderModifier(OrderModifier inOrderModifier) {
        throw new UnsupportedOperationException();
    }

    public void removeOrderModifier(OrderModifier inOrderModifier) {
        throw new UnsupportedOperationException();
    }

    private static enum ReportSendingTimeComparator implements Comparator<ReportBase>
    {
        INSTANCE;


        @Override
        public int compare(ReportBase inO1, ReportBase inO2) {
            return inO1.getSendingTime().compareTo(inO2.getSendingTime());
        }
    }

    public static class MockClientFactory
    implements ClientFactory {
        public Client getClient(ClientParameters inClientParameters) throws ClientInitException, ConnectionException {
            return new MockClient(inClientParameters);
        }
    }
}

