/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.marketcetera.client.jms.DataEnvelope;
import org.marketcetera.client.jms.ReceiveOnlyHandler;
import org.marketcetera.event.HasFIXMessage;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.MessageCreationException;
import org.marketcetera.trade.Originator;
import org.marketcetera.trade.TypesTestBase;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.jms.core.JmsOperations;
import quickfix.FieldNotFound;
import quickfix.Message;

@ClassVersion(value="$Id: MockMessageHandler.java 17374 2017-04-07 19:53:35Z colin $")
public class MockMessageHandler
implements ReceiveOnlyHandler<DataEnvelope> {
    private final BlockingQueue<Object> mReceived = new LinkedBlockingQueue<Object>();
    private final Queue<Object> mToSend = new LinkedList<Object>();
    private final Queue<Object> mToSendStatus = new LinkedList<Object>();
    private JmsOperations mReplySender;
    private static final AtomicLong mLong = new AtomicLong();

    public void receiveMessage(DataEnvelope inObject) {
        if (inObject.getOrder() instanceof HasFIXMessage) {
            try {
                TypesTestBase.logFields((Message)((HasFIXMessage)inObject.getOrder()).getMessage());
            }
            catch (FieldNotFound fieldNotFound) {}
        } else {
            SLF4JLoggerProxy.debug((Object)this, (String)"Received {}", (Object[])new Object[]{inObject});
        }
        this.mReceived.add(inObject);
        Object send = !this.mToSend.isEmpty() ? this.mToSend.remove() : MockMessageHandler.createExecutionReport();
        SLF4JLoggerProxy.debug((Object)this, (String)"Sending {}", (Object[])new Object[]{send});
        this.getReplySender().convertAndSend(send);
    }

    public synchronized void addToSend(Object inObject) {
        SLF4JLoggerProxy.debug((Object)this, (String)"ADDED {}", (Object[])new Object[]{inObject});
        this.mToSend.add(inObject);
    }

    public synchronized void addToSendStatus(Object inObject) {
        SLF4JLoggerProxy.debug((Object)this, (String)"ADDED STATUS {}", (Object[])new Object[]{inObject});
        this.mToSendStatus.add(inObject);
    }

    public synchronized Object removeReceived() throws InterruptedException {
        return this.mReceived.take();
    }

    public synchronized int numReceived() {
        return this.mReceived.size();
    }

    public synchronized void clear() {
        this.mReceived.clear();
        this.mToSend.clear();
        this.mToSendStatus.clear();
    }

    static ExecutionReport createExecutionReport() {
        try {
            long id = mLong.getAndIncrement();
            return Factory.getInstance().createExecutionReport(FIXVersion.FIX42.getMessageFactory().newExecutionReport("ord" + id, "clord" + id, "exec" + id, '0', '1', new BigDecimal("4343.49"), new BigDecimal("498.34"), new BigDecimal("783343.49"), new BigDecimal("598.34"), new BigDecimal("234343.49"), new BigDecimal("798.34"), (Instrument)new Equity("IBM"), "my acc", "text"), new BrokerID("bro"), Originator.Broker, null, null);
        }
        catch (MessageCreationException e) {
            throw new RuntimeException(e);
        }
        catch (FieldNotFound e) {
            throw new RuntimeException(e);
        }
    }

    JmsOperations getReplySender() {
        return this.mReplySender;
    }

    void setReplySender(JmsOperations replySender) {
        this.mReplySender = replySender;
    }
}

