/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import javax.xml.bind.JAXBException;
import org.marketcetera.client.MockMessageHandler;
import org.marketcetera.client.jms.JmsManager;
import org.marketcetera.client.jms.JmsUtils;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.SessionFactory;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.tags.SessionId;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;

@ClassVersion(value="$Id: MockSessionFactory.java 16154 2012-07-14 16:34:05Z colin $")
public class MockSessionFactory
implements SessionFactory<Object> {
    private final JmsManager mJmsManager;
    private final MockMessageHandler mHandler;

    public MockSessionFactory(JmsManager jmsManager, MockMessageHandler handler) {
        this.mJmsManager = jmsManager;
        this.mHandler = handler;
    }

    public Object createSession(StatelessClientContext context, String user, SessionId id) {
        JmsTemplate replySender;
        try {
            replySender = this.mJmsManager.getOutgoingJmsFactory().createJmsTemplateX(JmsUtils.getReplyTopicName((SessionId)id), true);
        }
        catch (JAXBException ex) {
            throw new IllegalStateException("Cannot initialize trade message reply topic", ex);
        }
        this.mHandler.setReplySender((JmsOperations)replySender);
        return null;
    }

    public void removedSession(Object session) {
        this.mHandler.setReplySender(null);
    }
}

