/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.jms;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.client.ClientTest;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.client.jms.DataEnvelope;
import org.marketcetera.client.jms.JMSXMLMessageConverter;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Currency;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.FIXResponse;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.FutureExpirationMonth;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.Order;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.TypesTestBase;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.tags.SessionId;

@ClassVersion(value="$Id: JMSXMLConverterTest.java 17372 2017-04-06 19:41:09Z colin $")
public class JMSXMLConverterTest {
    private static Instrument[] sInstruments = new Instrument[]{new Equity("sym"), new Option("sym", "20101010", BigDecimal.TEN, OptionType.Call), new Future("rama", FutureExpirationMonth.AUGUST, 2010), new Currency("USD", "GBP", "", "")};
    private static JMSXMLMessageConverter sConverter;
    private static final SessionId SESSION_ID;

    @BeforeClass
    public static void setup() throws Exception {
        sConverter = new JMSXMLMessageConverter();
    }

    @Test
    public void verifyOrderSingle() throws Exception {
        for (Instrument instrument : sInstruments) {
            OrderSingle i = ClientTest.createOrderSingle();
            i.setInstrument(instrument);
            i.setCustomFields(this.generateCustomFields());
            DataEnvelope o = (DataEnvelope)JMSXMLConverterTest.roundTrip(new DataEnvelope((Order)i, SESSION_ID));
            Assert.assertEquals((Object)SESSION_ID, (Object)o.getSessionId());
            TypesTestBase.assertOrderSingleEquals((OrderSingle)i, (OrderSingle)((OrderSingle)o.getOrder()));
        }
    }

    @Test
    public void verifyOrderCancel() throws Exception {
        for (Instrument instrument : sInstruments) {
            OrderCancel i = ClientTest.createOrderCancel();
            i.setInstrument(instrument);
            i.setCustomFields(this.generateCustomFields());
            DataEnvelope o = (DataEnvelope)JMSXMLConverterTest.roundTrip(new DataEnvelope((Order)i, SESSION_ID));
            Assert.assertEquals((Object)SESSION_ID, (Object)o.getSessionId());
            TypesTestBase.assertOrderCancelEquals((OrderCancel)i, (OrderCancel)((OrderCancel)o.getOrder()));
        }
    }

    @Test
    public void verifyOrderReplace() throws Exception {
        for (Instrument instrument : sInstruments) {
            OrderReplace i = ClientTest.createOrderReplace();
            i.setInstrument(instrument);
            i.setCustomFields(this.generateCustomFields());
            DataEnvelope o = (DataEnvelope)JMSXMLConverterTest.roundTrip(new DataEnvelope((Order)i, SESSION_ID));
            Assert.assertEquals((Object)SESSION_ID, (Object)o.getSessionId());
            TypesTestBase.assertOrderReplaceEquals((OrderReplace)i, (OrderReplace)((OrderReplace)o.getOrder()));
        }
    }

    @Test
    public void verifyFIXOrder() throws Exception {
        FIXOrder i = ClientTest.createOrderFIX();
        DataEnvelope o = (DataEnvelope)JMSXMLConverterTest.roundTrip(new DataEnvelope((Order)i, SESSION_ID));
        Assert.assertEquals((Object)SESSION_ID, (Object)o.getSessionId());
        TypesTestBase.assertOrderFIXEquals((FIXOrder)i, (FIXOrder)((FIXOrder)o.getOrder()));
    }

    @Test
    public void verifyExecReport() throws Exception {
        ExecutionReport executionReport = ClientTest.createExecutionReport();
        TypesTestBase.assertExecReportEquals((ExecutionReport)executionReport, (ExecutionReport)((ExecutionReport)JMSXMLConverterTest.roundTrip(executionReport)));
    }

    @Test
    public void verifyCancelReject() throws Exception {
        OrderCancelReject cancelReject = ClientTest.createCancelReject();
        TypesTestBase.assertCancelRejectEquals((OrderCancelReject)cancelReject, (OrderCancelReject)((OrderCancelReject)JMSXMLConverterTest.roundTrip(cancelReject)));
    }

    @Test
    public void verifyFIXResponse() throws Exception {
        FIXResponse fixResponse = ClientTest.createFIXResponse();
        TypesTestBase.assertFIXResponseEquals((FIXResponse)fixResponse, (FIXResponse)((FIXResponse)JMSXMLConverterTest.roundTrip(fixResponse)));
    }

    @Test
    public void verifyBrokerStatus() throws Exception {
        BrokerStatus i = new BrokerStatus("me", new BrokerID("broke"), false);
        BrokerStatus o = (BrokerStatus)JMSXMLConverterTest.roundTrip(i);
        Assert.assertEquals((Object)i.getName(), (Object)o.getName());
        Assert.assertEquals((Object)i.getId(), (Object)o.getId());
        Assert.assertEquals((Object)i.getLoggedOn(), (Object)o.getLoggedOn());
    }

    @Test
    public void marshallFailure() throws Exception {
        new ExpectedFailure<JAXBException>(NotMarshallable.class.getName(), false){

            protected void run() throws Exception {
                JMSXMLConverterTest.roundTrip(new NotMarshallable());
            }
        };
    }

    @Test
    public void unmarshallFailure() throws Exception {
        new ExpectedFailure<UnmarshalException>(){

            protected void run() throws Exception {
                sConverter.fromXML("This is not XML");
            }
        };
    }

    static Object roundTrip(Object inObject) throws Exception {
        String xml = sConverter.toXML(inObject);
        SLF4JLoggerProxy.debug((Object)"XML", (String)xml);
        return sConverter.fromXML(xml);
    }

    private Map<String, String> generateCustomFields() {
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("key1", "value1");
        value.put("key2", "value2");
        return value;
    }

    static {
        SESSION_ID = SessionId.generate();
    }

    private static class NotMarshallable {
        private NotMarshallable() {
        }
    }
}

