/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.jms;

import javax.jms.ConnectionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.client.MockServer;
import org.marketcetera.client.jms.JmsManager;
import org.marketcetera.client.jms.ReceiveOnlyHandler;
import org.marketcetera.client.jms.ReplyHandler;
import org.marketcetera.client.jms.SampleBrokerStatusHandler;
import org.marketcetera.client.jms.SampleEnvelopeReplyHandler;
import org.marketcetera.client.jms.SampleIntegerReplyHandler;
import org.marketcetera.client.jms.SampleOrderReplyHandler;
import org.marketcetera.client.jms.SampleQMessageReplyHandler;
import org.marketcetera.client.jms.SampleReceiveOnlyHandler;
import org.marketcetera.client.jms.SampleReplyHandler;
import org.marketcetera.util.test.TestCaseBase;
import org.springframework.jms.core.JmsTemplate;

public class JmsManagerTest
extends TestCaseBase {
    private static final String TEST_SEND_DEST = "sender";
    private static final String TEST_REPLY_DEST = "reply";
    private static final String TEST_REPLY_IGNORED = "replyIgnored";
    private static final String TEST_Q_EXT = "-q";
    private static final String TEST_TMX_EXT = "-tmx";
    private static final String TEST_OEX_EXT = "-oex";
    private static final String TEST_BSX_EXT = "-bsx";
    static final int TEST_COUNT = 10;

    private static <T> void single(JmsTemplate sender, SampleReplyHandler<T>[] replies, SampleReceiveOnlyHandler<T>[] receivers) throws Exception {
        SampleReplyHandler firstReply = replies[0];
        for (int i = 0; i < 10; ++i) {
            sender.convertAndSend(firstReply.create(i));
        }
        Thread.sleep(5000L);
        for (SampleReplyHandler<T> reply : replies) {
            Assert.assertEquals((long)10L, (long)reply.getReceived().size());
            Assert.assertEquals((long)10L, (long)reply.getReplies().size());
        }
        for (SampleReceiveOnlyHandler<T> receiver : receivers) {
            Assert.assertEquals((long)10L, (long)receiver.getReceived().size());
        }
        for (int i = 0; i < 10; ++i) {
            for (SampleReplyHandler<T> reply : replies) {
                Assert.assertTrue((boolean)firstReply.isEqual(i, reply.getReceived().get(i)));
                Assert.assertTrue((boolean)firstReply.isEqual(i + 1, reply.getReplies().get(i)));
            }
            for (SampleReceiveOnlyHandler<T> receiver : receivers) {
                Assert.assertTrue((boolean)firstReply.isEqual(i + 1, receiver.getReceived().get(i)));
            }
            ++i;
        }
    }

    private static <T> void single(JmsTemplate sender, SampleReplyHandler<T> reply, SampleReceiveOnlyHandler<T> receiver) throws Exception {
        JmsManagerTest.single(sender, new SampleReplyHandler[]{reply}, new SampleReceiveOnlyHandler[]{receiver});
    }

    @Test
    public void simpleMessages() throws Exception {
        MockServer server = new MockServer();
        JmsManager mgr = new JmsManager((ConnectionFactory)server.getContext().getBean("metc_connection_factory_in"), (ConnectionFactory)server.getContext().getBean("metc_connection_factory_out"));
        String senderName = TEST_SEND_DEST;
        String replyName = TEST_REPLY_DEST;
        SampleIntegerReplyHandler reply = new SampleIntegerReplyHandler();
        SampleReceiveOnlyHandler receiveOnly = new SampleReceiveOnlyHandler();
        mgr.getIncomingJmsFactory().registerHandler((ReplyHandler)reply, senderName, false, replyName, false);
        mgr.getIncomingJmsFactory().registerHandler(receiveOnly, replyName, false);
        JmsManagerTest.single(mgr.getOutgoingJmsFactory().createJmsTemplate(senderName, false), reply, receiveOnly);
        SampleIntegerReplyHandler[] replies = new SampleIntegerReplyHandler[]{new SampleIntegerReplyHandler(), new SampleIntegerReplyHandler()};
        SampleReceiveOnlyHandler[] receivers = new SampleReceiveOnlyHandler[]{new SampleReceiveOnlyHandler(), new SampleReceiveOnlyHandler()};
        mgr.getIncomingJmsFactory().registerHandler((ReplyHandler)replies[0], senderName, true, replyName, true);
        mgr.getIncomingJmsFactory().registerHandler((ReplyHandler)replies[1], senderName, true, TEST_REPLY_IGNORED, true);
        mgr.getIncomingJmsFactory().registerHandler((ReceiveOnlyHandler)receivers[0], replyName, true);
        mgr.getIncomingJmsFactory().registerHandler((ReceiveOnlyHandler)receivers[1], replyName, true);
        JmsManagerTest.single(mgr.getOutgoingJmsFactory().createJmsTemplate(senderName, true), replies, receivers);
        senderName = "sender-q";
        replyName = "reply-q";
        SampleQMessageReplyHandler replyQ = new SampleQMessageReplyHandler();
        SampleReceiveOnlyHandler receiveOnlyQ = new SampleReceiveOnlyHandler();
        mgr.getIncomingJmsFactory().registerHandlerQ((ReplyHandler)replyQ, senderName, false, replyName, false);
        mgr.getIncomingJmsFactory().registerHandlerQ(receiveOnlyQ, replyName, false);
        JmsManagerTest.single(mgr.getOutgoingJmsFactory().createJmsTemplateQ(senderName, false), replyQ, receiveOnlyQ);
        SampleQMessageReplyHandler[] repliesQ = new SampleQMessageReplyHandler[]{new SampleQMessageReplyHandler(), new SampleQMessageReplyHandler()};
        SampleReceiveOnlyHandler[] receiversQ = new SampleReceiveOnlyHandler[]{new SampleReceiveOnlyHandler(), new SampleReceiveOnlyHandler()};
        mgr.getIncomingJmsFactory().registerHandlerQ((ReplyHandler)repliesQ[0], senderName, true, replyName, true);
        mgr.getIncomingJmsFactory().registerHandlerQ((ReplyHandler)repliesQ[1], senderName, true, TEST_REPLY_IGNORED, true);
        mgr.getIncomingJmsFactory().registerHandlerQ((ReceiveOnlyHandler)receiversQ[0], replyName, true);
        mgr.getIncomingJmsFactory().registerHandlerQ((ReceiveOnlyHandler)receiversQ[1], replyName, true);
        JmsManagerTest.single(mgr.getOutgoingJmsFactory().createJmsTemplateQ(senderName, true), repliesQ, receiversQ);
        senderName = "sender-tmx";
        replyName = "reply-tmx";
        SampleOrderReplyHandler replyTMX = new SampleOrderReplyHandler();
        SampleReceiveOnlyHandler receiveOnlyTMX = new SampleReceiveOnlyHandler();
        mgr.getIncomingJmsFactory().registerHandlerTMX((ReplyHandler)replyTMX, senderName, false, replyName, false);
        mgr.getIncomingJmsFactory().registerHandlerTMX(receiveOnlyTMX, replyName, false);
        JmsManagerTest.single(mgr.getOutgoingJmsFactory().createJmsTemplateX(senderName, false), replyTMX, receiveOnlyTMX);
        SampleOrderReplyHandler[] repliesTMX = new SampleOrderReplyHandler[]{new SampleOrderReplyHandler(), new SampleOrderReplyHandler()};
        SampleReceiveOnlyHandler[] receiversTMX = new SampleReceiveOnlyHandler[]{new SampleReceiveOnlyHandler(), new SampleReceiveOnlyHandler()};
        mgr.getIncomingJmsFactory().registerHandlerTMX((ReplyHandler)repliesTMX[0], senderName, true, replyName, true);
        mgr.getIncomingJmsFactory().registerHandlerTMX((ReplyHandler)repliesTMX[1], senderName, true, TEST_REPLY_IGNORED, true);
        mgr.getIncomingJmsFactory().registerHandlerTMX((ReceiveOnlyHandler)receiversTMX[0], replyName, true);
        mgr.getIncomingJmsFactory().registerHandlerTMX((ReceiveOnlyHandler)receiversTMX[1], replyName, true);
        JmsManagerTest.single(mgr.getOutgoingJmsFactory().createJmsTemplateX(senderName, true), repliesTMX, receiversTMX);
        senderName = "sender-oex";
        replyName = "reply-oex";
        SampleEnvelopeReplyHandler replyOEX = new SampleEnvelopeReplyHandler();
        SampleReceiveOnlyHandler receiveOnlyOEX = new SampleReceiveOnlyHandler();
        mgr.getIncomingJmsFactory().registerHandlerOEX((ReplyHandler)replyOEX, senderName, false, replyName, false);
        mgr.getIncomingJmsFactory().registerHandlerOEX(receiveOnlyOEX, replyName, false);
        JmsManagerTest.single(mgr.getOutgoingJmsFactory().createJmsTemplateX(senderName, false), replyOEX, receiveOnlyOEX);
        SampleEnvelopeReplyHandler[] repliesOEX = new SampleEnvelopeReplyHandler[]{new SampleEnvelopeReplyHandler(), new SampleEnvelopeReplyHandler()};
        SampleReceiveOnlyHandler[] receiversOEX = new SampleReceiveOnlyHandler[]{new SampleReceiveOnlyHandler(), new SampleReceiveOnlyHandler()};
        mgr.getIncomingJmsFactory().registerHandlerOEX((ReplyHandler)repliesOEX[0], senderName, true, replyName, true);
        mgr.getIncomingJmsFactory().registerHandlerOEX((ReplyHandler)repliesOEX[1], senderName, true, TEST_REPLY_IGNORED, true);
        mgr.getIncomingJmsFactory().registerHandlerOEX((ReceiveOnlyHandler)receiversOEX[0], replyName, true);
        mgr.getIncomingJmsFactory().registerHandlerOEX((ReceiveOnlyHandler)receiversOEX[1], replyName, true);
        JmsManagerTest.single(mgr.getOutgoingJmsFactory().createJmsTemplateX(senderName, true), repliesOEX, receiversOEX);
        senderName = "sender-bsx";
        replyName = "reply-bsx";
        SampleBrokerStatusHandler replyBSX = new SampleBrokerStatusHandler();
        SampleReceiveOnlyHandler receiveOnlyBSX = new SampleReceiveOnlyHandler();
        mgr.getIncomingJmsFactory().registerHandlerBSX((ReplyHandler)replyBSX, senderName, false, replyName, false);
        mgr.getIncomingJmsFactory().registerHandlerBSX(receiveOnlyBSX, replyName, false);
        JmsManagerTest.single(mgr.getOutgoingJmsFactory().createJmsTemplateX(senderName, false), replyBSX, receiveOnlyBSX);
        SampleBrokerStatusHandler[] repliesBSX = new SampleBrokerStatusHandler[]{new SampleBrokerStatusHandler(), new SampleBrokerStatusHandler()};
        SampleReceiveOnlyHandler[] receiversBSX = new SampleReceiveOnlyHandler[]{new SampleReceiveOnlyHandler(), new SampleReceiveOnlyHandler()};
        mgr.getIncomingJmsFactory().registerHandlerBSX((ReplyHandler)repliesBSX[0], senderName, true, replyName, true);
        mgr.getIncomingJmsFactory().registerHandlerBSX((ReplyHandler)repliesBSX[1], senderName, true, TEST_REPLY_IGNORED, true);
        mgr.getIncomingJmsFactory().registerHandlerBSX((ReceiveOnlyHandler)receiversBSX[0], replyName, true);
        mgr.getIncomingJmsFactory().registerHandlerBSX((ReceiveOnlyHandler)receiversBSX[1], replyName, true);
        JmsManagerTest.single(mgr.getOutgoingJmsFactory().createJmsTemplateX(senderName, true), repliesBSX, receiversBSX);
    }
}

