/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.jms;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.marketcetera.client.jms.JMSXMLMessageConverter;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: SchemaGen.java 16994 2015-03-09 21:18:25Z colin $")
public class SchemaGen {
    public static void main(String[] args) {
        try {
            JMSXMLMessageConverter j = new JMSXMLMessageConverter();
            j.getContext().generateSchema(new SchemaOutputResolver(){

                public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                    URI u;
                    try {
                        u = new URI(namespaceUri);
                    }
                    catch (URISyntaxException e) {
                        throw new IOException(e);
                    }
                    String name = u.getPath();
                    if (name != null && name.startsWith("/")) {
                        name = name.length() > 1 ? name.substring(1) : null;
                    }
                    name = name != null ? name.replace('/', '_') + ".xsd" : suggestedFileName;
                    File f = new File("target", name);
                    SLF4JLoggerProxy.info((Object)((Object)this), (String)"Writing Schema {} to File: {}", (Object[])new Object[]{namespaceUri, f.getAbsolutePath()});
                    return new StreamResult(f);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

