/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.utils;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.client.ClientFactory;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.Messages;
import org.marketcetera.client.MockClient;
import org.marketcetera.client.utils.AutoOrderHistoryManager;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.utils.OrderHistoryManagerTest;

public class AutoOrderHistoryManagerTest {
    private static MockClient client;
    private static final AtomicInteger counter;

    @BeforeClass
    public static void once() throws Exception {
        ClientManager.setClientFactory((ClientFactory)new MockClient.MockClientFactory());
        ClientManager.init(null);
        client = (MockClient)ClientManager.getInstance();
        OrderHistoryManagerTest.once();
    }

    @Test
    public void testConstructor() throws Exception {
        AutoOrderHistoryManager manager = new AutoOrderHistoryManager(null);
        Assert.assertEquals((Object)new Date(0L), (Object)manager.getReportHistoryOrigin());
        manager = new AutoOrderHistoryManager(new Date(Long.MIN_VALUE));
        Assert.assertEquals((Object)new Date(Long.MIN_VALUE), (Object)manager.getReportHistoryOrigin());
        manager = new AutoOrderHistoryManager(new Date(Long.MAX_VALUE));
        Assert.assertEquals((Object)new Date(Long.MAX_VALUE), (Object)manager.getReportHistoryOrigin());
        manager = new AutoOrderHistoryManager(new Date(0L));
        Assert.assertEquals((Object)new Date(0L), (Object)manager.getReportHistoryOrigin());
    }

    @Test
    public void testAddNotAllowed() throws Exception {
        final AutoOrderHistoryManager manager = new AutoOrderHistoryManager(null);
        new ExpectedFailure<UnsupportedOperationException>(Messages.DONT_ADD_REPORTS.getText()){

            protected void run() throws Exception {
                manager.add(null);
            }
        };
        new ExpectedFailure<UnsupportedOperationException>(Messages.DONT_ADD_REPORTS.getText()){

            protected void run() throws Exception {
                manager.add((ReportBase)OrderHistoryManagerTest.generateExecutionReport((String)"order", null, (OrderStatus)OrderStatus.New));
            }
        };
    }

    @Test
    public void testReceiveExecutionReport() throws Exception {
        AutoOrderHistoryManager orderManager = new AutoOrderHistoryManager(null);
        orderManager.start();
        ExecutionReport report1 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), null, (OrderStatus)OrderStatus.New);
        Map actualOpenOrders = orderManager.getOpenOrders();
        Assert.assertTrue((boolean)actualOpenOrders.isEmpty());
        orderManager.receiveExecutionReport(null);
        Assert.assertTrue((boolean)actualOpenOrders.isEmpty());
        orderManager.receiveExecutionReport(report1);
        Assert.assertEquals((long)1L, (long)actualOpenOrders.size());
        Assert.assertEquals((Object)report1, actualOpenOrders.values().iterator().next());
    }

    @Test
    public void testReceiveOrderCancelReject() throws Exception {
        AutoOrderHistoryManager orderManager = new AutoOrderHistoryManager(null);
        orderManager.start();
        Map actualOpenOrders = orderManager.getOpenOrders();
        Assert.assertTrue((boolean)actualOpenOrders.isEmpty());
        orderManager.receiveCancelReject(null);
        Assert.assertTrue((boolean)actualOpenOrders.isEmpty());
        ExecutionReport report1 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), null, (OrderStatus)OrderStatus.PendingNew);
        ExecutionReport report2 = OrderHistoryManagerTest.generateExecutionReport((String)report1.getOrderID().getValue(), null, (OrderStatus)OrderStatus.New);
        ExecutionReport report3 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), (String)report2.getOrderID().getValue(), (OrderStatus)OrderStatus.PendingCancel);
        OrderCancelReject report4 = OrderHistoryManagerTest.generateOrderCancelReject((String)report2.getOrderID().getValue(), (String)report3.getOrderID().getValue());
        orderManager.receiveExecutionReport(report1);
        Assert.assertEquals((long)1L, (long)actualOpenOrders.size());
        Assert.assertEquals((Object)report1, actualOpenOrders.values().iterator().next());
        orderManager.receiveExecutionReport(report2);
        Assert.assertEquals((long)1L, (long)actualOpenOrders.size());
        Assert.assertEquals((Object)report2, actualOpenOrders.values().iterator().next());
        orderManager.receiveExecutionReport(report3);
        Assert.assertEquals((long)1L, (long)actualOpenOrders.size());
        Assert.assertEquals((Object)report3, actualOpenOrders.values().iterator().next());
        orderManager.receiveCancelReject(report4);
        Assert.assertTrue((boolean)actualOpenOrders.isEmpty());
    }

    @Test
    public void testStartAndStop() throws Exception {
        AutoOrderHistoryManager orderManager = new AutoOrderHistoryManager(null);
        Set orderIDs = orderManager.getOrderIds();
        Assert.assertTrue((boolean)orderIDs.isEmpty());
        ExecutionReport report1 = OrderHistoryManagerTest.generateExecutionReport((String)("order-" + counter.incrementAndGet()), null, (OrderStatus)OrderStatus.PendingNew);
        client.sendToListeners((ReportBase)report1);
        Assert.assertTrue((boolean)orderIDs.isEmpty());
        orderManager.start();
        client.sendToListeners((ReportBase)report1);
        Assert.assertEquals((long)1L, (long)orderIDs.size());
        Assert.assertEquals((Object)report1.getOrderID(), orderIDs.iterator().next());
        orderManager.stop();
        Assert.assertTrue((boolean)orderIDs.isEmpty());
        ExecutionReport report2 = OrderHistoryManagerTest.generateExecutionReport((String)report1.getOrderID().getValue(), null, (OrderStatus)OrderStatus.New);
        client.sendToListeners((ReportBase)report2);
        Assert.assertTrue((boolean)orderIDs.isEmpty());
    }

    static {
        counter = new AtomicInteger(0);
    }
}

