/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import java.beans.ExceptionListener;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.marketcetera.client.BrokerStatusPublisher;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.OrderModifier;
import org.marketcetera.client.OrderValidationException;
import org.marketcetera.client.ReportPublisher;
import org.marketcetera.client.brokers.BrokersStatus;
import org.marketcetera.client.users.UserInfo;
import org.marketcetera.core.notifications.ServerStatusListener;
import org.marketcetera.core.position.PositionKey;
import org.marketcetera.event.Event;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Currency;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReportImpl;
import org.marketcetera.trade.FIXMessageWrapper;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Hierarchy;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.ReportBase;
import org.marketcetera.trade.ReportBaseImpl;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.tags.SessionId;

@ClassVersion(value="$Id: Client.java 17411 2017-04-28 14:50:38Z colin $")
public interface Client
extends ReportPublisher,
BrokerStatusPublisher {
    public void sendOrder(OrderSingle var1) throws ConnectionException, OrderValidationException;

    public void sendOrder(OrderReplace var1) throws ConnectionException, OrderValidationException;

    public void sendOrder(OrderCancel var1) throws ConnectionException, OrderValidationException;

    public void sendOrderRaw(FIXOrder var1) throws ConnectionException, OrderValidationException;

    public void sendEvent(Event var1) throws ConnectionException;

    public ReportBase[] getReportsSince(Date var1) throws ConnectionException;

    public BigDecimal getEquityPositionAsOf(Date var1, Equity var2) throws ConnectionException;

    public Map<PositionKey<Equity>, BigDecimal> getAllEquityPositionsAsOf(Date var1) throws ConnectionException;

    public BigDecimal getFuturePositionAsOf(Date var1, Future var2) throws ConnectionException;

    public Map<PositionKey<Future>, BigDecimal> getAllFuturePositionsAsOf(Date var1) throws ConnectionException;

    public BigDecimal getOptionPositionAsOf(Date var1, Option var2) throws ConnectionException;

    public Map<PositionKey<Option>, BigDecimal> getAllOptionPositionsAsOf(Date var1) throws ConnectionException;

    public Map<PositionKey<Option>, BigDecimal> getOptionPositionsAsOf(Date var1, String ... var2) throws ConnectionException;

    public BigDecimal getCurrencyPositionAsOf(Date var1, Currency var2) throws ConnectionException;

    public Map<PositionKey<Currency>, BigDecimal> getAllCurrencyPositionsAsOf(Date var1) throws ConnectionException;

    public String getUnderlying(String var1) throws ConnectionException;

    public Collection<String> getOptionRoots(String var1) throws ConnectionException;

    public void addServerStatusListener(ServerStatusListener var1);

    public void removeServerStatusListener(ServerStatusListener var1);

    public void addExceptionListener(ExceptionListener var1);

    public void removeExceptionListener(ExceptionListener var1);

    public void close();

    public void reconnect() throws ConnectionException;

    public void reconnect(ClientParameters var1) throws ConnectionException;

    public ClientParameters getParameters();

    public Date getLastConnectTime();

    public BrokersStatus getBrokersStatus() throws ConnectionException;

    public UserInfo getUserInfo(UserID var1, boolean var2) throws ConnectionException;

    public boolean isCredentialsMatch(String var1, char[] var2);

    public boolean isServerAlive();

    public void setUserData(Properties var1) throws ConnectionException;

    public Properties getUserData() throws ConnectionException;

    public void addReport(FIXMessageWrapper var1, BrokerID var2, Hierarchy var3) throws ConnectionException;

    public void deleteReport(ExecutionReportImpl var1) throws ConnectionException;

    public Instrument resolveSymbol(String var1) throws ConnectionException;

    public List<ReportBaseImpl> getOpenOrders() throws ConnectionException;

    public OrderID findRootOrderIdFor(OrderID var1);

    public SessionId getSessionId();

    public void addOrderModifier(OrderModifier var1);

    public void removeOrderModifier(OrderModifier var1);
}

