/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.Validate;
import org.marketcetera.client.Client;
import org.marketcetera.client.ClientFactory;
import org.marketcetera.client.ClientImpl;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ClientInitListener;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.Messages;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: ClientManager.java 17411 2017-04-28 14:50:38Z colin $")
public final class ClientManager {
    private static volatile ClientFactory mClientFactory = new ClientFactory(){

        @Override
        public Client getClient(ClientParameters inParameters) throws ClientInitException, ConnectionException {
            return new ClientImpl(inParameters);
        }
    };
    private static volatile Client client;
    private ClientParameters parameters;
    private static final Set<ClientInitListener> clientInitListeners;

    @PostConstruct
    public void start() {
        Validate.isTrue((this.parameters != null || client != null ? 1 : 0) != 0);
        if (!ClientManager.isInitialized()) {
            ClientManager.init(this.parameters);
        }
    }

    public ClientParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(ClientParameters inParameters) {
        this.parameters = inParameters;
    }

    public Client getClient() {
        return client;
    }

    public void setClient(Client inClient) {
        client = inClient;
    }

    public static synchronized void init(ClientParameters inParameter) throws ConnectionException, ClientInitException {
        if (ClientManager.isInitialized()) {
            throw new ClientInitException((I18NBoundMessage)Messages.CLIENT_ALREADY_INITIALIZED);
        }
        client = mClientFactory.getClient(inParameter);
        ClientManager.notifyClientInitListeners();
    }

    public static synchronized void setClientFactory(ClientFactory inFactory) throws ClientInitException {
        if (ClientManager.isInitialized()) {
            throw new ClientInitException((I18NBoundMessage)Messages.CLIENT_ALREADY_INITIALIZED);
        }
        mClientFactory = inFactory;
    }

    public static Client getInstance() throws ClientInitException {
        if (ClientManager.isInitialized()) {
            return client;
        }
        throw new ClientInitException((I18NBoundMessage)Messages.CLIENT_NOT_INITIALIZED);
    }

    public static boolean isInitialized() {
        return client != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addClientInitListener(ClientInitListener inClientInitListener) {
        if (ClientManager.isInitialized()) {
            ClientManager.notifyClientInitListener(inClientInitListener);
        } else {
            Set<ClientInitListener> set = clientInitListeners;
            synchronized (set) {
                clientInitListeners.add(inClientInitListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeClientInitListener(ClientInitListener inClientInitListener) {
        Set<ClientInitListener> set = clientInitListeners;
        synchronized (set) {
            clientInitListeners.remove(inClientInitListener);
        }
    }

    static synchronized void reset() {
        client = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyClientInitListeners() {
        Set<ClientInitListener> set = clientInitListeners;
        synchronized (set) {
            for (ClientInitListener clientInitListener : clientInitListeners) {
                ClientManager.notifyClientInitListener(clientInitListener);
            }
        }
    }

    private static void notifyClientInitListener(ClientInitListener inClientInitListener) {
        try {
            inClientInitListener.receiveClient(client);
        }
        catch (Exception e) {
            SLF4JLoggerProxy.warn(ClientManager.class, (Throwable)e);
        }
    }

    static {
        clientInitListeners = Sets.newLinkedHashSet();
    }
}

