/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.brokers;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.marketcetera.algo.BrokerAlgoSpec;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.util.misc.ClassVersion;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@ClassVersion(value="$Id: BrokerStatus.java 17411 2017-04-28 14:50:38Z colin $")
public class BrokerStatus
implements Serializable,
Comparable<BrokerStatus> {
    public static final String NO_HOST = "none";
    private final String name;
    private final BrokerID brokerId;
    private final boolean loggedOn;
    private final Set<BrokerAlgoSpec> brokerAlgos = Sets.newHashSet();
    private final Map<String, String> settings = Maps.newHashMap();
    private static final String socketConnectHostKey = "SocketConnectHost";
    private static final String socketConnectPortKey = "SocketConnectPort";
    private static final String socketAcceptHostKey = "SocketAcceptHost";
    private static final String socketAcceptPortKey = "SocketAcceptPort";
    private static final long serialVersionUID = -4170685026349637823L;

    public BrokerStatus(String inName, BrokerID inBrokerId, boolean inLoggedOn, Map<String, String> inSettings, Set<BrokerAlgoSpec> inAlgoSpecs) {
        this.name = inName;
        this.brokerId = inBrokerId;
        this.loggedOn = inLoggedOn;
        if (inSettings != null) {
            this.settings.putAll(inSettings);
        }
        if (inAlgoSpecs != null) {
            this.brokerAlgos.addAll(inAlgoSpecs);
        }
    }

    public BrokerStatus(String inName, BrokerID inBrokerId, boolean inLoggedOn, Map<String, String> inSettings) {
        this(inName, inBrokerId, inLoggedOn, inSettings, null);
    }

    public BrokerStatus(String inName, BrokerID inBrokerId, boolean inLoggedOn, Set<BrokerAlgoSpec> inAlgoSpecs) {
        this(inName, inBrokerId, inLoggedOn, null, inAlgoSpecs);
    }

    public BrokerStatus(String inName, BrokerID inBrokerId, boolean inLoggedOn) {
        this(inName, inBrokerId, inLoggedOn, null, null);
    }

    protected BrokerStatus() {
        this.name = null;
        this.brokerId = null;
        this.loggedOn = false;
    }

    public String getName() {
        return this.name;
    }

    public BrokerID getId() {
        return this.brokerId;
    }

    public boolean getLoggedOn() {
        return this.loggedOn;
    }

    public Set<BrokerAlgoSpec> getBrokerAlgos() {
        return this.brokerAlgos;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public String getHost() {
        if (this.settings != null) {
            String connectionType;
            switch (connectionType = this.settings.get("ConnectionType")) {
                case "acceptor": {
                    return this.settings.get(socketAcceptHostKey);
                }
                case "initiator": {
                    return this.settings.get(socketConnectHostKey);
                }
            }
        }
        return NO_HOST;
    }

    public int getPort() {
        if (this.settings != null) {
            String connectionType;
            switch (connectionType = this.settings.get("ConnectionType")) {
                case "acceptor": {
                    return Integer.parseInt(this.settings.get(socketAcceptPortKey));
                }
                case "initiator": {
                    return Integer.parseInt(this.settings.get(socketConnectPortKey));
                }
            }
        }
        return -1;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.brokerId).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerStatus)) {
            return false;
        }
        BrokerStatus other = (BrokerStatus)obj;
        return new EqualsBuilder().append((Object)this.brokerId, (Object)other.brokerId).isEquals();
    }

    public String toString() {
        return String.format("Broker: %s(%s,%s)", String.valueOf(this.getName()), String.valueOf(this.getId()), this.getLoggedOn());
    }

    @Override
    public int compareTo(BrokerStatus inO) {
        return new CompareToBuilder().append((Object)this.brokerId, (Object)inO.brokerId).toComparison();
    }
}

