/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.jms.ConnectionFactory;
import org.marketcetera.client.OrderModifier;
import org.marketcetera.client.config.Messages;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.beans.factory.InitializingBean;

@ClassVersion(value="$Id: SpringConfig.java 17775 2018-11-16 17:21:28Z colin $")
public class SpringConfig
implements InitializingBean {
    private static SpringConfig sSingleton;
    private ConnectionFactory mIncomingCF;
    private ConnectionFactory mOutgoingCF;
    private final Collection<OrderModifier> orderModifiers = new ArrayList<OrderModifier>();

    public SpringConfig() {
        SpringConfig.setSingleton(this);
    }

    public SpringConfig(ConnectionFactory incomingCF, ConnectionFactory outgoingCF, Collection<OrderModifier> inOrderModifiers) throws I18NException {
        this.setIncomingConnectionFactory(incomingCF);
        this.setOutgoingConnectionFactory(outgoingCF);
        if (inOrderModifiers != null) {
            this.orderModifiers.addAll(inOrderModifiers);
        }
        this.afterPropertiesSet();
        SpringConfig.setSingleton(this);
    }

    public static void setSingleton(SpringConfig singleton) {
        sSingleton = singleton;
    }

    public static SpringConfig getSingleton() {
        return sSingleton;
    }

    public void setIncomingConnectionFactory(ConnectionFactory incomingCF) {
        this.mIncomingCF = incomingCF;
    }

    public ConnectionFactory getIncomingConnectionFactory() {
        return this.mIncomingCF;
    }

    public void setOutgoingConnectionFactory(ConnectionFactory outgoingCF) {
        this.mOutgoingCF = outgoingCF;
    }

    public ConnectionFactory getOutgoingConnectionFactory() {
        return this.mOutgoingCF;
    }

    public Collection<OrderModifier> getOrderModifiers() {
        return Collections.unmodifiableCollection(this.orderModifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrderModifiers(Collection<OrderModifier> inOrderModifiers) {
        Collection<OrderModifier> collection = this.orderModifiers;
        synchronized (collection) {
            this.orderModifiers.clear();
            if (inOrderModifiers != null) {
                this.orderModifiers.addAll(inOrderModifiers);
            }
        }
    }

    public void afterPropertiesSet() throws I18NException {
        if (this.getIncomingConnectionFactory() == null) {
            throw new I18NException((I18NBoundMessage)Messages.NO_INCOMING_CONNECTION_FACTORY);
        }
        if (this.getOutgoingConnectionFactory() == null) {
            throw new I18NException((I18NBoundMessage)Messages.NO_OUTGOING_CONNECTION_FACTORY);
        }
    }
}

