/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.instruments;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import org.marketcetera.client.OrderValidationException;
import org.marketcetera.client.instruments.InstrumentValidationHandler;
import org.marketcetera.client.instruments.Messages;
import org.marketcetera.trade.Currency;
import org.marketcetera.trade.Instrument;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: CurrencyValidationHandler")
public class CurrencyValidationHandler
extends InstrumentValidationHandler<Currency> {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    public CurrencyValidationHandler() {
        super(Currency.class);
    }

    @Override
    public void validate(Instrument inInstrument) throws OrderValidationException {
        Currency currency = (Currency)inInstrument;
        CurrencyValidationHandler.validateCurrencySymbol(currency.getSymbol());
        if (currency.getNearTenor() != null && !currency.getNearTenor().isEmpty()) {
            CurrencyValidationHandler.validateTenor(currency.getNearTenor());
        }
        if (currency.getFarTenor() != null && !currency.getFarTenor().isEmpty()) {
            CurrencyValidationHandler.validateTenor(currency.getFarTenor());
        }
    }

    public static void validateCurrencySymbol(String symbol) throws OrderValidationException {
        if (symbol == null || symbol.isEmpty()) {
            return;
        }
        try {
            String[] currencyPair = symbol.split("/");
            if (currencyPair == null || currencyPair.length != 2 || currencyPair[0].equalsIgnoreCase(currencyPair[1])) {
                throw new OrderValidationException((I18NBoundMessage)new I18NBoundMessage1P(Messages.INVALID_CURRENCY_SYMBOL_FORMAT, (Serializable)((Object)symbol)));
            }
        }
        catch (OrderValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OrderValidationException((I18NBoundMessage)new I18NBoundMessage1P(Messages.INVALID_CURRENCY_SYMBOL_FORMAT, (Serializable)((Object)symbol)));
        }
    }

    public static void validateTenor(String tenor) throws OrderValidationException {
        sdf.setLenient(false);
        try {
            sdf.parse(tenor);
        }
        catch (Exception e) {
            throw new OrderValidationException((I18NBoundMessage)new I18NBoundMessage1P(Messages.INVALID_CURRENCY_TENOR_FORMAT, (Serializable)((Object)tenor)));
        }
    }
}

