/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.instruments;

import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.marketcetera.client.OrderValidationException;
import org.marketcetera.client.instruments.InstrumentValidationHandler;
import org.marketcetera.client.instruments.Messages;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: OptionValidationHandler.java 17775 2018-11-16 17:21:28Z colin $")
public class OptionValidationHandler
extends InstrumentValidationHandler<Option> {
    private static final Pattern EXPIRY_PATTERN = Pattern.compile("^(\\d{4})((?:0[1-9])|(?:1[012]))((?:(?:0[1-9])|(?:[12]\\d)|(?:3[01]))|(?:w[1-5]))?$");

    public OptionValidationHandler() {
        super(Option.class);
    }

    @Override
    public void validate(Instrument instrument) throws OrderValidationException {
        Option option = (Option)instrument;
        OptionValidationHandler.validateExpiry(option.getExpiry());
    }

    public static void validateExpiry(String inExpiry) throws OrderValidationException {
        Matcher m = EXPIRY_PATTERN.matcher(inExpiry);
        if (!m.matches()) {
            throw new OrderValidationException((I18NBoundMessage)new I18NBoundMessage1P(Messages.INVALID_OPTION_EXPIRY_FORMAT, (Serializable)((Object)inExpiry)));
        }
    }

    public static void validateExpiryDate(String inExpiry) throws OrderValidationException {
        block8: {
            String last;
            Matcher m = EXPIRY_PATTERN.matcher(inExpiry);
            if (!m.matches()) {
                throw new OrderValidationException((I18NBoundMessage)new I18NBoundMessage1P(Messages.INVALID_OPTION_EXPIRY_FORMAT, (Serializable)((Object)inExpiry)));
            }
            if (m.groupCount() > 2 && (last = m.group(3)) != null && !last.isEmpty()) {
                try {
                    int year = Integer.parseInt(m.group(1));
                    int month = 0 + Integer.parseInt(m.group(2)) - 1;
                    if (last.charAt(0) == 'w') {
                        GregorianCalendar cal = new GregorianCalendar(year, month, 1);
                        cal.setFirstDayOfWeek(1);
                        cal.setMinimalDaysInFirstWeek(4);
                        int week = Integer.parseInt(last.substring(1));
                        if (week > cal.getActualMaximum(4)) {
                            throw new OrderValidationException((I18NBoundMessage)new I18NBoundMessage1P(Messages.INVALID_OPTION_EXPIRY_WEEK, (Serializable)((Object)inExpiry)));
                        }
                        break block8;
                    }
                    int day = Integer.parseInt(last);
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.clear();
                    cal.setLenient(false);
                    cal.set(1, year);
                    cal.set(2, month);
                    cal.set(5, day);
                    try {
                        cal.getTime();
                    }
                    catch (Exception e) {
                        throw new OrderValidationException((I18NBoundMessage)new I18NBoundMessage1P(Messages.INVALID_OPTION_EXPIRY_DAY, (Serializable)((Object)inExpiry)));
                    }
                }
                catch (NumberFormatException e) {
                    throw new OrderValidationException((I18NBoundMessage)new I18NBoundMessage1P(Messages.INVALID_OPTION_EXPIRY_FORMAT, (Serializable)((Object)inExpiry)));
                }
            }
        }
    }
}

