/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.jms;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.client.jms.DataEnvelope;
import org.marketcetera.client.jms.Messages;
import org.marketcetera.event.impl.ConvertibleBondAskEventImpl;
import org.marketcetera.event.impl.ConvertibleBondBidEventImpl;
import org.marketcetera.event.impl.ConvertibleBondImbalanceEvent;
import org.marketcetera.event.impl.ConvertibleBondMarketstatEventImpl;
import org.marketcetera.event.impl.ConvertibleBondTradeEventImpl;
import org.marketcetera.event.impl.CurrencyAskEventImpl;
import org.marketcetera.event.impl.CurrencyBidEventImpl;
import org.marketcetera.event.impl.CurrencyImbalanceEvent;
import org.marketcetera.event.impl.CurrencyMarketstatEventImpl;
import org.marketcetera.event.impl.CurrencyTradeEventImpl;
import org.marketcetera.event.impl.DividendEventImpl;
import org.marketcetera.event.impl.EquityAskEventImpl;
import org.marketcetera.event.impl.EquityBidEventImpl;
import org.marketcetera.event.impl.EquityImbalanceEvent;
import org.marketcetera.event.impl.EquityMarketstatEventImpl;
import org.marketcetera.event.impl.EquityTradeEventImpl;
import org.marketcetera.event.impl.FutureAskEventImpl;
import org.marketcetera.event.impl.FutureBidEventImpl;
import org.marketcetera.event.impl.FutureImbalanceEvent;
import org.marketcetera.event.impl.FutureMarketstatEventImpl;
import org.marketcetera.event.impl.FutureTradeEventImpl;
import org.marketcetera.event.impl.OptionAskEventImpl;
import org.marketcetera.event.impl.OptionBidEventImpl;
import org.marketcetera.event.impl.OptionImbalanceEvent;
import org.marketcetera.event.impl.OptionMarketstatEventImpl;
import org.marketcetera.event.impl.OptionTradeEventImpl;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.RequestID;
import org.marketcetera.trade.FIXResponseImpl;
import org.marketcetera.trade.ReportBaseImpl;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

@ClassVersion(value="$Id: JMSXMLMessageConverter.java 17411 2017-04-28 14:50:38Z colin $")
public class JMSXMLMessageConverter
implements MessageConverter {
    private final LoadingCache<Class<?>, Boolean> supportedContextType = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Boolean>(){

        public Boolean load(Class<?> inKey) throws Exception {
            for (Class theClass : contextTypes) {
                if (!inKey.equals(theClass) && !theClass.isAssignableFrom(inKey)) continue;
                return true;
            }
            return false;
        }
    });
    private final ThreadLocal<Marshaller> mMarshallers = new ThreadLocal();
    private final ThreadLocal<Unmarshaller> mUnmarshallers = new ThreadLocal();
    private final JAXBContext mContext = JAXBContext.newInstance((Class[])contextTypes);
    private static final String JMS_TYPE_PROPERTY = "metc_type";
    private static final Class<?>[] contextTypes = new Class[]{DataEnvelope.class, ReportBaseImpl.class, FIXResponseImpl.class, BrokerStatus.class, ConvertibleBondAskEventImpl.class, ConvertibleBondBidEventImpl.class, ConvertibleBondMarketstatEventImpl.class, ConvertibleBondTradeEventImpl.class, ConvertibleBondImbalanceEvent.class, CurrencyAskEventImpl.class, CurrencyBidEventImpl.class, CurrencyMarketstatEventImpl.class, CurrencyTradeEventImpl.class, CurrencyImbalanceEvent.class, EquityAskEventImpl.class, EquityBidEventImpl.class, EquityMarketstatEventImpl.class, EquityTradeEventImpl.class, EquityImbalanceEvent.class, FutureAskEventImpl.class, FutureBidEventImpl.class, FutureMarketstatEventImpl.class, FutureTradeEventImpl.class, FutureImbalanceEvent.class, OptionAskEventImpl.class, OptionBidEventImpl.class, OptionMarketstatEventImpl.class, OptionTradeEventImpl.class, OptionImbalanceEvent.class, DividendEventImpl.class, RequestID.class, DataFlowID.class, MarketDataRequest.class};

    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        SLF4JLoggerProxy.debug((Object)this, (String)"Converting from JMS {}", (Object[])new Object[]{message});
        if (message instanceof TextMessage) {
            Object object = null;
            try {
                object = this.fromXML(((TextMessage)message).getText());
            }
            catch (JAXBException e) {
                throw new MessageConversionException(new I18NBoundMessage1P(Messages.ERROR_CONVERTING_MESSAGE_TO_OBJECT, (Serializable)((Object)ObjectUtils.toString((Object)object))).getText(), (Throwable)e);
            }
            if (this.isSupported(object)) {
                return object;
            }
            throw new MessageConversionException(new I18NBoundMessage1P(Messages.UNEXPECTED_MESSAGE_RECEIVED, (Serializable)((Object)ObjectUtils.toString((Object)object))).getText());
        }
        throw new MessageConversionException(new I18NBoundMessage1P(Messages.UNEXPECTED_MESSAGE_RECEIVED, (Serializable)((Object)ObjectUtils.toString((Object)message))).getText());
    }

    public Message toMessage(Object inObject, Session session) throws JMSException, MessageConversionException {
        SLF4JLoggerProxy.debug((Object)this, (String)"Converting to JMS {}", (Object[])new Object[]{inObject});
        if (this.isSupported(inObject)) {
            try {
                TextMessage message = session.createTextMessage(this.toXML(inObject));
                message.setStringProperty(JMS_TYPE_PROPERTY, inObject.getClass().getSimpleName());
                return message;
            }
            catch (JAXBException e) {
                throw new MessageConversionException(new I18NBoundMessage1P(Messages.ERROR_CONVERTING_OBJECT_TO_MESSAGE, (Serializable)((Object)ObjectUtils.toString((Object)inObject))).getText(), (Throwable)e);
            }
        }
        throw new MessageConversionException(new I18NBoundMessage1P(Messages.UNEXPECTED_MESSAGE_TO_SEND, (Serializable)((Object)ObjectUtils.toString((Object)inObject))).getText());
    }

    String toXML(Object inObject) throws JAXBException {
        Marshaller marshaller = this.getMarshaller();
        StringWriter writer = new StringWriter();
        marshaller.marshal(inObject, (Writer)writer);
        return writer.toString();
    }

    Object fromXML(String inXML) throws JAXBException {
        Unmarshaller unMarshaller = this.getUnMarshaller();
        StringReader reader = new StringReader(inXML);
        return unMarshaller.unmarshal((Reader)reader);
    }

    JAXBContext getContext() {
        return this.mContext;
    }

    private Marshaller getMarshaller() throws JAXBException {
        Marshaller m = this.mMarshallers.get();
        if (m == null) {
            m = this.mContext.createMarshaller();
            this.mMarshallers.set(m);
        }
        return m;
    }

    private Unmarshaller getUnMarshaller() throws JAXBException {
        Unmarshaller u = this.mUnmarshallers.get();
        if (u == null) {
            u = this.mContext.createUnmarshaller();
            this.mUnmarshallers.set(u);
        }
        return u;
    }

    private boolean isSupported(Object inObject) {
        return (Boolean)this.supportedContextType.getUnchecked(inObject.getClass());
    }
}

