/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.client.jms;

import javax.jms.ConnectionFactory;
import javax.xml.bind.JAXBException;
import org.marketcetera.client.jms.JMSFIXMessageConverter;
import org.marketcetera.client.jms.JMSXMLMessageConverter;
import org.marketcetera.client.jms.JmsFactory;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;

@ClassVersion(value="$Id: OutgoingJmsFactory.java 16154 2012-07-14 16:34:05Z colin $")
public class OutgoingJmsFactory
extends JmsFactory {
    public OutgoingJmsFactory(ConnectionFactory connectionFactory) {
        super(connectionFactory);
    }

    public JmsTemplate createJmsTemplate(String dstName, boolean isDstTopic, MessageConverter messageConverter) {
        JmsTemplate template = new JmsTemplate(this.getConnectionFactory());
        template.setDefaultDestinationName(dstName);
        template.setPubSubDomain(isDstTopic);
        template.setMessageConverter(messageConverter);
        template.afterPropertiesSet();
        return template;
    }

    public JmsTemplate createJmsTemplate(String dstName, boolean isDstTopic) {
        return this.createJmsTemplate(dstName, isDstTopic, (MessageConverter)new SimpleMessageConverter());
    }

    public JmsTemplate createJmsTemplateQ(String dstName, boolean isDstTopic) {
        return this.createJmsTemplate(dstName, isDstTopic, new JMSFIXMessageConverter());
    }

    public JmsTemplate createJmsTemplateX(String dstName, boolean isDstTopic) throws JAXBException {
        return this.createJmsTemplate(dstName, isDstTopic, new JMSXMLMessageConverter());
    }
}

