/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.cluster;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.marketcetera.cluster.CallableClusterTask;
import org.marketcetera.cluster.QueueDescriptor;
import org.marketcetera.cluster.RunnableClusterTask;
import org.marketcetera.cluster.service.AbstractClusterService;
import org.marketcetera.cluster.service.ClusterMember;
import org.marketcetera.cluster.service.ClusterService;
import org.marketcetera.core.PlatformServices;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class SimpleClusterService
extends AbstractClusterService
implements ClusterService {
    private final int hostNumber = 1;
    private final String memberUUID = UUID.randomUUID().toString();
    private volatile boolean active = false;
    private Set<ClusterMember> clusterMembers;
    private ClusterMember thisClusterMember;
    @Autowired
    private ApplicationContext applicationContext;
    private static final String attributeMapName = UUID.randomUUID().toString();
    private final LoadingCache<String, ExecutorService> executorServices = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, ExecutorService>(){

        public ExecutorService load(String inKey) throws Exception {
            return Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("ClusterService%d").build());
        }
    });
    private final LoadingCache<String, BlockingDeque<?>> queues = CacheBuilder.newBuilder().build(new CacheLoader<String, BlockingDeque<?>>(){

        public BlockingDeque<?> load(String inKey) throws Exception {
            return Queues.newLinkedBlockingDeque();
        }
    });
    private final LoadingCache<String, Map<String, String>> maps = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Map<String, String>>(){

        public Map<String, String> load(String inKey) throws Exception {
            return Maps.newConcurrentMap();
        }
    });
    private final LoadingCache<String, Lock> locks = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Lock>(){

        public Lock load(String inKey) throws Exception {
            return new ReentrantLock();
        }
    });

    @PostConstruct
    public void start() {
        this.thisClusterMember = new SimpleClusterMember(this.memberUUID);
        this.clusterMembers = Collections.unmodifiableSet(Sets.newHashSet((Object[])new ClusterMember[]{this.thisClusterMember}));
        super.start();
        this.active = true;
        this.notifyMemberAdded(this.thisClusterMember);
    }

    @PreDestroy
    public void stop() {
        super.stop();
        this.active = false;
    }

    protected String getMemberUuid() {
        return this.memberUUID;
    }

    protected int getHostNumber(String inHostId) {
        return 1;
    }

    protected boolean isActive() {
        return this.active;
    }

    public <Clazz extends Serializable> void addToQueue(QueueDescriptor<Clazz> inQueueDescriptor, Clazz inObject) {
        this.getQueue(inQueueDescriptor).add(inObject);
    }

    public <Clazz extends Serializable> Clazz peekFromQueue(QueueDescriptor<Clazz> inQueueDescriptor) {
        return (Clazz)((Serializable)this.getQueue(inQueueDescriptor).peek());
    }

    public <Clazz extends Serializable> Clazz takeFromQueue(QueueDescriptor<Clazz> inQueueDescriptor) throws InterruptedException {
        return (Clazz)((Serializable)this.getQueue(inQueueDescriptor).take());
    }

    public void execute(RunnableClusterTask inTask) {
        PlatformServices.autowire((Object)inTask, (ApplicationContext)this.applicationContext);
        this.getExecutorService(inTask.getPoolName()).execute((Runnable)inTask);
    }

    public <Clazz extends Serializable> Map<Object, Future<Clazz>> execute(CallableClusterTask<Clazz> inTask) throws Exception {
        PlatformServices.autowire(inTask, (ApplicationContext)this.applicationContext);
        Future<Clazz> token = this.getExecutorService(inTask.getPoolName()).submit(inTask);
        HashMap results = Maps.newHashMap();
        results.put(this.memberUUID, token);
        return Collections.unmodifiableMap(results);
    }

    public Map<String, String> getMap(String inMapName) {
        return Collections.unmodifiableMap(this.getPrivateMap(inMapName));
    }

    public String addToMap(String inMapName, String inKey, String inValue) {
        return this.getPrivateMap(inMapName).put(inKey, inValue);
    }

    public String removeFromMap(String inMapName, String inKey) {
        return this.getPrivateMap(inMapName).remove(inKey);
    }

    public void setAttribute(String inKey, String inValue) {
        this.getPrivateMap(attributeMapName).put(inKey, inValue);
        this.notifyMemberChanged(this.thisClusterMember);
    }

    public String getAttribute(String inKey) {
        return this.getPrivateMap(attributeMapName).get(inKey);
    }

    public Map<String, String> getAttributes(String inUuid) {
        if (this.memberUUID.equals(inUuid)) {
            return Collections.unmodifiableMap(this.getPrivateMap(attributeMapName));
        }
        return Collections.emptyMap();
    }

    public Map<String, Map<String, String>> getAttributes() {
        HashMap allAttributes = Maps.newHashMap();
        allAttributes.put(this.memberUUID, Collections.unmodifiableMap(this.getPrivateMap(attributeMapName)));
        return Collections.unmodifiableMap(allAttributes);
    }

    public void removeAttribute(String inKey) {
        this.getPrivateMap(attributeMapName).remove(inKey);
        this.notifyMemberChanged(this.thisClusterMember);
    }

    public void removeAttribute(String inUuid, String inKey) {
        if (this.memberUUID.equals(inUuid)) {
            this.getPrivateMap(attributeMapName).remove(inKey);
            this.notifyMemberChanged(this.thisClusterMember);
        }
    }

    public Lock getLock(String inLockName) {
        return this.getPrivateLock(inLockName);
    }

    public Set<ClusterMember> getClusterMembers() {
        return this.clusterMembers;
    }

    private <Clazz extends Serializable> BlockingDeque<Clazz> getQueue(QueueDescriptor<Clazz> inQueueDescriptor) {
        return (BlockingDeque)this.queues.getUnchecked((Object)inQueueDescriptor.getQueuename());
    }

    private Map<String, String> getPrivateMap(String inMapName) {
        return (Map)this.maps.getUnchecked((Object)inMapName);
    }

    private ExecutorService getExecutorService(String inPoolName) {
        return (ExecutorService)this.executorServices.getUnchecked((Object)inPoolName);
    }

    private Lock getPrivateLock(String inLockName) {
        return (Lock)this.locks.getUnchecked((Object)inLockName);
    }

    private static class SimpleClusterMember
    implements ClusterMember {
        private final String uuid;

        public String getUuid() {
            return this.uuid;
        }

        public String toString() {
            return this.getUuid();
        }

        private SimpleClusterMember(String inUuid) {
            this.uuid = inUuid;
        }
    }
}

