/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.server;

import com.google.common.collect.Lists;
import io.grpc.BindableService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.jms.ServerSession;
import org.marketcetera.admin.PermissionFactory;
import org.marketcetera.admin.RoleFactory;
import org.marketcetera.admin.UserAttributeFactory;
import org.marketcetera.admin.UserFactory;
import org.marketcetera.admin.auth.DBAuthenticator;
import org.marketcetera.admin.dao.PersistentPermissionFactory;
import org.marketcetera.admin.dao.PersistentRoleFactory;
import org.marketcetera.admin.dao.PersistentUserAttributeFactory;
import org.marketcetera.admin.provisioning.ProvisioningAgent;
import org.marketcetera.admin.rpc.AdminRpcService;
import org.marketcetera.admin.service.BCryptPasswordService;
import org.marketcetera.admin.service.PasswordService;
import org.marketcetera.admin.service.UserAttributeService;
import org.marketcetera.admin.service.UserService;
import org.marketcetera.admin.service.impl.UserAttributeServiceImpl;
import org.marketcetera.admin.service.impl.UserServiceImpl;
import org.marketcetera.admin.user.PersistentUserFactory;
import org.marketcetera.brokers.BrokerSelector;
import org.marketcetera.brokers.service.FixSessionProvider;
import org.marketcetera.cluster.ClusterDataFactory;
import org.marketcetera.cluster.SimpleClusterDataFactory;
import org.marketcetera.cluster.rpc.ClusterRpcService;
import org.marketcetera.core.XmlService;
import org.marketcetera.dataflow.server.rpc.DataFlowRpcService;
import org.marketcetera.eventbus.server.EsperEngine;
import org.marketcetera.eventbus.server.EventBusEsperConnector;
import org.marketcetera.fix.MutableActiveFixSessionFactory;
import org.marketcetera.fix.MutableFixSessionFactory;
import org.marketcetera.fix.ServerFixSessionFactory;
import org.marketcetera.fix.dao.PersistentFixSessionFactory;
import org.marketcetera.fix.dao.PersistentFixSessionProvider;
import org.marketcetera.fix.impl.SimpleActiveFixSessionFactory;
import org.marketcetera.fix.impl.SimpleServerFixSessionFactory;
import org.marketcetera.fix.rpc.FixAdminRpcService;
import org.marketcetera.fix.store.HibernateMessageStoreConfiguration;
import org.marketcetera.marketdata.rpc.server.MarketDataRpcService;
import org.marketcetera.marketdata.service.DirectMarketDataClient;
import org.marketcetera.metrics.MetricServiceDbReporter;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.quickfix.QuickFIXSender;
import org.marketcetera.quickfix.QuickFIXSenderImpl;
import org.marketcetera.rpc.server.RpcServer;
import org.marketcetera.strategy.DirectStrategyClientFactory;
import org.marketcetera.strategy.StrategyRpcServer;
import org.marketcetera.strategy.StrategyService;
import org.marketcetera.strategy.StrategyServiceImpl;
import org.marketcetera.strategy.dao.PersistentStrategyInstanceFactory;
import org.marketcetera.strategy.dao.PersistentStrategyMessageFactory;
import org.marketcetera.symbol.IterativeSymbolResolver;
import org.marketcetera.symbol.PatternSymbolResolver;
import org.marketcetera.symbol.SymbolResolverService;
import org.marketcetera.trade.AverageFillPriceFactory;
import org.marketcetera.trade.BasicSelector;
import org.marketcetera.trade.SimpleAverageFillPriceFactory;
import org.marketcetera.trade.client.DirectTradeClient;
import org.marketcetera.trade.event.connector.IncomingTradeMessageBroadcastConnector;
import org.marketcetera.trade.event.connector.IncomingTradeMessageConverterConnector;
import org.marketcetera.trade.event.connector.IncomingTradeMessagePersistenceConnector;
import org.marketcetera.trade.event.connector.OrderConverterConnector;
import org.marketcetera.trade.event.connector.OutgoingMessageCachingConnector;
import org.marketcetera.trade.event.connector.OutgoingMessagePersistenceConnector;
import org.marketcetera.trade.rpc.server.TradeRpcService;
import org.marketcetera.trade.service.MessageOwnerService;
import org.marketcetera.trade.service.impl.MessageOwnerServiceImpl;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.ws.stateful.Authenticator;
import org.marketcetera.util.ws.stateful.PortUserProxy;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import quickfix.DefaultMessageFactory;
import quickfix.MessageFactory;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

@EnableAutoConfiguration
@SpringBootConfiguration
@EnableTransactionManagement
@EntityScan(basePackages={"org.marketcetera", "com.marketcetera"})
@SpringBootApplication(scanBasePackages={"org.marketcetera", "com.marketcetera"})
@EnableJpaRepositories(basePackages={"org.marketcetera", "com.marketcetera"})
public class DareApplication {
    @Value(value="${metc.security.use.ssl:false}")
    private boolean useSsl;
    @Value(value="${metc.security.ssl.public.key.path:#{null}}")
    private String publicKeyPath;
    @Value(value="${metc.security.ssl.private.key.path:#{null}}")
    private String privateKeyPath;
    @Value(value="${server.port}")
    private int webServerPort;
    @Value(value="${metc.ws.hostname:0.0.0.0}")
    private String serverHostname;
    @Value(value="${metc.rpc.port}")
    private int rpcPort;
    @Value(value="${metc.metric.service.log.reporter.interval:10}")
    private int metricServiceLogReporterInterval;
    @Value(value="${metc.xml.context.path.classes}")
    private List<String> contextPathClasses;
    @Value(value="${metc.provisioning.directory:./instances/provisioning}")
    private String provisioningDirectory;

    public static void main(String[] inArgs) {
        SpringApplication.run(DareApplication.class, (String[])inArgs);
    }

    @PostConstruct
    public void start() {
        SLF4JLoggerProxy.info((Object)this, (String)"Core version {} revision {} timestamp {} repository {} path {}", (Object[])new Object[]{"4.1.0", "", "2023-05-23 19:10:45.764 +0000", "", ""});
    }

    @Bean
    public PasswordService getPasswordService() {
        return new BCryptPasswordService();
    }

    @Bean
    public StrategyService getStrategyService() {
        return new StrategyServiceImpl();
    }

    @Bean
    public ProvisioningAgent getProvisioningAgent() {
        ProvisioningAgent provisioningAgent = new ProvisioningAgent();
        provisioningAgent.setProvisioningDirectory(this.provisioningDirectory);
        return provisioningAgent;
    }

    @Bean
    public XmlService getXmlService() throws ClassNotFoundException {
        XmlService xmlService = new XmlService();
        ArrayList contextPathClassEntries = Lists.newArrayList();
        for (String contextPathEntry : this.contextPathClasses) {
            contextPathClassEntries.add(Class.forName(contextPathEntry));
        }
        SLF4JLoggerProxy.info((Object)this, (String)"Using the");
        xmlService.setContextPath((List)contextPathClassEntries);
        return xmlService;
    }

    @Bean
    public DirectStrategyClientFactory getStrategyClientFactory() {
        DirectStrategyClientFactory strategyClientFactory = new DirectStrategyClientFactory();
        return strategyClientFactory;
    }

    @Bean
    public DirectMarketDataClient getMarketDataClient() {
        return new DirectMarketDataClient();
    }

    @Bean
    public DirectTradeClient getTradeClient() {
        return new DirectTradeClient();
    }

    @Bean
    public PersistentStrategyMessageFactory getStrategyMessageFactory() {
        return new PersistentStrategyMessageFactory();
    }

    @Bean
    public PersistentStrategyInstanceFactory getStrategyInstanceFactory() {
        return new PersistentStrategyInstanceFactory();
    }

    @Bean
    public AverageFillPriceFactory getAverageFillPriceFactory() {
        return new SimpleAverageFillPriceFactory();
    }

    @Bean
    public HibernateMessageStoreConfiguration getMessageStoreConfiguration() {
        return new HibernateMessageStoreConfiguration();
    }

    @Bean
    public UserService getUserService() {
        return new UserServiceImpl();
    }

    @Bean
    public FixSessionProvider getFixSessionProvider() {
        return new PersistentFixSessionProvider();
    }

    @Bean
    public MessageFactory getMessageFactory() {
        return new DefaultMessageFactory();
    }

    @Bean
    public ClusterDataFactory getClusterDataFactory() {
        return new SimpleClusterDataFactory();
    }

    @Bean
    public MutableFixSessionFactory getMutableFixSessionFactory() {
        return new PersistentFixSessionFactory();
    }

    @Bean
    public MutableActiveFixSessionFactory getMutableActiveFixSessionFactory() {
        return new SimpleActiveFixSessionFactory();
    }

    @Bean
    public ServerFixSessionFactory getServerFixSessionFactory() {
        return new SimpleServerFixSessionFactory();
    }

    @Bean
    public MessageOwnerService getMessageOwnerService() {
        return new MessageOwnerServiceImpl();
    }

    @Bean
    public QuickFIXSender getQuickFixSender() {
        return new QuickFIXSenderImpl();
    }

    @Bean
    public MetricServiceDbReporter getMetricServiceReporter() {
        MetricServiceDbReporter metricServiceReporter = new MetricServiceDbReporter();
        metricServiceReporter.setReportInterval(this.metricServiceLogReporterInterval);
        return metricServiceReporter;
    }

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2).select().apis(RequestHandlerSelectors.any()).paths(PathSelectors.ant((String)"/matp/*")).build().apiInfo(this.apiInfo());
    }

    @Bean
    public PortUserProxy getEmbeddedWebServerPortUserProxy() {
        PortUserProxy proxy = new PortUserProxy();
        proxy.setPort(this.webServerPort);
        proxy.setDescription("DARE Web Server");
        return proxy;
    }

    @Bean
    public RpcServer getRpcServer(@Autowired(required=false) List<BindableService> inServiceSpecs) throws Exception {
        RpcServer rpcServer = new RpcServer();
        rpcServer.setHostname(this.serverHostname);
        rpcServer.setPort(this.rpcPort);
        rpcServer.setUseSsl(this.useSsl);
        if (this.useSsl) {
            File publicKey = new File(this.publicKeyPath);
            File privateKey = new File(this.privateKeyPath);
            rpcServer.setPublicKey(publicKey);
            rpcServer.setPrivateKey(privateKey);
        }
        if (inServiceSpecs != null) {
            for (BindableService service : inServiceSpecs) {
                rpcServer.getServerServiceDefinitions().add(service);
            }
        }
        return rpcServer;
    }

    @Bean
    public AdminRpcService<ServerSession> getAdminRpcService(@Autowired Authenticator inAuthenticator, @Autowired SessionManager<ServerSession> inSessionManager) {
        AdminRpcService adminRpcService = new AdminRpcService();
        adminRpcService.setAuthenticator(inAuthenticator);
        adminRpcService.setSessionManager(inSessionManager);
        return adminRpcService;
    }

    @Bean
    public TradeRpcService<ServerSession> getTradeRpcService(@Autowired Authenticator inAuthenticator, @Autowired SessionManager<ServerSession> inSessionManager) {
        TradeRpcService tradeRpcService = new TradeRpcService();
        tradeRpcService.setAuthenticator(inAuthenticator);
        tradeRpcService.setSessionManager(inSessionManager);
        return tradeRpcService;
    }

    @Bean
    public StrategyRpcServer<ServerSession> getStrategyRpcService(@Autowired Authenticator inAuthenticator, @Autowired SessionManager<ServerSession> inSessionManager) {
        StrategyRpcServer strategyRpcServer = new StrategyRpcServer();
        strategyRpcServer.setAuthenticator(inAuthenticator);
        strategyRpcServer.setSessionManager(inSessionManager);
        return strategyRpcServer;
    }

    @Bean
    public FixAdminRpcService<ServerSession> getFixAdminRpcService(@Autowired Authenticator inAuthenticator, @Autowired SessionManager<ServerSession> inSessionManager) {
        FixAdminRpcService fixAdminRpcService = new FixAdminRpcService();
        fixAdminRpcService.setAuthenticator(inAuthenticator);
        fixAdminRpcService.setSessionManager(inSessionManager);
        return fixAdminRpcService;
    }

    @Bean
    public DataFlowRpcService<ServerSession> getDataFlowRpcService(@Autowired Authenticator inAuthenticator, @Autowired SessionManager<ServerSession> inSessionManager) {
        DataFlowRpcService dataFlowRpcService = new DataFlowRpcService();
        dataFlowRpcService.setAuthenticator(inAuthenticator);
        dataFlowRpcService.setSessionManager(inSessionManager);
        return dataFlowRpcService;
    }

    @Bean
    public MarketDataRpcService<ServerSession> getMarketDataRpcService(@Autowired Authenticator inAuthenticator, @Autowired SessionManager<ServerSession> inSessionManager) {
        MarketDataRpcService marketDataRpcService = new MarketDataRpcService();
        marketDataRpcService.setAuthenticator(inAuthenticator);
        marketDataRpcService.setSessionManager(inSessionManager);
        return marketDataRpcService;
    }

    @Bean
    public ClusterRpcService<ServerSession> getClusterRpcService(@Autowired Authenticator inAuthenticator, @Autowired SessionManager<ServerSession> inSessionManager) {
        ClusterRpcService clusterRpcService = new ClusterRpcService();
        clusterRpcService.setAuthenticator(inAuthenticator);
        clusterRpcService.setSessionManager(inSessionManager);
        return clusterRpcService;
    }

    @Bean
    public ModuleManager getModuleManager() {
        ModuleManager moduleManager = ModuleManager.getInstance();
        if (moduleManager == null) {
            moduleManager = new ModuleManager();
            moduleManager.init();
        }
        return moduleManager;
    }

    @Bean
    public SymbolResolverService getSymbolResolverService() {
        IterativeSymbolResolver symbolResolverService = new IterativeSymbolResolver();
        symbolResolverService.getSymbolResolvers().add(new PatternSymbolResolver());
        return symbolResolverService;
    }

    @Bean
    public Authenticator getAuthenticator() {
        return new DBAuthenticator();
    }

    @Bean
    public SessionManager<ServerSession> getSessionManager() {
        return new SessionManager();
    }

    @Bean
    public UserAttributeFactory getUserAttributeFactory() {
        return new PersistentUserAttributeFactory();
    }

    @Bean
    public UserAttributeService getUserAttributeService() {
        return new UserAttributeServiceImpl();
    }

    @Bean
    public BrokerSelector getBrokerSelector() {
        return new BasicSelector();
    }

    @Bean
    public OrderConverterConnector getOrderConverterConnector() {
        return new OrderConverterConnector();
    }

    @Bean
    public OutgoingMessageCachingConnector getOutgoingMessageCachingConnector() {
        return new OutgoingMessageCachingConnector();
    }

    @Bean
    public OutgoingMessagePersistenceConnector getOutgoingMessagePersistenceConnector() {
        return new OutgoingMessagePersistenceConnector();
    }

    @Bean
    public IncomingTradeMessageConverterConnector getIncomingTradeMessageConverterConnector() {
        return new IncomingTradeMessageConverterConnector();
    }

    @Bean
    public IncomingTradeMessagePersistenceConnector getIncomingTradeMessagePersistenceConnector() {
        return new IncomingTradeMessagePersistenceConnector();
    }

    @Bean
    public IncomingTradeMessageBroadcastConnector getIncomingTradeMessageBroadcastConnector() {
        return new IncomingTradeMessageBroadcastConnector();
    }

    @Bean
    public EsperEngine getEsperEngine() {
        EsperEngine esperEngine = new EsperEngine();
        return esperEngine;
    }

    @Bean
    public EventBusEsperConnector getEventBusEsperConnector() {
        EventBusEsperConnector eventBusEsperConnector = new EventBusEsperConnector();
        return eventBusEsperConnector;
    }

    @Bean
    public PermissionFactory getPermissionFactory() {
        return new PersistentPermissionFactory();
    }

    @Bean
    public RoleFactory getRoleFactory() {
        return new PersistentRoleFactory();
    }

    @Bean
    public UserFactory getUserFactory() {
        return new PersistentUserFactory();
    }

    private ApiInfo apiInfo() {
        return new ApiInfo("Marketcetera Automated Trading Engine REST API", "REST API for MATP", "API TOS", "Terms of service", new Contact("Colin DuPlantis", "www.marketcetera.com", "info@marketcetera.com"), "License of API", "API license URL", Collections.emptyList());
    }
}

