/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.eventbus.server;

import com.google.common.collect.Maps;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.marketcetera.eventbus.EventBusService;
import org.marketcetera.eventbus.server.EsperEngine;
import org.marketcetera.eventbus.server.EsperQueryMetaData;
import org.marketcetera.eventbus.server.EventBusServerTestConfiguration;
import org.marketcetera.eventbus.server.HasId;
import org.marketcetera.eventbus.server.TestAutoregisteredEventBean;
import org.marketcetera.eventbus.server.TestManuallyRegisteredEventBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@EntityScan(basePackages={"org.marketcetera"})
@ComponentScan(basePackages={"org.marketcetera"})
@SpringBootTest(classes={EventBusServerTestConfiguration.class})
public class EventBusServerEsperTest {
    @Autowired
    private EsperEngine esperEngine;
    @Autowired
    private EventBusService eventBusService;

    @Test
    public void testEvents() throws Exception {
        this.doEventTest(new TestAutoregisteredEventBean());
        this.doEventTest(new TestManuallyRegisteredEventBean());
    }

    private void doEventTest(HasId inEvent) throws Exception {
        String matchingEpl = "select * from " + inEvent.getClass().getSimpleName();
        EsperQueryMetaData queryMetaData = this.esperEngine.deployStatement(matchingEpl);
        HashMap matchingEventsReceived = Maps.newHashMap();
        matchingEventsReceived.put(inEvent.getId(), false);
        queryMetaData.getEsperStatement().addListener((newData, oldData, statement, runtime) -> {
            String id = (String)newData[0].get("id");
            matchingEventsReceived.put(id, true);
        });
        this.eventBusService.post((Object)inEvent);
        Assertions.assertTrue((boolean)((Boolean)matchingEventsReceived.get(inEvent.getId())));
        matchingEventsReceived.put(inEvent.getId(), false);
        this.eventBusService.post((Object)this);
        Assertions.assertFalse((boolean)((Boolean)matchingEventsReceived.get(inEvent.getId())));
        this.esperEngine.undeployStatement(queryMetaData);
        matchingEventsReceived.clear();
        this.eventBusService.post((Object)inEvent);
        Assertions.assertTrue((boolean)matchingEventsReceived.isEmpty());
    }
}

