/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.eventbus.server;

import com.espertech.esper.common.client.EPCompiled;
import com.espertech.esper.common.client.configuration.Configuration;
import com.espertech.esper.compiler.client.CompilerArguments;
import com.espertech.esper.compiler.client.EPCompileException;
import com.espertech.esper.compiler.client.EPCompiler;
import com.espertech.esper.compiler.client.EPCompilerProvider;
import com.espertech.esper.runtime.client.EPDeployException;
import com.espertech.esper.runtime.client.EPDeployment;
import com.espertech.esper.runtime.client.EPRuntime;
import com.espertech.esper.runtime.client.EPRuntimeDestroyedException;
import com.espertech.esper.runtime.client.EPRuntimeProvider;
import com.espertech.esper.runtime.client.EPStatement;
import com.espertech.esper.runtime.client.EPUndeployException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.marketcetera.eventbus.EsperEvent;
import org.marketcetera.eventbus.HasEsperEvent;
import org.marketcetera.eventbus.server.EsperQueryMetaData;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.ApplicationContext;

@EnableAutoConfiguration
public class EsperEngine {
    private Configuration configuration;
    private EPRuntime runtime;
    private final Collection<Class<?>> eventTypes = Lists.newArrayList();
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${metc.esper.runtime.name:MATP}")
    private String runtimeName;

    @PostConstruct
    public void start() {
        this.configuration = new Configuration();
        HashSet eventTypeCollection = Sets.newHashSet(this.eventTypes);
        Map esperEventTypes = this.applicationContext.getBeansOfType(EsperEvent.class);
        esperEventTypes.values().forEach(esperEvent -> eventTypeCollection.add(esperEvent.getClass()));
        Map hasEsperEventTypes = this.applicationContext.getBeansOfType(HasEsperEvent.class);
        hasEsperEventTypes.values().forEach(hasEsperEvent -> eventTypeCollection.add(hasEsperEvent.getEsperEvent().getClass()));
        eventTypeCollection.forEach(eventType -> this.configuration.getCommon().addEventType(eventType));
        SLF4JLoggerProxy.debug((Object)this, (String)"Adding the following event type(s): {}", (Object[])new Object[]{eventTypeCollection});
        this.runtime = EPRuntimeProvider.getRuntime((String)this.runtimeName, (Configuration)this.configuration);
        this.runtime.initialize();
        SLF4JLoggerProxy.info((Object)this, (String)"Created Esper runtime: {}", (Object[])new Object[]{this.runtimeName});
    }

    @PreDestroy
    public void stop() {
        if (this.runtime != null) {
            try {
                this.runtime.destroy();
            }
            catch (Exception exception) {
            }
            finally {
                this.runtime = null;
            }
        }
    }

    public EsperQueryMetaData deployStatement(String inStatement) throws EPRuntimeDestroyedException, EPDeployException, EPCompileException {
        String statementId = UUID.randomUUID().toString();
        CompilerArguments args = new CompilerArguments(this.configuration);
        EPCompiler compiler = EPCompilerProvider.getCompiler();
        EPCompiled epCompiled = compiler.compile("@name('" + statementId + "') " + inStatement, args);
        EPDeployment deployment = this.runtime.getDeploymentService().deploy(epCompiled);
        EPStatement statement = this.runtime.getDeploymentService().getStatement(deployment.getDeploymentId(), statementId);
        return new EsperQueryMetaData(statementId, statement);
    }

    public void undeployStatement(EsperQueryMetaData inQueryMetaData) throws EPRuntimeDestroyedException, EPUndeployException {
        this.runtime.getDeploymentService().undeploy(inQueryMetaData.getEsperStatement().getDeploymentId());
    }

    public Collection<Class<?>> getEventTypes() {
        return this.eventTypes;
    }

    public EPRuntime getRuntime() {
        return this.runtime;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

