/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.eventbus.server;

import com.codahale.metrics.Meter;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.eventbus.EsperEvent;
import org.marketcetera.eventbus.EventBusService;
import org.marketcetera.eventbus.HasEsperEvent;
import org.marketcetera.eventbus.server.EsperEngine;
import org.marketcetera.metrics.MetricService;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;

public class EventBusEsperConnector {
    private Meter esperEventMetric;
    @Autowired
    private MetricService metricsService;
    @Autowired
    private EventBusService eventBusService;
    @Autowired
    private EsperEngine esperRuntime;

    @PostConstruct
    public void start() {
        String name = PlatformServices.getServiceName(this.getClass());
        this.esperEventMetric = this.metricsService.getMetrics().meter(name);
        this.eventBusService.register((Object)this);
    }

    @PreDestroy
    public void stop() {
        this.eventBusService.unregister((Object)this);
    }

    @Subscribe
    public void receiveEvents(EsperEvent inEvent) {
        this.processEvent(inEvent);
    }

    @Subscribe
    public void receiveEvents(HasEsperEvent inEvent) {
        this.processEvent(inEvent.getEsperEvent());
    }

    private void processEvent(EsperEvent inEvent) {
        SLF4JLoggerProxy.trace((Object)this, (String)"Passing {} to Esper", (Object[])new Object[]{inEvent});
        this.esperEventMetric.mark();
        this.esperRuntime.getRuntime().getEventService().sendEventBean((Object)inEvent, inEvent.getEventName());
    }
}

