/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.fix.rpc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.Validate;
import org.marketcetera.admin.AdminPermissions;
import org.marketcetera.admin.service.AuthorizationService;
import org.marketcetera.brokers.BrokerStatusListener;
import org.marketcetera.brokers.service.BrokerService;
import org.marketcetera.brokers.service.FixSessionProvider;
import org.marketcetera.fix.AcceptorSessionAttributes;
import org.marketcetera.fix.ActiveFixSession;
import org.marketcetera.fix.FixAdminRpc;
import org.marketcetera.fix.FixAdminRpcServiceGrpc;
import org.marketcetera.fix.FixPermissions;
import org.marketcetera.fix.FixRpcUtil;
import org.marketcetera.fix.FixSession;
import org.marketcetera.fix.FixSessionAttributeDescriptor;
import org.marketcetera.fix.FixSessionStatus;
import org.marketcetera.fix.MutableFixSession;
import org.marketcetera.fix.MutableFixSessionFactory;
import org.marketcetera.fix.store.MessageStoreSession;
import org.marketcetera.fix.store.MessageStoreSessionDao;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.persist.PageResponse;
import org.marketcetera.rpc.base.BaseRpc;
import org.marketcetera.rpc.base.BaseRpcUtil;
import org.marketcetera.rpc.paging.PagingRpc;
import org.marketcetera.rpc.paging.PagingRpcUtil;
import org.marketcetera.rpc.server.AbstractRpcService;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.springframework.beans.factory.annotation.Autowired;
import quickfix.SessionID;

public class FixAdminRpcService<SessionClazz>
extends AbstractRpcService<SessionClazz, FixAdminRpcServiceGrpc.FixAdminRpcServiceImplBase> {
    @Autowired
    private BrokerService brokerService;
    @Autowired
    private FixSessionProvider fixSessionProvider;
    @Autowired
    private AuthorizationService authzService;
    @Autowired
    private MessageStoreSessionDao fixSessionStoreDao;
    @Autowired
    private MutableFixSessionFactory fixSessionFactory;
    private Service service;
    private final Cache<String, BaseRpcUtil.AbstractServerListenerProxy<?>> listenerProxiesById = CacheBuilder.newBuilder().build();
    private static final String DESCRIPTION = "FIX Admin RPC Service";

    @PostConstruct
    public void start() throws Exception {
        this.service = new Service();
        super.start();
    }

    protected String getServiceDescription() {
        return DESCRIPTION;
    }

    protected FixAdminRpcServiceGrpc.FixAdminRpcServiceImplBase getService() {
        return this.service;
    }

    private class BrokerStatusListenerProxy
    extends BaseRpcUtil.AbstractServerListenerProxy<FixAdminRpc.BrokerStatusListenerResponse>
    implements BrokerStatusListener {
        private final FixAdminRpc.BrokerStatusListenerResponse.Builder responseBuilder;

        public void receiveBrokerStatus(ActiveFixSession inStatus) {
            try {
                FixRpcUtil.setActiveFixSession((ActiveFixSession)inStatus, (FixAdminRpc.BrokerStatusListenerResponse.Builder)this.responseBuilder);
                FixAdminRpc.BrokerStatusListenerResponse response = this.responseBuilder.build();
                SLF4JLoggerProxy.trace(FixAdminRpcService.class, (String)"{} received broker status {}, sending {}", (Object[])new Object[]{this.getId(), inStatus, response});
                this.getObserver().onNext((Object)response);
                this.responseBuilder.clear();
            }
            catch (StatusRuntimeException e) {
                SLF4JLoggerProxy.info(FixAdminRpcService.class, (String)"Client disconnected, canceling broker status listener: {}", (Object[])new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)e)});
                FixAdminRpcService.this.brokerService.removeBrokerStatusListener((BrokerStatusListener)this);
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn(FixAdminRpcService.class, (Throwable)e, (String)"Unable to transmit broker status to listener, closing client", (Object[])new Object[0]);
                FixAdminRpcService.this.brokerService.removeBrokerStatusListener((BrokerStatusListener)this);
            }
        }

        private BrokerStatusListenerProxy(String inId, StreamObserver<FixAdminRpc.BrokerStatusListenerResponse> inObserver) {
            super(inId, inObserver);
            this.responseBuilder = FixAdminRpc.BrokerStatusListenerResponse.newBuilder();
        }
    }

    private class Service
    extends FixAdminRpcServiceGrpc.FixAdminRpcServiceImplBase {
        private Service() {
        }

        public void login(BaseRpc.LoginRequest inRequest, StreamObserver<BaseRpc.LoginResponse> inResponseObserver) {
            FixAdminRpcService.this.doLogin(inRequest, inResponseObserver);
        }

        public void logout(BaseRpc.LogoutRequest inRequest, StreamObserver<BaseRpc.LogoutResponse> inResponseObserver) {
            FixAdminRpcService.this.doLogout(inRequest, inResponseObserver);
        }

        public void heartbeat(BaseRpc.HeartbeatRequest inRequest, StreamObserver<BaseRpc.HeartbeatResponse> inResponseObserver) {
            FixAdminRpcService.this.doHeartbeat(inRequest, inResponseObserver);
        }

        public void createFixSession(FixAdminRpc.CreateFixSessionRequest inRequest, StreamObserver<FixAdminRpc.CreateFixSessionResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = FixAdminRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Received create FIX session request {} from {}", (Object[])new Object[]{inRequest, sessionHolder});
                FixAdminRpcService.this.authzService.authorize(sessionHolder.getUser(), AdminPermissions.AddSessionAction.name());
                FixAdminRpc.CreateFixSessionResponse.Builder responseBuilder = FixAdminRpc.CreateFixSessionResponse.newBuilder();
                if (inRequest.hasFixSession()) {
                    FixSession fixSession = FixRpcUtil.getFixSession((FixAdminRpc.FixSession)inRequest.getFixSession(), (MutableFixSessionFactory)FixAdminRpcService.this.fixSessionFactory).orElse(null);
                    Validate.notNull((Object)fixSession);
                    Validate.isTrue((null == FixAdminRpcService.this.fixSessionProvider.findFixSessionByName(fixSession.getName()) ? 1 : 0) != 0, (String)("FIX Session " + fixSession.getName() + " already exists"), (Object[])new Object[0]);
                    fixSession = FixAdminRpcService.this.fixSessionProvider.save(fixSession);
                    FixRpcUtil.getRpcFixSession((FixSession)fixSession).ifPresent(rpcFixSession -> responseBuilder.setFixSession(rpcFixSession));
                }
                FixAdminRpc.CreateFixSessionResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Returning {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)((Object)e);
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void readFixSessions(FixAdminRpc.ReadFixSessionsRequest inRequest, StreamObserver<FixAdminRpc.ReadFixSessionsResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = FixAdminRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Received read FIX sessions request {} from {}", (Object[])new Object[]{inRequest, sessionHolder});
                FixAdminRpcService.this.authzService.authorize(sessionHolder.getUser(), AdminPermissions.ViewSessionAction.name());
                FixAdminRpc.ReadFixSessionsResponse.Builder responseBuilder = FixAdminRpc.ReadFixSessionsResponse.newBuilder();
                PageRequest pageRequest = null;
                pageRequest = inRequest.hasPage() ? PagingRpcUtil.getPageRequest((PagingRpc.PageRequest)inRequest.getPage()) : new PageRequest(0, Integer.MAX_VALUE);
                CollectionPageResponse pagedResponse = FixAdminRpcService.this.brokerService.getActiveFixSessions(pageRequest);
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Query returned {}", (Object[])new Object[]{pagedResponse});
                if (pagedResponse != null) {
                    responseBuilder.setPage(PagingRpcUtil.getPageResponse((PageRequest)pageRequest, (PageResponse)pagedResponse));
                    for (ActiveFixSession activeFixSession : pagedResponse.getElements()) {
                        FixRpcUtil.getRpcActiveFixSession((ActiveFixSession)activeFixSession).ifPresent(rpcFixSession -> responseBuilder.addFixSession(rpcFixSession));
                    }
                }
                FixAdminRpc.ReadFixSessionsResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Returning {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)((Object)e);
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void updateFixSession(FixAdminRpc.UpdateFixSessionRequest inRequest, StreamObserver<FixAdminRpc.UpdateFixSessionResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = FixAdminRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Received update FIX sessions request {} from {}", (Object[])new Object[]{inRequest, sessionHolder});
                FixAdminRpcService.this.authzService.authorize(sessionHolder.getUser(), AdminPermissions.EditSessionAction.name());
                FixAdminRpc.UpdateFixSessionResponse.Builder responseBuilder = FixAdminRpc.UpdateFixSessionResponse.newBuilder();
                FixAdminRpc.FixSession rpcFixSession = inRequest.getFixSession();
                FixSession existingFixSession = FixAdminRpcService.this.fixSessionProvider.findFixSessionByName(inRequest.getName());
                Validate.isTrue((existingFixSession != null ? 1 : 0) != 0, (String)("FIX Session " + inRequest.getName() + " does not exist"), (Object[])new Object[0]);
                if (!(existingFixSession instanceof MutableFixSession)) {
                    throw new IllegalStateException("Broker service returned a non-mutable FIX session - check configuration");
                }
                MutableFixSession mutableFixSession = (MutableFixSession)existingFixSession;
                mutableFixSession.setAffinity(rpcFixSession.getAffinity());
                mutableFixSession.setBrokerId(rpcFixSession.getBrokerId());
                mutableFixSession.setDescription(rpcFixSession.getDescription());
                mutableFixSession.setHost(rpcFixSession.getHost());
                mutableFixSession.setIsAcceptor(rpcFixSession.getAcceptor());
                mutableFixSession.setIsEnabled(false);
                mutableFixSession.setMappedBrokerId(rpcFixSession.getMappedBrokerId());
                mutableFixSession.setName(rpcFixSession.getName());
                mutableFixSession.setPort(rpcFixSession.getPort());
                mutableFixSession.setSessionId(rpcFixSession.getSessionId());
                mutableFixSession.getSessionSettings().clear();
                mutableFixSession.getSessionSettings().putAll(BaseRpcUtil.getMap((BaseRpc.Map)rpcFixSession.getSessionSettings()));
                existingFixSession = FixAdminRpcService.this.fixSessionProvider.save((FixSession)mutableFixSession);
                FixAdminRpc.UpdateFixSessionResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Returning {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)((Object)e);
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void readFixSessionAttributeDescriptors(FixAdminRpc.ReadFixSessionAttributeDescriptorsRequest inRequest, StreamObserver<FixAdminRpc.ReadFixSessionAttributeDescriptorsResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = FixAdminRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Received read FIX session attribute descriptors request {} from {}", (Object[])new Object[]{inRequest, sessionHolder});
                FixAdminRpcService.this.authzService.authorize(sessionHolder.getUser(), AdminPermissions.ReadFixSessionAttributeDescriptorsAction.name());
                FixAdminRpc.ReadFixSessionAttributeDescriptorsResponse.Builder responseBuilder = FixAdminRpc.ReadFixSessionAttributeDescriptorsResponse.newBuilder();
                Collection descriptors = FixAdminRpcService.this.fixSessionProvider.getFixSessionAttributeDescriptors();
                descriptors.stream().forEach(descriptor -> FixRpcUtil.getRpcFixSessionAttributeDescriptor((FixSessionAttributeDescriptor)descriptor).ifPresent(rpcDescriptor -> responseBuilder.addFixSessionAttributeDescriptors(rpcDescriptor)));
                FixAdminRpc.ReadFixSessionAttributeDescriptorsResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Returning {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)((Object)e);
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void enableFixSession(FixAdminRpc.EnableFixSessionRequest inRequest, StreamObserver<FixAdminRpc.EnableFixSessionResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = FixAdminRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Received enable FIX session request {} from {}", (Object[])new Object[]{inRequest, sessionHolder});
                FixAdminRpcService.this.authzService.authorize(sessionHolder.getUser(), AdminPermissions.EnableSessionAction.name());
                FixAdminRpc.EnableFixSessionResponse.Builder responseBuilder = FixAdminRpc.EnableFixSessionResponse.newBuilder();
                FixSession fixSession = FixAdminRpcService.this.fixSessionProvider.findFixSessionByName(inRequest.getName());
                if (fixSession == null) {
                    throw new IllegalArgumentException("No FIX session with name '" + inRequest.getName() + "'");
                }
                FixAdminRpcService.this.fixSessionProvider.enableSession(new SessionID(fixSession.getSessionId()));
                FixAdminRpc.EnableFixSessionResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Returning {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)((Object)e);
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void disableFixSession(FixAdminRpc.DisableFixSessionRequest inRequest, StreamObserver<FixAdminRpc.DisableFixSessionResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = FixAdminRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Received disable FIX session request {} from {}", (Object[])new Object[]{inRequest, sessionHolder});
                FixAdminRpcService.this.authzService.authorize(sessionHolder.getUser(), AdminPermissions.DisableSessionAction.name());
                FixAdminRpc.DisableFixSessionResponse.Builder responseBuilder = FixAdminRpc.DisableFixSessionResponse.newBuilder();
                FixSession fixSession = FixAdminRpcService.this.fixSessionProvider.findFixSessionByName(inRequest.getName());
                if (fixSession == null) {
                    throw new IllegalArgumentException("No FIX session with name '" + inRequest.getName() + "'");
                }
                FixAdminRpcService.this.fixSessionProvider.disableSession(new SessionID(fixSession.getSessionId()));
                FixAdminRpc.DisableFixSessionResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Returning {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)((Object)e);
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void deleteFixSession(FixAdminRpc.DeleteFixSessionRequest inRequest, StreamObserver<FixAdminRpc.DeleteFixSessionResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = FixAdminRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Received delete FIX session request {} from {}", (Object[])new Object[]{inRequest, sessionHolder});
                FixAdminRpcService.this.authzService.authorize(sessionHolder.getUser(), AdminPermissions.DeleteSessionAction.name());
                FixAdminRpc.DeleteFixSessionResponse.Builder responseBuilder = FixAdminRpc.DeleteFixSessionResponse.newBuilder();
                FixSession fixSession = FixAdminRpcService.this.fixSessionProvider.findFixSessionByName(inRequest.getName());
                if (fixSession == null) {
                    throw new IllegalArgumentException("No FIX session with name '" + inRequest.getName() + "'");
                }
                FixAdminRpcService.this.fixSessionProvider.delete(new SessionID(fixSession.getSessionId()));
                FixAdminRpc.DeleteFixSessionResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Returning {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)((Object)e);
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void startFixSession(FixAdminRpc.StartFixSessionRequest inRequest, StreamObserver<FixAdminRpc.StartFixSessionResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = FixAdminRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Received start FIX session request {} from {}", (Object[])new Object[]{inRequest, sessionHolder});
                FixAdminRpcService.this.authzService.authorize(sessionHolder.getUser(), AdminPermissions.StartSessionAction.name());
                FixAdminRpc.StartFixSessionResponse.Builder responseBuilder = FixAdminRpc.StartFixSessionResponse.newBuilder();
                FixSession fixSession = FixAdminRpcService.this.fixSessionProvider.findFixSessionByName(inRequest.getName());
                if (fixSession == null) {
                    throw new IllegalArgumentException("No FIX session with name '" + inRequest.getName() + "'");
                }
                FixAdminRpcService.this.fixSessionProvider.startSession(new SessionID(fixSession.getSessionId()));
                FixAdminRpc.StartFixSessionResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Returning {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)((Object)e);
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void stopFixSession(FixAdminRpc.StopFixSessionRequest inRequest, StreamObserver<FixAdminRpc.StopFixSessionResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = FixAdminRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Received stop FIX session request {} from {}", (Object[])new Object[]{inRequest, sessionHolder});
                FixAdminRpcService.this.authzService.authorize(sessionHolder.getUser(), AdminPermissions.StopSessionAction.name());
                FixAdminRpc.StopFixSessionResponse.Builder responseBuilder = FixAdminRpc.StopFixSessionResponse.newBuilder();
                FixSession fixSession = FixAdminRpcService.this.fixSessionProvider.findFixSessionByName(inRequest.getName());
                if (fixSession == null) {
                    throw new IllegalArgumentException("No FIX session with name '" + inRequest.getName() + "'");
                }
                FixAdminRpcService.this.fixSessionProvider.stopSession(new SessionID(fixSession.getSessionId()));
                FixAdminRpc.StopFixSessionResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Returning {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)((Object)e);
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void updateSequenceNumbers(FixAdminRpc.UpdateSequenceNumbersRequest inRequest, StreamObserver<FixAdminRpc.UpdateSequenceNumbersResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = FixAdminRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Received update sequence numbers for FIX session request {} from {}", (Object[])new Object[]{inRequest, sessionHolder});
                FixAdminRpcService.this.authzService.authorize(sessionHolder.getUser(), AdminPermissions.UpdateSequenceAction.name());
                FixAdminRpc.UpdateSequenceNumbersResponse.Builder responseBuilder = FixAdminRpc.UpdateSequenceNumbersResponse.newBuilder();
                FixSession fixSession = FixAdminRpcService.this.fixSessionProvider.findFixSessionByName(inRequest.getName());
                if (fixSession == null) {
                    throw new IllegalArgumentException("No FIX session with name '" + inRequest.getName() + "'");
                }
                FixSessionStatus brokerStatus = FixAdminRpcService.this.brokerService.getFixSessionStatus(new BrokerID(fixSession.getBrokerId()));
                if (brokerStatus.isStarted()) {
                    throw new IllegalArgumentException("FIX session " + inRequest.getName() + " is running");
                }
                MessageStoreSession sessionInfo = FixAdminRpcService.this.fixSessionStoreDao.findBySessionId(fixSession.getSessionId());
                if (sessionInfo == null) {
                    throw new IllegalArgumentException("No FIX session store with name '" + inRequest.getName() + "'. The session may need to be started first.");
                }
                if (inRequest.getSenderSequenceNumber() != -1) {
                    sessionInfo.setSenderSeqNum(inRequest.getSenderSequenceNumber());
                }
                if (inRequest.getTargetSequenceNumber() != -1) {
                    sessionInfo.setTargetSeqNum(inRequest.getTargetSequenceNumber());
                }
                FixAdminRpcService.this.fixSessionStoreDao.save((Object)sessionInfo);
                FixAdminRpc.UpdateSequenceNumbersResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Returning {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)((Object)e);
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void removeBrokerStatusListener(FixAdminRpc.RemoveBrokerStatusListenerRequest inRequest, StreamObserver<FixAdminRpc.RemoveBrokerStatusListenerResponse> inResponseObserver) {
            try {
                FixAdminRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Received remove broker status listener request {}", (Object[])new Object[]{inRequest});
                String listenerId = inRequest.getListenerId();
                BaseRpcUtil.AbstractServerListenerProxy brokerStatusListenerProxy = (BaseRpcUtil.AbstractServerListenerProxy)FixAdminRpcService.this.listenerProxiesById.getIfPresent((Object)listenerId);
                FixAdminRpcService.this.listenerProxiesById.invalidate((Object)listenerId);
                if (brokerStatusListenerProxy != null) {
                    FixAdminRpcService.this.brokerService.removeBrokerStatusListener((BrokerStatusListener)brokerStatusListenerProxy);
                    brokerStatusListenerProxy.close();
                }
                FixAdminRpc.RemoveBrokerStatusListenerResponse.Builder responseBuilder = FixAdminRpc.RemoveBrokerStatusListenerResponse.newBuilder();
                FixAdminRpc.RemoveBrokerStatusListenerResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Returning {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                FixAdminRpcService.this.handleError(e, inResponseObserver);
            }
        }

        public void addBrokerStatusListener(FixAdminRpc.AddBrokerStatusListenerRequest inRequest, StreamObserver<FixAdminRpc.BrokerStatusListenerResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = FixAdminRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Received add broker status listener request {}", (Object[])new Object[]{inRequest});
                FixAdminRpcService.this.authzService.authorize(sessionHolder.getUser(), FixPermissions.ViewBrokerStatusAction.name());
                String listenerId = inRequest.getListenerId();
                BaseRpcUtil.AbstractServerListenerProxy brokerStatusListenerProxy = (BaseRpcUtil.AbstractServerListenerProxy)FixAdminRpcService.this.listenerProxiesById.getIfPresent((Object)listenerId);
                if (brokerStatusListenerProxy == null) {
                    brokerStatusListenerProxy = new BrokerStatusListenerProxy(listenerId, inResponseObserver);
                    FixAdminRpcService.this.listenerProxiesById.put((Object)brokerStatusListenerProxy.getId(), (Object)brokerStatusListenerProxy);
                    FixAdminRpcService.this.brokerService.addBrokerStatusListener((BrokerStatusListener)brokerStatusListenerProxy);
                }
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)((Object)this), (Throwable)e);
                FixAdminRpcService.this.handleError(e, inResponseObserver);
            }
        }

        public void getInstanceData(FixAdminRpc.InstanceDataRequest inRequest, StreamObserver<FixAdminRpc.InstanceDataResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = FixAdminRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Received {} from {}", (Object[])new Object[]{inRequest, sessionHolder});
                FixAdminRpcService.this.authzService.authorize(sessionHolder.getUser(), AdminPermissions.ReadInstanceDataAction.name());
                FixAdminRpc.InstanceDataResponse.Builder responseBuilder = FixAdminRpc.InstanceDataResponse.newBuilder();
                FixAdminRpc.InstanceData.Builder instanceDataBuilder = FixAdminRpc.InstanceData.newBuilder();
                AcceptorSessionAttributes acceptorSessionAttributes = FixAdminRpcService.this.brokerService.getFixSettingsFor(inRequest.getAffinity());
                if (acceptorSessionAttributes.getHost() != null) {
                    instanceDataBuilder.setHostname(acceptorSessionAttributes.getHost());
                }
                instanceDataBuilder.setPort(acceptorSessionAttributes.getPort());
                responseBuilder.setInstanceData(instanceDataBuilder.build());
                FixAdminRpc.InstanceDataResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)FixAdminRpcService.this), (String)"Returning {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)((Object)e);
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }
    }
}

