/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.bogus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.event.HasInstrument;
import org.marketcetera.marketdata.Capability;
import org.marketcetera.marketdata.Content;
import org.marketcetera.marketdata.MarketDataFeedTestBase;
import org.marketcetera.marketdata.MarketDataModuleTestBase;
import org.marketcetera.marketdata.MarketDataRequestBuilder;
import org.marketcetera.marketdata.bogus.BogusFeedModuleFactory;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleFactory;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.SinkDataListener;

public class BogusFeedModuleTest
extends MarketDataModuleTestBase {
    @Test
    public void deadlock() throws Exception {
        final Set symbols = Collections.synchronizedSet(new HashSet());
        this.moduleManager.addSinkListener(new SinkDataListener(){

            public void receivedData(DataFlowID inFlowID, Object inData) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (inData instanceof HasInstrument) {
                    symbols.add(((HasInstrument)inData).getInstrument().getSymbol());
                }
            }
        });
        Assert.assertTrue((boolean)symbols.isEmpty());
        DataFlowID id1 = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(this.getInstanceURN(), (Object)MarketDataRequestBuilder.newRequest().withSymbols("IBM").create())});
        Thread.sleep(2000L);
        DataFlowID id2 = this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(this.getInstanceURN(), (Object)MarketDataRequestBuilder.newRequest().withSymbols("GOOG").withContent(new Content[]{Content.MARKET_STAT}).create())});
        Thread.sleep(5000L);
        this.moduleManager.cancel(id1);
        this.moduleManager.cancel(id2);
        Assert.assertTrue((boolean)symbols.contains("IBM"));
        Assert.assertTrue((boolean)symbols.contains("GOOG"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=15000L)
    public void yetAnotherDeadlock() throws Exception {
        final ArrayList<DataFlowID> createdFlows = new ArrayList<DataFlowID>();
        try {
            final ArrayList caughtExceptions = new ArrayList();
            final ArrayList receivedData = new ArrayList();
            final boolean[] dataRequested = new boolean[]{false};
            Assert.assertTrue((boolean)caughtExceptions.isEmpty());
            Assert.assertTrue((boolean)receivedData.isEmpty());
            this.moduleManager.addSinkListener(new SinkDataListener(){

                public void receivedData(DataFlowID inFlowID, Object inData) {
                    try {
                        if (!dataRequested[0]) {
                            createdFlows.add(BogusFeedModuleTest.this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(BogusFeedModuleFactory.INSTANCE_URN, (Object)MarketDataRequestBuilder.newRequest().withSymbols("GOOG").create())}));
                            dataRequested[0] = true;
                        }
                        receivedData.add(inData);
                    }
                    catch (ModuleException e) {
                        caughtExceptions.add(e);
                    }
                }
            });
            createdFlows.add(this.moduleManager.createDataFlow(new DataRequest[]{new DataRequest(BogusFeedModuleFactory.INSTANCE_URN, (Object)MarketDataRequestBuilder.newRequest().withSymbols("IBM").create())}));
            MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return !receivedData.isEmpty();
                }
            });
            Assert.assertTrue((boolean)caughtExceptions.isEmpty());
            Assert.assertFalse((boolean)receivedData.isEmpty());
        }
        finally {
            for (DataFlowID id : createdFlows) {
                this.moduleManager.cancel(id);
            }
        }
    }

    protected ModuleFactory getFactory() {
        return new BogusFeedModuleFactory();
    }

    protected ModuleURN getInstanceURN() {
        return BogusFeedModuleFactory.INSTANCE_URN;
    }

    protected Capability[] getExpectedCapabilities() {
        return new Capability[]{Capability.TOP_OF_BOOK, Capability.LEVEL_2, Capability.OPEN_BOOK, Capability.TOTAL_VIEW, Capability.LATEST_TICK, Capability.MARKET_STAT, Capability.DIVIDEND, Capability.EVENT_BOUNDARY, Capability.BBO10};
    }

    protected Capability getUnexpectedCapability() {
        return Capability.UNKNOWN;
    }

    protected String getProvider() {
        return "bogus";
    }
}

