/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.bogus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.marketcetera.core.NoMoreIDsException;
import org.marketcetera.core.publisher.Subscriber;
import org.marketcetera.event.HasTimestamps;
import org.marketcetera.marketdata.AbstractMarketDataFeed;
import org.marketcetera.marketdata.AssetClass;
import org.marketcetera.marketdata.Capability;
import org.marketcetera.marketdata.Content;
import org.marketcetera.marketdata.ExchangeRequest;
import org.marketcetera.marketdata.ExchangeRequestBuilder;
import org.marketcetera.marketdata.FeedException;
import org.marketcetera.marketdata.FeedStatus;
import org.marketcetera.marketdata.IFeedComponent;
import org.marketcetera.marketdata.MarketDataFeedTokenSpec;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.marketdata.SimulatedExchange;
import org.marketcetera.marketdata.bogus.BogusFeedCredentials;
import org.marketcetera.marketdata.bogus.BogusFeedEventTranslator;
import org.marketcetera.marketdata.bogus.BogusFeedMessageTranslator;
import org.marketcetera.marketdata.bogus.BogusFeedToken;
import org.marketcetera.marketdata.bogus.Messages;
import org.marketcetera.options.OptionUtils;
import org.marketcetera.trade.ConvertibleBond;
import org.marketcetera.trade.Currency;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Future;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
public class BogusFeed
extends AbstractMarketDataFeed<BogusFeedToken, BogusFeedCredentials, BogusFeedMessageTranslator, BogusFeedEventTranslator, MarketDataRequest, BogusFeed> {
    private static final Set<Capability> capabilities = Collections.unmodifiableSet(EnumSet.of(Capability.TOP_OF_BOOK, new Capability[]{Capability.LEVEL_2, Capability.OPEN_BOOK, Capability.TOTAL_VIEW, Capability.LATEST_TICK, Capability.MARKET_STAT, Capability.DIVIDEND, Capability.EVENT_BOUNDARY, Capability.BBO10}));
    private static final Set<AssetClass> assetClasses = EnumSet.of(AssetClass.EQUITY, AssetClass.OPTION, AssetClass.FUTURE, AssetClass.CURRENCY, AssetClass.CONVERTIBLE_BOND);
    private boolean mLoggedIn;
    private final Map<String, SimulatedExchange> exchanges = new HashMap<String, SimulatedExchange>();
    private static BogusFeed sInstance;
    private static final int EXCHANGE_COUNT = 1;

    public static synchronized BogusFeed getInstance(String inProviderName) throws NoMoreIDsException {
        if (sInstance != null) {
            return sInstance;
        }
        sInstance = new BogusFeed(inProviderName);
        return sInstance;
    }

    private BogusFeed(String inProviderName) throws NoMoreIDsException {
        super(IFeedComponent.FeedType.SIMULATED, inProviderName);
        this.setLoggedIn(false);
    }

    public synchronized void start() {
        if (this.getFeedStatus().isRunning()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < 1; ++i) {
            SimulatedExchange exchange = new SimulatedExchange(String.format("%s-%d", this.getProviderName(), i + 1), String.format("BGS%d", i + 1));
            SLF4JLoggerProxy.debug(BogusFeed.class, (String)"BogusFeed starting exchange {}...", (Object[])new Object[]{exchange.getCode()});
            exchange.start();
            this.exchanges.put(exchange.getCode(), exchange);
        }
        this.setFeedStatus(FeedStatus.AVAILABLE);
        super.start();
    }

    public synchronized void stop() {
        this.setFeedStatus(FeedStatus.OFFLINE);
        if (!this.getFeedStatus().isRunning()) {
            throw new IllegalStateException();
        }
        for (SimulatedExchange exchange : this.exchanges.values()) {
            SLF4JLoggerProxy.debug(BogusFeed.class, (String)"BogusFeed stopping exchange {}...", (Object[])new Object[]{exchange.getCode()});
            exchange.stop();
        }
        super.stop();
    }

    public Set<Capability> getCapabilities() {
        return capabilities;
    }

    public Set<AssetClass> getSupportedAssetClasses() {
        return assetClasses;
    }

    protected final synchronized void doCancel(String inHandle) {
        Request.cancel(inHandle);
    }

    protected final synchronized List<String> doMarketDataRequest(MarketDataRequest inData) throws FeedException {
        return Arrays.asList(Request.execute(inData, this));
    }

    protected final boolean doLogin(BogusFeedCredentials inCredentials) {
        this.setLoggedIn(true);
        return true;
    }

    protected final void doLogout() {
        this.setLoggedIn(false);
    }

    protected final BogusFeedToken generateToken(MarketDataFeedTokenSpec inTokenSpec) throws FeedException {
        return BogusFeedToken.getToken(inTokenSpec, this);
    }

    protected final BogusFeedEventTranslator getEventTranslator() {
        return BogusFeedEventTranslator.getInstance();
    }

    protected final BogusFeedMessageTranslator getMessageTranslator() {
        return BogusFeedMessageTranslator.getInstance();
    }

    protected final boolean isLoggedIn() {
        return this.mLoggedIn;
    }

    private void setLoggedIn(boolean inLoggedIn) {
        this.mLoggedIn = inLoggedIn;
    }

    private List<SimulatedExchange> getExchangesForCode(String inExchange) {
        if (inExchange == null || inExchange.isEmpty()) {
            return new ArrayList<SimulatedExchange>(this.exchanges.values());
        }
        if (this.exchanges.containsKey(inExchange)) {
            return Arrays.asList(this.exchanges.get(inExchange));
        }
        return new ArrayList<SimulatedExchange>();
    }

    @ClassVersion(value="$Id$")
    private static class Request {
        private final List<SimulatedExchange.Token> exchangeTokens = new ArrayList<SimulatedExchange.Token>();
        private final MarketDataRequest marketDataRequest;
        private final long id = counter.incrementAndGet();
        private final BogusFeed feed;
        private final Subscriber subscriber;
        private boolean executed = false;
        private static final Map<String, Request> requests = new HashMap<String, Request>();
        private static final AtomicLong counter = new AtomicLong(0L);

        private static String execute(MarketDataRequest inRequest, BogusFeed inParentFeed) throws FeedException {
            Request request = new Request(inRequest, inParentFeed);
            request.execute();
            return request.getIDAsString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void cancel(String inHandle) {
            Request request;
            Map<String, Request> map = requests;
            synchronized (map) {
                request = requests.remove(inHandle);
            }
            if (request != null) {
                request.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Request(MarketDataRequest inRequest, BogusFeed inFeed) {
            this.marketDataRequest = inRequest;
            this.feed = inFeed;
            this.subscriber = new Subscriber(){

                public boolean isInteresting(Object inData) {
                    return true;
                }

                public void publishTo(Object inData) {
                    SLF4JLoggerProxy.debug(BogusFeed.class, (String)"BogusFeed publishing {}", (Object[])new Object[]{inData});
                    if (inData instanceof HasTimestamps) {
                        ((HasTimestamps)inData).setReceivedTimestamp(System.currentTimeMillis());
                    }
                    feed.dataReceived(this.getIDAsString(), inData);
                }
            };
            Map<String, Request> map = requests;
            synchronized (map) {
                requests.put(this.getIDAsString(), this);
            }
        }

        private Instrument getUnderlyingInstrument(String inSymbol) {
            return new Equity(inSymbol);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private synchronized void execute() throws FeedException {
            if (this.executed) {
                throw new IllegalStateException();
            }
            try {
                ArrayList<ExchangeRequest> exchangeRequests = new ArrayList<ExchangeRequest>();
                Set symbols = this.marketDataRequest.getSymbols();
                if (!symbols.isEmpty()) {
                    if (this.marketDataRequest.getAssetClass() == AssetClass.EQUITY) {
                        for (Object symbol : symbols) {
                            exchangeRequests.add(ExchangeRequestBuilder.newRequest().withInstrument((Instrument)new Equity((String)symbol)).create());
                        }
                    } else if (this.marketDataRequest.getAssetClass() == AssetClass.FUTURE) {
                        for (Object symbol : symbols) {
                            exchangeRequests.add(ExchangeRequestBuilder.newRequest().withInstrument((Instrument)Future.fromString((String)symbol)).create());
                        }
                    } else if (this.marketDataRequest.getAssetClass() == AssetClass.CURRENCY) {
                        for (Object symbol : symbols) {
                            exchangeRequests.add(ExchangeRequestBuilder.newRequest().withInstrument((Instrument)new Currency((String)symbol)).create());
                        }
                    } else if (this.marketDataRequest.getAssetClass() == AssetClass.OPTION) {
                        for (Object symbol : symbols) {
                            try {
                                Option basicOption = OptionUtils.getOsiOptionFromString((String)symbol);
                                exchangeRequests.add(ExchangeRequestBuilder.newRequest().withInstrument((Instrument)basicOption).withUnderlyingInstrument(this.getUnderlyingInstrument(basicOption.getSymbol())).create());
                            }
                            catch (IllegalArgumentException e) {
                                throw new FeedException((Throwable)e, (I18NBoundMessage)new I18NBoundMessage1P(Messages.UNSUPPORTED_OPTION_SPECIFICATION, (Serializable)symbol));
                            }
                        }
                    } else {
                        if (this.marketDataRequest.getAssetClass() != AssetClass.CONVERTIBLE_BOND) throw new UnsupportedOperationException();
                        for (Object symbol : symbols) {
                            exchangeRequests.add(ExchangeRequestBuilder.newRequest().withInstrument((Instrument)new ConvertibleBond((String)symbol)).create());
                        }
                    }
                } else {
                    Set underlyingSymbols = this.marketDataRequest.getUnderlyingSymbols();
                    assert (!underlyingSymbols.isEmpty());
                    for (String symbol : this.marketDataRequest.getUnderlyingSymbols()) {
                        exchangeRequests.add(ExchangeRequestBuilder.newRequest().withUnderlyingInstrument(this.getUnderlyingInstrument(symbol)).create());
                    }
                }
                for (ExchangeRequest exchangeRequest : exchangeRequests) {
                    block22: for (Content content : this.marketDataRequest.getContent()) {
                        switch (content) {
                            case LEVEL_2: {
                                this.doTopOfBook(exchangeRequest, null);
                                continue block22;
                            }
                            case TOP_OF_BOOK: {
                                this.doTopOfBook(exchangeRequest, this.marketDataRequest.getExchange());
                                continue block22;
                            }
                            case OPEN_BOOK: {
                                this.doDepthOfBook(exchangeRequest, this.marketDataRequest.getExchange());
                                continue block22;
                            }
                            case TOTAL_VIEW: {
                                this.doDepthOfBook(exchangeRequest, this.marketDataRequest.getExchange());
                                continue block22;
                            }
                            case BBO10: {
                                this.doDepthOfBook(exchangeRequest, this.marketDataRequest.getExchange());
                                continue block22;
                            }
                            case LATEST_TICK: {
                                this.doLatestTick(exchangeRequest, this.marketDataRequest.getExchange());
                                continue block22;
                            }
                            case MARKET_STAT: {
                                this.doStatistics(exchangeRequest, this.marketDataRequest.getExchange());
                                continue block22;
                            }
                            case DIVIDEND: {
                                this.doDividends(exchangeRequest, this.marketDataRequest.getExchange());
                                continue block22;
                            }
                        }
                        throw new UnsupportedOperationException();
                    }
                }
                return;
            }
            finally {
                this.executed = true;
            }
        }

        private void doStatistics(ExchangeRequest inExchangeRequest, String inExchangeToUse) {
            for (SimulatedExchange exchange : this.feed.getExchangesForCode(inExchangeToUse)) {
                this.exchangeTokens.add(exchange.getStatistics(inExchangeRequest, this.subscriber));
            }
        }

        private void doDividends(ExchangeRequest inExchangeRequest, String inExchangeToUse) {
            block0: {
                Iterator<SimulatedExchange> iterator = this.feed.getExchangesForCode(inExchangeToUse).iterator();
                if (!iterator.hasNext()) break block0;
                SimulatedExchange exchange = iterator.next();
                this.exchangeTokens.add(exchange.getDividends(inExchangeRequest, this.subscriber));
            }
        }

        private void doDepthOfBook(ExchangeRequest inRequest, String inExchangeToUse) {
            for (SimulatedExchange exchange : this.feed.getExchangesForCode(inExchangeToUse)) {
                this.exchangeTokens.add(exchange.getDepthOfBook(inRequest, this.subscriber));
            }
        }

        private void doTopOfBook(ExchangeRequest inRequest, String inExchangeToUse) {
            for (SimulatedExchange exchange : this.feed.getExchangesForCode(inExchangeToUse)) {
                this.exchangeTokens.add(exchange.getTopOfBook(inRequest, this.subscriber));
            }
        }

        private void doLatestTick(ExchangeRequest inRequest, String inExchangeToUse) {
            for (SimulatedExchange exchange : this.feed.getExchangesForCode(inExchangeToUse)) {
                this.exchangeTokens.add(exchange.getLatestTick(inRequest, this.subscriber));
            }
        }

        private void cancel() {
            for (SimulatedExchange.Token token : this.exchangeTokens) {
                token.cancel();
            }
        }

        private String getIDAsString() {
            return Long.toHexString(this.id);
        }
    }
}

