/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.bogus;

import org.marketcetera.core.CoreException;
import org.marketcetera.core.IFeedComponentListener;
import org.marketcetera.marketdata.AbstractMarketDataModule;
import org.marketcetera.marketdata.FeedStatus;
import org.marketcetera.marketdata.IFeedComponent;
import org.marketcetera.marketdata.MarketDataFeed;
import org.marketcetera.marketdata.MarketDataStatus;
import org.marketcetera.marketdata.bogus.BogusFeedCredentials;
import org.marketcetera.marketdata.bogus.BogusFeedFactory;
import org.marketcetera.marketdata.bogus.BogusFeedModuleFactory;
import org.marketcetera.marketdata.bogus.BogusFeedToken;
import org.marketcetera.marketdata.service.MarketDataService;
import org.marketcetera.module.AutowiredModule;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.beans.factory.annotation.Autowired;

@AutowiredModule
@ClassVersion(value="$Id$")
public final class BogusFeedModule
extends AbstractMarketDataModule<BogusFeedToken, BogusFeedCredentials> {
    @Autowired
    private MarketDataService marketDataService;

    BogusFeedModule() throws CoreException {
        super(BogusFeedModuleFactory.INSTANCE_URN, (MarketDataFeed)BogusFeedFactory.getInstance().getMarketDataFeed());
        this.getFeed().addFeedComponentListener(new IFeedComponentListener(){

            public void feedComponentChanged(final IFeedComponent inComponent) {
                BogusFeedModule.this.marketDataService.reportMarketDataStatus(new MarketDataStatus(){

                    public FeedStatus getFeedStatus() {
                        return inComponent.getFeedStatus();
                    }

                    public String getProvider() {
                        return "bogus";
                    }
                });
            }
        });
    }

    protected BogusFeedCredentials getCredentials() throws CoreException {
        return BogusFeedCredentials.getInstance();
    }
}

