/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.exsim;

import javax.annotation.PostConstruct;
import org.marketcetera.core.CoreException;
import org.marketcetera.marketdata.exsim.Messages;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.util.log.I18NBoundMessage;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class ExsimFeedConfig {
    private SessionID sessionId;
    private String senderCompId;
    private String targetCompId = "MRKTC-EXCH";
    private String hostname = "exchange.marketcetera.com";
    private int port = 7001;
    private String fixVersion = FIXVersion.FIX44.getVersion();
    private String fixAplVersion = null;
    private int reconnectInterval = 5;
    private int heartBtInt = 30;
    private String startTime = "00:00:00";
    private String endTime = "22:45:00";
    private String timeZone = "US/Pacific";
    private String dataDictionary = "FIX44.xml";
    private String appDataDictionary = null;

    public String getSenderCompId() {
        return this.senderCompId;
    }

    public void setSenderCompId(String inSenderCompId) {
        this.senderCompId = inSenderCompId;
    }

    public String getTargetCompId() {
        return this.targetCompId;
    }

    public void setTargetCompId(String inTargetCompId) {
        this.targetCompId = inTargetCompId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String inHostname) {
        this.hostname = inHostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int inPort) {
        this.port = inPort;
    }

    public String getFixVersion() {
        return this.fixVersion;
    }

    public void setFixVersion(String inFixVersion) {
        this.fixVersion = inFixVersion;
    }

    public String getFixAplVersion() {
        return this.fixAplVersion;
    }

    public void setFixAplVersion(String inFixAplVersion) {
        this.fixAplVersion = inFixAplVersion;
    }

    public String getAppDataDictionary() {
        return this.appDataDictionary;
    }

    public void setAppDataDictionary(String inAppDataDictionary) {
        this.appDataDictionary = inAppDataDictionary;
    }

    public int getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(int inReconnectInterval) {
        this.reconnectInterval = inReconnectInterval;
    }

    public int getHeartBtInt() {
        return this.heartBtInt;
    }

    public void setHeartBtInt(int inHeartBtInt) {
        this.heartBtInt = inHeartBtInt;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String inStartTime) {
        this.startTime = inStartTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String inEndTime) {
        this.endTime = inEndTime;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String inTimeZone) {
        this.timeZone = inTimeZone;
    }

    public String getDataDictionary() {
        return this.dataDictionary;
    }

    public void setDataDictionary(String inDataDictionary) {
        this.dataDictionary = inDataDictionary;
    }

    public SessionID getSessionId() {
        return this.sessionId;
    }

    @PostConstruct
    public void start() {
        if (this.senderCompId == null) {
            throw new CoreException((I18NBoundMessage)Messages.SENDER_COMPID_REQURED);
        }
        this.sessionId = new SessionID(this.fixVersion, this.senderCompId, this.targetCompId);
    }

    void populateSessionSettings(SessionSettings inSessionSettings) {
        inSessionSettings.setString(this.sessionId, "SocketConnectHost", this.hostname);
        inSessionSettings.setLong(this.sessionId, "SocketConnectPort", (long)this.port);
        inSessionSettings.setLong(this.sessionId, "HeartBtInt", (long)this.heartBtInt);
        inSessionSettings.setString(this.sessionId, "StartTime", this.startTime);
        inSessionSettings.setString(this.sessionId, "EndTime", this.endTime);
        inSessionSettings.setString(this.sessionId, "TimeZone", this.timeZone);
        inSessionSettings.setString(this.sessionId, "ResetOnLogon", "Y");
        inSessionSettings.setString(this.sessionId, "ResetOnLogout", "Y");
        inSessionSettings.setString(this.sessionId, "ResetOnDisconnect", "Y");
        inSessionSettings.setString(this.sessionId, "ResetOnError", "Y");
        inSessionSettings.setString(this.sessionId, "DataDictionary", this.dataDictionary);
        inSessionSettings.setString(this.sessionId, "BeginString", this.sessionId.getBeginString());
        inSessionSettings.setString(this.sessionId, "SenderCompID", this.sessionId.getSenderCompID());
        inSessionSettings.setString(this.sessionId, "TargetCompID", this.sessionId.getTargetCompID());
        inSessionSettings.setLong(this.sessionId, "ReconnectInterval", (long)this.reconnectInterval);
        inSessionSettings.setString(this.sessionId, "PersistMessages", "N");
        if (this.appDataDictionary != null) {
            inSessionSettings.setString(this.sessionId, "AppDataDictionary", this.appDataDictionary);
        }
        if (this.fixAplVersion != null) {
            inSessionSettings.setString(this.sessionId, "DefaultApplVerID", this.fixAplVersion);
        }
    }
}

