/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.exsim;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.marketcetera.core.BatchQueueProcessor;
import org.marketcetera.core.CoreException;
import org.marketcetera.event.AskEvent;
import org.marketcetera.event.BidEvent;
import org.marketcetera.event.Event;
import org.marketcetera.event.EventType;
import org.marketcetera.event.HasEventType;
import org.marketcetera.event.QuoteAction;
import org.marketcetera.event.QuoteEvent;
import org.marketcetera.event.impl.MarketstatEventBuilder;
import org.marketcetera.event.impl.QuoteEventBuilder;
import org.marketcetera.event.impl.TradeEventBuilder;
import org.marketcetera.marketdata.AbstractMarketDataModuleMXBean;
import org.marketcetera.marketdata.AssetClass;
import org.marketcetera.marketdata.Capability;
import org.marketcetera.marketdata.CapabilityCollection;
import org.marketcetera.marketdata.FeedStatus;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.marketdata.MarketDataRequestBuilder;
import org.marketcetera.marketdata.OrderBook;
import org.marketcetera.marketdata.exsim.ExsimFeedConfig;
import org.marketcetera.marketdata.exsim.Messages;
import org.marketcetera.module.AutowiredModule;
import org.marketcetera.module.DataEmitter;
import org.marketcetera.module.DataEmitterSupport;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.Module;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.RequestDataException;
import org.marketcetera.module.RequestID;
import org.marketcetera.module.StopDataFlowException;
import org.marketcetera.options.ExpirationType;
import org.marketcetera.quickfix.FIXMessageFactory;
import org.marketcetera.quickfix.FIXMessageUtil;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.quickfix.NullLogFactory;
import org.marketcetera.symbol.SymbolResolverService;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage0P;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DoNotSend;
import quickfix.FieldMap;
import quickfix.FieldNotFound;
import quickfix.Group;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.LogFactory;
import quickfix.MemoryStoreFactory;
import quickfix.Message;
import quickfix.MessageStoreFactory;
import quickfix.RejectLogon;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionNotFound;
import quickfix.SessionSettings;
import quickfix.SocketInitiator;
import quickfix.UnsupportedMessageType;

@AutowiredModule
public class ExsimFeedModule
extends Module
implements DataEmitter,
AbstractMarketDataModuleMXBean {
    private FixMessageProcessor fixMessageProcessor;
    private SessionID sessionId;
    private SocketInitiator socketInitiator;
    private FIXMessageFactory messageFactory;
    private FixApplication application;
    @Autowired
    private ExsimFeedConfig exsimFeedConfig;
    @Autowired
    private SymbolResolverService symbolResolverService;
    private long feedAvailableTimeout = 10000L;
    private volatile FeedStatus feedStatus;
    private final LoadingCache<OrderBookKey, OrderBook> orderBooksByInstrument;
    private final AtomicLong idCounter = new AtomicLong(0L);
    private final Map<String, RequestData> requestsByRequestId = Maps.newHashMap();
    private final Map<DataFlowID, RequestData> requestsByDataFlowId = Maps.newHashMap();
    private static final Set<AssetClass> supportedAssetClasses = EnumSet.of(AssetClass.CONVERTIBLE_BOND, AssetClass.CURRENCY, AssetClass.EQUITY, AssetClass.FUTURE, AssetClass.OPTION);
    private static final Set<Capability> supportedCapabilities = EnumSet.of(Capability.BBO10, Capability.EVENT_BOUNDARY, Capability.LATEST_TICK, Capability.MARKET_STAT, Capability.TOP_OF_BOOK);

    public String getFeedStatus() {
        if (this.feedStatus == null) {
            return FeedStatus.UNKNOWN.name();
        }
        return this.feedStatus.name();
    }

    public void reconnect() {
        this.preStop();
        this.preStart();
    }

    public void disconnect() {
        this.preStop();
    }

    public Set<Capability> getCapabilities() {
        return supportedCapabilities;
    }

    public Set<AssetClass> getAssetClasses() {
        return supportedAssetClasses;
    }

    public void requestData(DataRequest inRequest, DataEmitterSupport inSupport) throws RequestDataException {
        block14: {
            SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Received a data flow request: {}", (Object[])new Object[]{inRequest});
            if (!this.feedStatus.isRunning()) {
                try {
                    long timestamp = System.currentTimeMillis();
                    while (!this.feedStatus.isRunning() && System.currentTimeMillis() < timestamp + this.feedAvailableTimeout) {
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e) {
                    throw new RequestDataException((I18NBoundMessage)Messages.FEED_OFFLINE);
                }
                if (!this.feedStatus.isRunning()) {
                    throw new RequestDataException((I18NBoundMessage)Messages.FEED_OFFLINE);
                }
            }
            Object payload = inRequest.getData();
            try {
                if (payload == null) {
                    throw new RequestDataException((I18NBoundMessage)Messages.DATA_REQUEST_PAYLOAD_REQUIRED);
                }
                if (payload instanceof String) {
                    String stringPayload = (String)payload;
                    try {
                        this.doMarketDataRequest(MarketDataRequestBuilder.newRequestFromString((String)stringPayload), inRequest, inSupport);
                        break block14;
                    }
                    catch (Exception e) {
                        throw new RequestDataException((I18NBoundMessage)new I18NBoundMessage2P(Messages.INVALID_DATA_REQUEST_PAYLOAD, (Serializable)((Object)stringPayload), (Serializable)ExceptionUtils.getRootCause((Throwable)e)));
                    }
                }
                if (payload instanceof MarketDataRequest) {
                    this.doMarketDataRequest((MarketDataRequest)payload, inRequest, inSupport);
                    break block14;
                }
                throw new RequestDataException((I18NBoundMessage)new I18NBoundMessage1P(Messages.UNSUPPORTED_DATA_REQUEST_PAYLOAD, (Serializable)((Object)payload.getClass().getSimpleName())));
            }
            catch (Exception e) {
                if (SLF4JLoggerProxy.isDebugEnabled((Object)((Object)this))) {
                    Messages.MARKET_DATA_REQUEST_FAILED.warn((Object)this, (Throwable)e, (Object)inRequest, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                } else {
                    Messages.MARKET_DATA_REQUEST_FAILED.warn((Object)this, (Object)inRequest, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
                throw new RequestDataException((Throwable)e, (I18NBoundMessage)new I18NBoundMessage2P(Messages.MARKET_DATA_REQUEST_FAILED, (Serializable)inRequest, (Serializable)ExceptionUtils.getRootCause((Throwable)e)));
            }
        }
    }

    public void cancel(DataFlowID inFlowId, RequestID inRequestID) {
        RequestData requestData = this.requestsByDataFlowId.remove(inFlowId);
        if (requestData == null) {
            Messages.DATA_FLOW_ALREADY_CANCELED.warn((Object)this, (Object)inFlowId);
        } else {
            SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Canceling data flow {} with market data request id {}", (Object[])new Object[]{inFlowId, requestData});
            this.requestsByRequestId.remove(requestData.requestId);
            try {
                this.cancelMarketDataRequest(requestData);
            }
            catch (Exception e) {
                if (SLF4JLoggerProxy.isDebugEnabled((Object)((Object)this))) {
                    Messages.CANNOT_CANCEL_DATA_FLOW.warn((Object)this, (Throwable)e, (Object)inFlowId);
                }
                Messages.CANNOT_CANCEL_DATA_FLOW.warn((Object)this, (Object)inFlowId);
            }
        }
    }

    protected void preStart() throws ModuleException {
        if (this.exsimFeedConfig == null) {
            throw new ModuleException((I18NBoundMessage)Messages.FEED_CONFIG_REQUIRED);
        }
        try {
            CapabilityCollection.reportCapability(this.getCapabilities());
            this.fixMessageProcessor = new FixMessageProcessor();
            this.fixMessageProcessor.start();
            String aplVersion = this.exsimFeedConfig.getFixAplVersion();
            FIXVersion version = aplVersion == null ? FIXVersion.getFIXVersion((String)this.exsimFeedConfig.getFixVersion()) : FIXVersion.getFIXVersion((String)aplVersion);
            this.messageFactory = version.getMessageFactory();
            this.application = new FixApplication();
            this.sessionId = this.exsimFeedConfig.getSessionId();
            SessionSettings sessionSettings = new SessionSettings();
            this.exsimFeedConfig.populateSessionSettings(sessionSettings);
            sessionSettings.setString("ConnectionType", "initiator");
            SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Session settings: {}", (Object[])new Object[]{sessionSettings});
            NullLogFactory logFactory = new NullLogFactory();
            MemoryStoreFactory messageStoreFactory = new MemoryStoreFactory();
            this.socketInitiator = new SocketInitiator((Application)this.application, (MessageStoreFactory)messageStoreFactory, sessionSettings, (LogFactory)logFactory, this.messageFactory.getUnderlyingMessageFactory());
            this.socketInitiator.start();
        }
        catch (ConfigError e) {
            SLF4JLoggerProxy.warn((Object)((Object)this), (Throwable)e);
            throw new ModuleException((Throwable)e);
        }
    }

    protected void preStop() throws ModuleException {
        this.updateFeedStatus(FeedStatus.OFFLINE);
        if (this.fixMessageProcessor != null) {
            try {
                this.fixMessageProcessor.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fixMessageProcessor = null;
        }
        if (this.socketInitiator != null) {
            try {
                this.socketInitiator.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socketInitiator = null;
        }
        this.messageFactory = null;
        this.sessionId = null;
        this.application = null;
    }

    protected ExsimFeedModule(ModuleURN inInstanceUrn) {
        super(inInstanceUrn, false);
        this.feedStatus = FeedStatus.OFFLINE;
        this.orderBooksByInstrument = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<OrderBookKey, OrderBook>(){

            public OrderBook load(OrderBookKey inKey) throws Exception {
                return new OrderBook(inKey.instrument);
            }
        });
    }

    private void doMarketDataRequest(MarketDataRequest inPayload, DataRequest inRequest, DataEmitterSupport inSupport) throws FieldNotFound, SessionNotFound {
        ArrayList requestedInstruments = Lists.newArrayList();
        for (String symbol : inPayload.getSymbols()) {
            Instrument instrument = this.symbolResolverService.resolveSymbol(symbol);
            if (instrument == null) {
                Messages.CANNOT_RESOLVE_SYMBOL.warn((Object)this, (Object)symbol);
                continue;
            }
            requestedInstruments.add(instrument);
        }
        String id = UUID.randomUUID().toString();
        Message marketDataRequest = this.messageFactory.newMarketDataRequest(id, (List)requestedInstruments, inPayload.getExchange(), (List)Lists.newArrayList((Iterable)inPayload.getContent()), '1');
        SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Built {} for {} from {}", (Object[])new Object[]{marketDataRequest, inRequest, inPayload});
        RequestData requestData = new RequestData(marketDataRequest, inSupport, id, inPayload, requestedInstruments);
        this.requestsByRequestId.put(id, requestData);
        this.requestsByDataFlowId.put(inSupport.getFlowID(), requestData);
        if (!Session.sendToTarget((Message)marketDataRequest, (SessionID)this.sessionId)) {
            this.requestsByRequestId.remove(id);
            this.requestsByDataFlowId.remove(inSupport.getFlowID());
            throw new StopDataFlowException((I18NBoundMessage)new I18NBoundMessage1P(Messages.CANNOT_REQUEST_DATA, (Serializable)marketDataRequest));
        }
    }

    private void cancelMarketDataRequest(RequestData inMarketDataRequestData) throws FieldNotFound, SessionNotFound {
        Message marketDataCancel = this.messageFactory.newMarketDataRequest(inMarketDataRequestData.requestId, inMarketDataRequestData.requestedInstruments, inMarketDataRequestData.marketDataRequest.getExchange(), (List)Lists.newArrayList((Iterable)inMarketDataRequestData.marketDataRequest.getContent()), '2');
        if (!Session.sendToTarget((Message)marketDataCancel, (SessionID)this.sessionId)) {
            throw new CoreException((I18NBoundMessage)new I18NBoundMessage2P(Messages.CANNOT_CANCEL_DATA, (Serializable)marketDataCancel, (Serializable)this.sessionId));
        }
    }

    private void updateFeedStatus(FeedStatus inNewStatus) {
        if (inNewStatus == this.feedStatus) {
            return;
        }
        SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Updating feed status from {} to {}", (Object[])new Object[]{this.feedStatus, inNewStatus});
        this.feedStatus = inNewStatus;
        Messages.FEED_STATUS_UPDATE.info((Object)this, (Object)"exsim".toUpperCase(), (Object)this.feedStatus);
        if (this.feedStatus.isRunning()) {
            this.orderBooksByInstrument.invalidateAll();
            SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Feed is available, resubmitting data requests");
        }
    }

    private OrderBook getOrderBookFor(Instrument inInstrument, String inRequestId, String inExchange) {
        return (OrderBook)this.orderBooksByInstrument.getUnchecked((Object)new OrderBookKey(inRequestId, inInstrument, inExchange));
    }

    private List<Event> getEvents(MessageWrapper inMessageWrapper, boolean inIsSnapshot) throws FieldNotFound {
        Message message = inMessageWrapper.getMessage();
        String requestId = inMessageWrapper.getRequestId();
        List mdEntries = this.messageFactory.getMdEntriesFromMessage(message);
        long receivedTimestamp = inMessageWrapper.getReceivedTimestamp();
        ArrayList events = Lists.newArrayList();
        boolean marketstat = false;
        MarketstatEventBuilder marketstatBuilder = null;
        Instrument instrument = null;
        OrderBook orderbook = null;
        String exchange = null;
        if (inIsSnapshot) {
            instrument = FIXMessageUtil.getInstrumentFromMessageFragment((FieldMap)message);
            exchange = FIXMessageUtil.getSecurityExchangeFromMessageFragment((FieldMap)message);
            orderbook = this.getOrderBookFor(instrument, requestId, exchange);
            orderbook.clear();
        }
        BigDecimal volume = null;
        if (message.isSetField(387)) {
            volume = message.getDecimal(387);
        }
        for (Group mdEntry : mdEntries) {
            SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Examining group {}", (Object[])new Object[]{mdEntry});
            BigDecimal closingPrice = null;
            BigDecimal prevClosingPrice = null;
            BigDecimal openPrice = null;
            BigDecimal highPrice = null;
            BigDecimal lowPrice = null;
            BigDecimal vwap = null;
            if (!inIsSnapshot) {
                instrument = FIXMessageUtil.getInstrumentFromMessageFragment((FieldMap)mdEntry);
                exchange = FIXMessageUtil.getSecurityExchangeFromMessageFragment((FieldMap)mdEntry);
                orderbook = this.getOrderBookFor(instrument, requestId, exchange);
            }
            char entryType = mdEntry.getChar(269);
            QuoteAction quoteAction = QuoteAction.ADD;
            if (!inIsSnapshot) {
                char updateAction = mdEntry.getChar(279);
                switch (updateAction) {
                    case '1': {
                        quoteAction = QuoteAction.CHANGE;
                        break;
                    }
                    case '2': {
                        quoteAction = QuoteAction.DELETE;
                        break;
                    }
                    case '0': {
                        quoteAction = QuoteAction.ADD;
                        break;
                    }
                    default: {
                        throw new CoreException((I18NBoundMessage)new I18NBoundMessage1P(Messages.UNSUPPORTED_UPDATE_ACTION, (Serializable)Character.valueOf(updateAction)));
                    }
                }
            }
            Date date = mdEntry.getUtcDateOnly(272);
            Date time = mdEntry.getUtcTimeOnly(273);
            Date eventDate = new Date(date.getTime() + time.getTime());
            switch (entryType) {
                case '0': {
                    QuoteEventBuilder bidBuilder = QuoteEventBuilder.bidEvent((Instrument)instrument);
                    bidBuilder.withAction(quoteAction);
                    bidBuilder.withCount(mdEntry.getInt(346));
                    bidBuilder.withEventType(inIsSnapshot ? EventType.SNAPSHOT_PART : EventType.UPDATE_PART);
                    bidBuilder.withExchange(exchange);
                    int level = mdEntry.getInt(290);
                    bidBuilder.withLevel(level);
                    bidBuilder.withPrice(mdEntry.getDecimal(270));
                    bidBuilder.withProcessedTimestamp(System.nanoTime());
                    bidBuilder.withProvider("exsim");
                    bidBuilder.withQuoteDate(eventDate);
                    bidBuilder.withReceivedTimestamp(receivedTimestamp);
                    bidBuilder.withSize(mdEntry.getDecimal(271));
                    bidBuilder.withSource((Object)requestId);
                    if (instrument instanceof Option) {
                        bidBuilder.withExpirationType(ExpirationType.UNKNOWN);
                        bidBuilder.withUnderlyingInstrument((Instrument)new Equity(instrument.getSymbol()));
                    }
                    switch (quoteAction) {
                        case CHANGE: 
                        case DELETE: {
                            bidBuilder.withMessageId(this.getBidIdFor(orderbook, level));
                            break;
                        }
                        case ADD: {
                            bidBuilder.withMessageId(this.idCounter.incrementAndGet());
                        }
                    }
                    if (inIsSnapshot && level == 0) {
                        bidBuilder.isEmpty(true);
                    }
                    BidEvent bid = (BidEvent)bidBuilder.create();
                    orderbook.process((QuoteEvent)bid);
                    events.add(bid);
                    break;
                }
                case '1': {
                    QuoteEventBuilder askBuilder = QuoteEventBuilder.askEvent((Instrument)instrument);
                    askBuilder.withAction(quoteAction);
                    askBuilder.withCount(mdEntry.getInt(346));
                    askBuilder.withEventType(inIsSnapshot ? EventType.SNAPSHOT_PART : EventType.UPDATE_PART);
                    askBuilder.withExchange(exchange);
                    int level = mdEntry.getInt(290);
                    askBuilder.withLevel(level);
                    askBuilder.withPrice(mdEntry.getDecimal(270));
                    askBuilder.withProcessedTimestamp(System.nanoTime());
                    askBuilder.withProvider("exsim");
                    askBuilder.withQuoteDate(eventDate);
                    askBuilder.withReceivedTimestamp(receivedTimestamp);
                    askBuilder.withSize(mdEntry.getDecimal(271));
                    askBuilder.withSource((Object)requestId);
                    if (instrument instanceof Option) {
                        askBuilder.withExpirationType(ExpirationType.UNKNOWN);
                        askBuilder.withUnderlyingInstrument((Instrument)new Equity(instrument.getSymbol()));
                    }
                    switch (quoteAction) {
                        case CHANGE: 
                        case DELETE: {
                            askBuilder.withMessageId(this.getAskIdFor(orderbook, level));
                            break;
                        }
                        case ADD: {
                            askBuilder.withMessageId(this.idCounter.incrementAndGet());
                        }
                    }
                    if (inIsSnapshot && level == 0) {
                        askBuilder.isEmpty(true);
                    }
                    AskEvent ask = (AskEvent)askBuilder.create();
                    orderbook.process((QuoteEvent)ask);
                    events.add(ask);
                    break;
                }
                case '2': {
                    TradeEventBuilder tradeBuilder = TradeEventBuilder.tradeEvent((Instrument)instrument);
                    tradeBuilder.withEventType(inIsSnapshot ? EventType.SNAPSHOT_PART : EventType.UPDATE_PART);
                    tradeBuilder.withExchange(exchange);
                    tradeBuilder.withPrice(mdEntry.getDecimal(270));
                    tradeBuilder.withProcessedTimestamp(System.nanoTime());
                    tradeBuilder.withProvider("exsim");
                    tradeBuilder.withTradeDate(eventDate);
                    tradeBuilder.withReceivedTimestamp(receivedTimestamp);
                    tradeBuilder.withSize(mdEntry.getDecimal(271));
                    tradeBuilder.withSource((Object)requestId);
                    if (instrument instanceof Option) {
                        tradeBuilder.withExpirationType(ExpirationType.UNKNOWN);
                        tradeBuilder.withUnderlyingInstrument((Instrument)new Equity(instrument.getSymbol()));
                    }
                    events.add(tradeBuilder.create());
                    if (!mdEntry.isSetField(387)) break;
                    marketstat = true;
                    volume = mdEntry.getDecimal(387);
                    break;
                }
                case 'M': {
                    marketstat = true;
                    prevClosingPrice = mdEntry.getDecimal(270);
                    break;
                }
                case '5': {
                    marketstat = true;
                    closingPrice = mdEntry.getDecimal(270);
                    break;
                }
                case '4': {
                    marketstat = true;
                    openPrice = mdEntry.getDecimal(270);
                    break;
                }
                case 'B': {
                    marketstat = true;
                    volume = mdEntry.getDecimal(271);
                    break;
                }
                case '7': {
                    marketstat = true;
                    highPrice = mdEntry.getDecimal(270);
                    break;
                }
                case '8': {
                    marketstat = true;
                    lowPrice = mdEntry.getDecimal(270);
                    break;
                }
                case '9': {
                    marketstat = true;
                    vwap = mdEntry.getDecimal(270);
                    break;
                }
                default: {
                    Messages.IGNORING_UNHANDLED_UPDATE_TYPE.warn((Object)this, (Object)Character.valueOf(entryType));
                }
            }
            if (!marketstat) continue;
            if (marketstatBuilder == null) {
                marketstatBuilder = MarketstatEventBuilder.marketstat((Instrument)instrument);
            }
            marketstatBuilder.withExchangeCode(exchange);
            if (openPrice != null) {
                marketstatBuilder.withOpenPrice(openPrice);
                marketstatBuilder.withClosePrice(openPrice);
                marketstatBuilder.withPreviousClosePrice(openPrice);
            }
            if (closingPrice != null) {
                marketstatBuilder.withClosePrice(closingPrice);
                marketstatBuilder.withPreviousClosePrice(closingPrice);
            }
            if (prevClosingPrice != null) {
                marketstatBuilder.withPreviousClosePrice(prevClosingPrice);
            }
            if (volume != null) {
                marketstatBuilder.withVolume(volume);
            }
            if (highPrice != null) {
                marketstatBuilder.withHighPrice(highPrice);
            }
            if (lowPrice != null) {
                marketstatBuilder.withLowPrice(lowPrice);
            }
            if (vwap != null) {
                marketstatBuilder.withValue(vwap);
            }
            if (instrument instanceof Option) {
                marketstatBuilder.withExpirationType(ExpirationType.UNKNOWN);
                marketstatBuilder.withUnderlyingInstrument((Instrument)new Equity(instrument.getSymbol()));
            }
            marketstatBuilder.withEventType(inIsSnapshot ? EventType.SNAPSHOT_PART : EventType.UPDATE_PART);
        }
        if (marketstat) {
            events.add(marketstatBuilder.create());
        }
        return events;
    }

    private long getAskIdFor(OrderBook inOrderbook, int inLevel) {
        return ((AskEvent)inOrderbook.getAskBook().get(inLevel - 1)).getMessageId();
    }

    private long getBidIdFor(OrderBook inOrderbook, int inLevel) {
        return ((BidEvent)inOrderbook.getBidBook().get(inLevel - 1)).getMessageId();
    }

    private void publishEvents(Deque<Event> inEvents, String inRequestId) {
        RequestData requestData = this.requestsByRequestId.get(inRequestId);
        if (requestData == null) {
            SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Not publishing {} to {} because it seems to have just been canceled", (Object[])new Object[]{inEvents, inRequestId});
            return;
        }
        SLF4JLoggerProxy.trace((Object)((Object)this), (String)"Publishing {} to {}", (Object[])new Object[]{inEvents, inRequestId});
        for (Event event : inEvents) {
            try {
                requestData.getDataEmitterSupport().send((Object)event);
            }
            catch (Exception e) {
                if (SLF4JLoggerProxy.isDebugEnabled((Object)((Object)this))) {
                    Messages.IGNORED_EXCEPTION_ON_SEND.warn((Object)this, (Throwable)e, (Object)ExceptionUtils.getRootCause((Throwable)e), (Object)event, (Object)requestData);
                    continue;
                }
                Messages.IGNORED_EXCEPTION_ON_SEND.warn((Object)this, (Object)ExceptionUtils.getRootCause((Throwable)e), (Object)event, (Object)requestData);
            }
        }
    }

    private static final class OrderBookKey {
        private final String requestId;
        private final Instrument instrument;
        private final String exchange;

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.requestId).append((Object)this.instrument).append((Object)this.exchange).toHashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof OrderBookKey)) {
                return false;
            }
            OrderBookKey other = (OrderBookKey)obj;
            return new EqualsBuilder().append((Object)this.requestId, (Object)other.requestId).append((Object)this.instrument, (Object)other.instrument).append((Object)this.exchange, (Object)other.exchange).isEquals();
        }

        private OrderBookKey(String inRequestId, Instrument inInstrument, String inExchange) {
            this.requestId = inRequestId;
            this.instrument = inInstrument;
            this.exchange = inExchange;
        }
    }

    private static class RequestData {
        private volatile boolean resubmitting = false;
        private final String description;
        private final Message requestMessage;
        private final DataEmitterSupport dataEmitterSupport;
        private final String requestId;
        private final List<Instrument> requestedInstruments;
        private final MarketDataRequest marketDataRequest;

        public String toString() {
            return this.description;
        }

        private Message getRequestMessage() {
            return this.requestMessage;
        }

        private DataEmitterSupport getDataEmitterSupport() {
            return this.dataEmitterSupport;
        }

        private RequestData(Message inRequestMessage, DataEmitterSupport inDataEmitterSupport, String inRequestId, MarketDataRequest inMarketDataRequest, List<Instrument> inRequestedInstruments) {
            this.requestMessage = inRequestMessage;
            this.dataEmitterSupport = inDataEmitterSupport;
            this.description = RequestData.class.getSimpleName() + " [" + inDataEmitterSupport.getFlowID() + "]";
            this.requestId = inRequestId;
            this.requestedInstruments = inRequestedInstruments;
            this.marketDataRequest = inMarketDataRequest;
        }
    }

    private class FixApplication
    implements Application {
        private FixApplication() {
        }

        public void onCreate(SessionID inSessionId) {
            SLF4JLoggerProxy.debug((Object)((Object)ExsimFeedModule.this), (String)"Session {} created", (Object[])new Object[]{inSessionId});
        }

        public void onLogon(SessionID inSessionId) {
            SLF4JLoggerProxy.debug((Object)((Object)ExsimFeedModule.this), (String)"Session {} logon", (Object[])new Object[]{inSessionId});
            ExsimFeedModule.this.updateFeedStatus(FeedStatus.AVAILABLE);
        }

        public void onLogout(SessionID inSessionId) {
            SLF4JLoggerProxy.debug((Object)((Object)ExsimFeedModule.this), (String)"Session {} logout", (Object[])new Object[]{inSessionId});
            ExsimFeedModule.this.updateFeedStatus(FeedStatus.OFFLINE);
        }

        public void toAdmin(Message inMessage, SessionID inSessionId) {
            SLF4JLoggerProxy.trace((Object)((Object)ExsimFeedModule.this), (String)"{} sending admin {}", (Object[])new Object[]{inSessionId, inMessage});
        }

        public void fromAdmin(Message inMessage, SessionID inSessionId) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, RejectLogon {
            SLF4JLoggerProxy.trace((Object)((Object)ExsimFeedModule.this), (String)"{} received admin {}", (Object[])new Object[]{inSessionId, inMessage});
        }

        public void toApp(Message inMessage, SessionID inSessionId) throws DoNotSend {
            SLF4JLoggerProxy.trace((Object)((Object)ExsimFeedModule.this), (String)"{} sending app {}", (Object[])new Object[]{inSessionId, inMessage});
            if (SLF4JLoggerProxy.isTraceEnabled((Object)((Object)ExsimFeedModule.this))) {
                FIXMessageUtil.logMessage((SessionID)inSessionId, (Message)inMessage);
            }
        }

        public void fromApp(Message inMessage, SessionID inSessionId) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
            SLF4JLoggerProxy.trace((Object)((Object)ExsimFeedModule.this), (String)"{} received app {}", (Object[])new Object[]{inSessionId, inMessage});
            if (SLF4JLoggerProxy.isTraceEnabled((Object)((Object)ExsimFeedModule.this))) {
                FIXMessageUtil.logMessage((SessionID)inSessionId, (Message)inMessage);
            }
            if (ExsimFeedModule.this.fixMessageProcessor != null) {
                ExsimFeedModule.this.fixMessageProcessor.add(inMessage);
            }
        }
    }

    private static class MessageWrapper {
        private final String requestId;
        private final Message message;
        private final String msgType;
        private final long receivedTimestamp = System.nanoTime();

        private MessageWrapper(Message inMessage) throws FieldNotFound {
            this.message = inMessage;
            this.msgType = this.message.getHeader().getString(35);
            this.requestId = this.message.getString(262);
        }

        private String getRequestId() {
            return this.requestId;
        }

        private String getMsgType() {
            return this.msgType;
        }

        private Message getMessage() {
            return this.message;
        }

        private long getReceivedTimestamp() {
            return this.receivedTimestamp;
        }
    }

    private class FixMessageProcessor
    extends BatchQueueProcessor<MessageWrapper> {
        private final String description;

        public String toString() {
            return this.description;
        }

        protected void processData(Deque<MessageWrapper> inData) throws Exception {
            block12: for (MessageWrapper messageWrapper : inData) {
                Message message = messageWrapper.getMessage();
                try {
                    SLF4JLoggerProxy.trace((Object)((Object)ExsimFeedModule.this), (String)"{} processing {}", (Object[])new Object[]{this, message});
                    String msgType = messageWrapper.getMsgType();
                    String requestId = messageWrapper.getRequestId();
                    boolean isSnapshot = false;
                    switch (msgType) {
                        case "W": {
                            isSnapshot = true;
                        }
                        case "X": {
                            Event lastEvent;
                            LinkedList events = Lists.newLinkedList();
                            events.addAll(ExsimFeedModule.this.getEvents(messageWrapper, isSnapshot));
                            if (!events.isEmpty() && (lastEvent = (Event)events.getLast()) instanceof HasEventType) {
                                HasEventType eventTypeEvent = (HasEventType)lastEvent;
                                eventTypeEvent.setEventType(isSnapshot ? EventType.SNAPSHOT_FINAL : EventType.UPDATE_FINAL);
                            }
                            SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Produced {}", (Object[])new Object[]{events});
                            ExsimFeedModule.this.publishEvents(events, requestId);
                            break;
                        }
                        case "Y": {
                            RequestData requestData = (RequestData)ExsimFeedModule.this.requestsByRequestId.get(messageWrapper.getRequestId());
                            if (requestData == null) break;
                            if (requestData.resubmitting) continue block12;
                            ExsimFeedModule.this.requestsByRequestId.remove(messageWrapper.getRequestId());
                            ExsimFeedModule.this.requestsByDataFlowId.remove(requestData.getDataEmitterSupport().getFlowID());
                            Object errorMessage = message.isSetField(58) ? new I18NBoundMessage1P(Messages.MARKETDATA_REJECT_WITH_MESSAGE, (Serializable)((Object)message.getString(58))) : new I18NBoundMessage0P(Messages.MARKETDATA_REJECT_WITHOUT_MESSAGE);
                            requestData.getDataEmitterSupport().dataEmitError((I18NBoundMessage)errorMessage, true);
                            break;
                        }
                        default: {
                            Messages.IGNORING_UNEXPECTED_MESSAGE.warn((Object)ExsimFeedModule.this, (Object)this, (Object)message);
                        }
                    }
                }
                catch (Exception e) {
                    if (SLF4JLoggerProxy.isDebugEnabled((Object)((Object)ExsimFeedModule.this))) {
                        Messages.UNABLE_TO_PROCESS_MESSAGE.warn((Object)ExsimFeedModule.this, (Throwable)e, (Object)this, (Object)message, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                        continue;
                    }
                    Messages.UNABLE_TO_PROCESS_MESSAGE.warn((Object)ExsimFeedModule.this, (Object)this, (Object)message, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
        }

        private void add(Message inMessage) throws FieldNotFound {
            super.add((Object)new MessageWrapper(inMessage));
        }

        private FixMessageProcessor() {
            super(ExsimFeedModule.class.getSimpleName() + "-MessageProcessor");
            this.description = ExsimFeedModule.class.getSimpleName() + "-MessageProcessor";
        }
    }
}

