/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.exsim;

import java.lang.management.ManagementFactory;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.marketcetera.marketdata.MarketDataModuleMXBean;
import org.marketcetera.marketdata.exsim.ExsimFeedModuleFactory;
import org.marketcetera.marketdata.exsim.ExsimTestConfiguration;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.module.ModuleState;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={ExsimTestConfiguration.class})
@ComponentScan(basePackages={"org.marketcetera", "com.marketcetera"})
@EntityScan(basePackages={"org.marketcetera", "com.marketcetera"})
public class ExsimFeedModuleTest
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private ModuleManager moduleManager;
    private MBeanServer mbeanServer;

    @Before
    public void setup() throws Exception {
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.moduleManager = (ModuleManager)this.applicationContext.getBean(ModuleManager.class);
    }

    @After
    public void cleanup() throws Exception {
        try {
            this.moduleManager.stop(ExsimFeedModuleFactory.INSTANCE_URN);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testStartAndStop() throws Exception {
        this.moduleManager.start(ExsimFeedModuleFactory.INSTANCE_URN);
        Assert.assertEquals((Object)ModuleState.STARTED, (Object)this.moduleManager.getModuleInfo(ExsimFeedModuleFactory.INSTANCE_URN).getState());
    }

    public void setApplicationContext(ApplicationContext inApplicationContext) throws BeansException {
        this.applicationContext = inApplicationContext;
    }

    private MarketDataModuleMXBean getModuleBean() throws MalformedObjectNameException {
        ObjectName sessionObjectName = this.getModuleObjectName();
        MarketDataModuleMXBean sessionAdmin = JMX.newMXBeanProxy(this.mbeanServer, sessionObjectName, MarketDataModuleMXBean.class, true);
        return sessionAdmin;
    }

    private ObjectName getModuleObjectName() throws MalformedObjectNameException {
        StringBuilder builder = new StringBuilder();
        builder.append("org.marketcetera.module:type=mdata,provider=").append("exsim").append(",name=single");
        return new ObjectName(builder.toString());
    }
}

