/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.manual;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.event.Event;
import org.marketcetera.marketdata.Capability;
import org.marketcetera.marketdata.FeedStatus;
import org.marketcetera.marketdata.FeedStatusRequest;
import org.marketcetera.marketdata.MarketDataCapabilityBroadcaster;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.marketdata.MarketDataRequestBuilder;
import org.marketcetera.marketdata.MarketDataStatus;
import org.marketcetera.marketdata.MarketDataStatusBroadcaster;
import org.marketcetera.marketdata.manual.Messages;
import org.marketcetera.marketdata.service.MarketDataService;
import org.marketcetera.module.AutowiredModule;
import org.marketcetera.module.DataEmitter;
import org.marketcetera.module.DataEmitterSupport;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.Module;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.RequestDataException;
import org.marketcetera.module.RequestID;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;

@AutowiredModule
public class ManualFeedModule
extends Module
implements DataEmitter {
    private volatile FeedStatus feedStatus;
    private final Cache<DataFlowID, FeedStatusRequestData> feedStatusRequestDataByDataFlowId = CacheBuilder.newBuilder().build();
    @Autowired(required=false)
    private Collection<MarketDataCapabilityBroadcaster> capabilityBroadcasters = Lists.newArrayList();
    @Autowired(required=false)
    private Collection<MarketDataStatusBroadcaster> statusBroadcasters = Lists.newArrayList();
    @Autowired
    private MarketDataService marketDataService;
    private final Cache<String, MarketDataRequestData> requestsByRequestId = CacheBuilder.newBuilder().build();
    private final Cache<DataFlowID, MarketDataRequestData> requestsByDataFlowId = CacheBuilder.newBuilder().build();
    private static ManualFeedModule instance;

    public static ManualFeedModule getInstance() {
        return instance;
    }

    public void emit(String inRequestId, Collection<Event> inEvents) {
        if (inRequestId == null) {
            SLF4JLoggerProxy.debug((Object)((Object)this), (String)"No request id specified, submitting to all data flows");
            for (MarketDataRequestData request : this.requestsByRequestId.asMap().values()) {
                for (Event event : inEvents) {
                    this.emit(request.getDataEmitterSupport(), event);
                }
            }
        } else {
            MarketDataRequestData requestData = (MarketDataRequestData)this.requestsByRequestId.getIfPresent((Object)inRequestId);
            if (requestData == null) {
                SLF4JLoggerProxy.warn((Object)((Object)this), (String)"No request with id {}, cannot emit events", (Object[])new Object[]{inRequestId});
            } else {
                for (Event event : inEvents) {
                    this.emit(requestData.getDataEmitterSupport(), event);
                }
            }
        }
    }

    public void emit(String inRequestId, Event inEvent) {
        if (inRequestId == null) {
            SLF4JLoggerProxy.debug((Object)((Object)this), (String)"No request id specified, submitting to all data flows");
            for (MarketDataRequestData request : this.requestsByRequestId.asMap().values()) {
                this.emit(request.getDataEmitterSupport(), inEvent);
            }
        } else {
            MarketDataRequestData requestData = (MarketDataRequestData)this.requestsByRequestId.getIfPresent((Object)inRequestId);
            if (requestData == null) {
                SLF4JLoggerProxy.warn((Object)((Object)this), (String)"No request with id {}, cannot emit events", (Object[])new Object[]{inRequestId});
            } else {
                this.emit(requestData.getDataEmitterSupport(), inEvent);
            }
        }
    }

    public BiMap<String, MarketDataRequest> getRequests() {
        HashBiMap requests = HashBiMap.create();
        for (Map.Entry entry : this.requestsByRequestId.asMap().entrySet()) {
            requests.put((Object)((String)entry.getKey()), (Object)((MarketDataRequestData)entry.getValue()).getMarketDataRequest());
        }
        return requests;
    }

    public void requestData(DataRequest inRequest, DataEmitterSupport inSupport) throws RequestDataException {
        block8: {
            SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Received a data flow request: {}", (Object[])new Object[]{inRequest});
            Object payload = inRequest.getData();
            try {
                if (payload == null) {
                    throw new RequestDataException((I18NBoundMessage)Messages.DATA_REQUEST_PAYLOAD_REQUIRED);
                }
                if (payload instanceof String) {
                    String stringPayload = (String)payload;
                    try {
                        this.doMarketDataRequest(MarketDataRequestBuilder.newRequestFromString((String)stringPayload), inRequest, inSupport);
                        break block8;
                    }
                    catch (Exception e) {
                        throw new RequestDataException((I18NBoundMessage)new I18NBoundMessage2P(Messages.INVALID_DATA_REQUEST_PAYLOAD, (Serializable)((Object)stringPayload), (Serializable)ExceptionUtils.getRootCause((Throwable)e)));
                    }
                }
                if (payload instanceof MarketDataRequest) {
                    this.doMarketDataRequest((MarketDataRequest)payload, inRequest, inSupport);
                    break block8;
                }
                if (payload instanceof FeedStatusRequest) {
                    this.doFeedStatusRequest((FeedStatusRequest)payload, inRequest, inSupport);
                    break block8;
                }
                throw new RequestDataException((I18NBoundMessage)new I18NBoundMessage1P(Messages.UNSUPPORTED_DATA_REQUEST_PAYLOAD, (Serializable)((Object)payload.getClass().getSimpleName())));
            }
            catch (Exception e) {
                PlatformServices.handleException((Object)((Object)this), (String)"Market data request failed", (Throwable)e);
                throw new RequestDataException((Throwable)e);
            }
        }
    }

    public void cancel(DataFlowID inFlowId, RequestID inRequestID) {
        MarketDataRequestData requestData = (MarketDataRequestData)this.requestsByDataFlowId.getIfPresent((Object)inFlowId);
        this.requestsByDataFlowId.invalidate((Object)inFlowId);
        if (requestData != null) {
            SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Canceling data flow {} with market data request id {}", (Object[])new Object[]{inFlowId, requestData});
            this.requestsByRequestId.invalidate((Object)requestData.requestId);
        }
    }

    protected void preStart() throws ModuleException {
        for (MarketDataCapabilityBroadcaster broadcaster : this.capabilityBroadcasters) {
            broadcaster.reportCapability(EnumSet.allOf(Capability.class));
        }
        this.updateFeedStatus(FeedStatus.AVAILABLE);
    }

    protected void preStop() throws ModuleException {
        this.requestsByDataFlowId.invalidateAll();
        this.requestsByRequestId.invalidateAll();
        this.updateFeedStatus(FeedStatus.OFFLINE);
    }

    ManualFeedModule(ModuleURN inUrn) {
        super(inUrn, false);
        instance = this;
    }

    private void updateFeedStatus(FeedStatus inNewStatus) {
        if (inNewStatus == this.feedStatus) {
            return;
        }
        SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Updating feed status from {} to {}", (Object[])new Object[]{this.feedStatus, inNewStatus});
        this.feedStatus = inNewStatus;
        MarketDataStatus marketDataStatus = new MarketDataStatus(){

            public FeedStatus getFeedStatus() {
                return ManualFeedModule.this.feedStatus;
            }

            public String getProvider() {
                return "manual";
            }
        };
        this.marketDataService.reportMarketDataStatus(marketDataStatus);
        for (FeedStatusRequestData feedStatusRequestData : this.feedStatusRequestDataByDataFlowId.asMap().values()) {
            try {
                feedStatusRequestData.getDataEmitterSupport().send((Object)marketDataStatus);
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)((Object)this), (Throwable)e);
            }
        }
        for (MarketDataStatusBroadcaster broadcaster : this.statusBroadcasters) {
            broadcaster.reportMarketDataStatus(marketDataStatus);
        }
    }

    private void doFeedStatusRequest(FeedStatusRequest inPayload, DataRequest inRequest, DataEmitterSupport inSupport) {
        FeedStatusRequestData metaData = new FeedStatusRequestData(inSupport);
        this.feedStatusRequestDataByDataFlowId.put((Object)inSupport.getFlowID(), (Object)metaData);
    }

    private void emit(DataEmitterSupport inDataEmitter, Event inEvent) {
        SLF4JLoggerProxy.trace((Object)((Object)this), (String)"Sending {} to {}", (Object[])new Object[]{inEvent, inDataEmitter.getFlowID()});
        inDataEmitter.send((Object)inEvent);
    }

    private void doMarketDataRequest(MarketDataRequest inPayload, DataRequest inRequest, DataEmitterSupport inSupport) {
        String id = inPayload.getRequestId();
        MarketDataRequestData requestData = new MarketDataRequestData(inSupport, id, inPayload);
        this.requestsByRequestId.put((Object)id, (Object)requestData);
        this.requestsByDataFlowId.put((Object)inSupport.getFlowID(), (Object)requestData);
    }

    private static class MarketDataRequestData
    extends AbstractRequestData {
        private final String description;
        private final String requestId;
        private final MarketDataRequest marketDataRequest;

        public String toString() {
            return this.description;
        }

        private String getRequestId() {
            return this.requestId;
        }

        private MarketDataRequest getMarketDataRequest() {
            return this.marketDataRequest;
        }

        private MarketDataRequestData(DataEmitterSupport inDataEmitterSupport, String inRequestId, MarketDataRequest inMarketDataRequest) {
            super(inDataEmitterSupport);
            this.description = MarketDataRequestData.class.getSimpleName() + " [" + inDataEmitterSupport.getFlowID() + "]";
            this.requestId = inRequestId;
            this.marketDataRequest = inMarketDataRequest;
        }
    }

    private static class FeedStatusRequestData
    extends AbstractRequestData {
        private FeedStatusRequestData(DataEmitterSupport inDataEmitterSupport) {
            super(inDataEmitterSupport);
        }
    }

    private static abstract class AbstractRequestData {
        private final DataEmitterSupport dataEmitterSupport;

        protected DataEmitterSupport getDataEmitterSupport() {
            return this.dataEmitterSupport;
        }

        protected AbstractRequestData(DataEmitterSupport inDataEmitterSupport) {
            this.dataEmitterSupport = inDataEmitterSupport;
        }
    }
}

