/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.marketcetera;

import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.core.ExpectedTestFailure;
import org.marketcetera.marketdata.marketcetera.MarketceteraOptionSymbol;

public class MarketceteraOptionSymbolTest {
    @Test
    public void testGetExpirationCode() {
        MarketceteraOptionSymbol symbol = new MarketceteraOptionSymbol("IBM+AZ");
        Assert.assertEquals((long)65L, (long)symbol.getExpirationCode());
    }

    @Test
    public void testGetStrikeCode() {
        MarketceteraOptionSymbol symbol = new MarketceteraOptionSymbol("IBM+AZ");
        Assert.assertEquals((long)90L, (long)symbol.getStrikeCode());
    }

    @Test
    public void testMatchesPattern() {
        Assert.assertTrue((boolean)MarketceteraOptionSymbol.matchesPattern((String)"IBM+AZ"));
        Assert.assertTrue((boolean)MarketceteraOptionSymbol.matchesPattern((String)"IB+AZ"));
        Assert.assertTrue((boolean)MarketceteraOptionSymbol.matchesPattern((String)"I+AZ"));
        Assert.assertFalse((boolean)MarketceteraOptionSymbol.matchesPattern((String)"+AZ"));
        Assert.assertFalse((boolean)MarketceteraOptionSymbol.matchesPattern((String)"IBMI+AZ"));
        Assert.assertFalse((boolean)MarketceteraOptionSymbol.matchesPattern((String)"IBM+Z"));
        Assert.assertFalse((boolean)MarketceteraOptionSymbol.matchesPattern((String)"IBM+AZZ"));
        Assert.assertFalse((boolean)MarketceteraOptionSymbol.matchesPattern((String)""));
        Assert.assertFalse((boolean)MarketceteraOptionSymbol.matchesPattern((String)"IBMAZ"));
    }

    @Test
    public void testToString() {
        String symbolString = "IBM+AZ";
        MarketceteraOptionSymbol symbol = new MarketceteraOptionSymbol(symbolString);
        Assert.assertEquals((Object)symbolString, (Object)symbol.toString());
    }

    @Test
    public void testMarketceteraOptionSymbol() throws Exception {
        String symbolString = "IBM+AZ";
        MarketceteraOptionSymbol symbol = new MarketceteraOptionSymbol(symbolString);
        Assert.assertEquals((Object)symbolString, (Object)symbol.toString());
        new ExpectedTestFailure(IllegalArgumentException.class){

            protected void execute() throws Throwable {
                new MarketceteraOptionSymbol("IBM+R");
            }
        }.run();
    }
}

