/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.marketcetera;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.marketcetera.core.CoreException;
import org.marketcetera.marketdata.Content;
import org.marketcetera.marketdata.DataRequestTranslator;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.marketdata.Messages;
import org.marketcetera.marketdata.marketcetera.MarketceteraFeed;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.trade.Equity;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import quickfix.Message;

public class MarketceteraFeedMessageTranslator
implements DataRequestTranslator<MarketceteraFeed.Request> {
    private static final FIXVersion DEFAULT_MESSAGE_FACTORY = FIXVersion.FIX44;
    private static final MarketceteraFeedMessageTranslator sInstance = new MarketceteraFeedMessageTranslator();
    private static final AtomicLong counter = new AtomicLong(0L);

    public MarketceteraFeed.Request fromDataRequest(MarketDataRequest inRequest) throws CoreException {
        if (inRequest.validateWithCapabilities(new Content[]{Content.TOP_OF_BOOK, Content.LATEST_TICK})) {
            return MarketceteraFeedMessageTranslator.fixMessageFromMarketDataRequest(inRequest);
        }
        throw new CoreException((I18NBoundMessage)new I18NBoundMessage1P(Messages.UNSUPPORTED_REQUEST, (Serializable)((Object)String.valueOf(inRequest.getContent()))));
    }

    static MarketceteraFeedMessageTranslator getInstance() {
        return sInstance;
    }

    private MarketceteraFeedMessageTranslator() {
    }

    private static MarketceteraFeed.Request fixMessageFromMarketDataRequest(MarketDataRequest inRequest) {
        ArrayList<Equity> symbolList = new ArrayList<Equity>();
        for (String symbol : inRequest.getSymbols()) {
            symbolList.add(new Equity(symbol));
        }
        long id = counter.incrementAndGet();
        Message message = DEFAULT_MESSAGE_FACTORY.getMessageFactory().newMarketDataRequest(Long.toString(id), symbolList, inRequest.getExchange());
        message.setChar(263, '1');
        return new MarketceteraFeed.Request(id, message, inRequest);
    }
}

