/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.marketcetera;

import org.marketcetera.core.ClassVersion;
import org.marketcetera.marketdata.AbstractMarketDataFeedURLCredentials;
import org.marketcetera.marketdata.FeedException;
import org.marketcetera.marketdata.marketcetera.Messages;
import org.marketcetera.util.log.I18NBoundMessage;

@ClassVersion(value="$Id$")
public class MarketceteraFeedCredentials
extends AbstractMarketDataFeedURLCredentials {
    private final String mSenderCompID;
    private final String mTargetCompID;

    public static MarketceteraFeedCredentials getInstance(String inURL, String inSenderCompID, String inTargetCompID) throws FeedException {
        return new MarketceteraFeedCredentials(inURL, inSenderCompID, inTargetCompID);
    }

    private MarketceteraFeedCredentials(String inURL, String inSenderCompID, String inTargetCompID) throws FeedException {
        super(inURL);
        this.mSenderCompID = inSenderCompID;
        this.mTargetCompID = inTargetCompID;
        if (this.mTargetCompID == null || this.mTargetCompID.trim().isEmpty()) {
            Messages.TARGET_COMP_ID_REQUIRED.error((Object)"datafeed.status");
            throw new FeedException((I18NBoundMessage)Messages.TARGET_COMP_ID_REQUIRED);
        }
    }

    public String getSenderCompID() {
        return this.mSenderCompID;
    }

    public String getTargetCompID() {
        return this.mTargetCompID;
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append("Marketcetera Feed Credentials: URL=").append(this.getURL()).append(" SenderCompID=").append(this.getSenderCompID()).append(" TargetCompID=").append(this.getTargetCompID());
        return output.toString();
    }

    protected void validateURL(String inURL) throws FeedException {
        super.validateURL(inURL);
        if (inURL == null || inURL.isEmpty()) {
            Messages.URL_REQUIRED.error((Object)"datafeed.status");
            throw new FeedException((I18NBoundMessage)Messages.URL_REQUIRED);
        }
    }
}

