/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.marketcetera;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.marketdata.marketcetera.Messages;
import org.marketcetera.symbology.IEquityOptionSymbol;
import org.marketcetera.trade.Equity;

@ClassVersion(value="$Id$")
public class MarketceteraOptionSymbol
extends Equity
implements IEquityOptionSymbol,
Messages {
    static final Pattern optionSymbolPattern = Pattern.compile("(\\w{1,3})\\+(\\w)(\\w)");
    private char expirationCode;
    private char strikeCode;
    private String root;
    private static final long serialVersionUID = 1554959422242754909L;

    public MarketceteraOptionSymbol(String symbolString) {
        super(symbolString);
        Matcher matcher = optionSymbolPattern.matcher(symbolString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(INVALID_EQUITY_OPTION_SYMBOL.getText((Object)symbolString));
        }
        this.root = matcher.group(1);
        this.expirationCode = matcher.group(2).charAt(0);
        this.strikeCode = matcher.group(3).charAt(0);
    }

    public char getExpirationCode() {
        return this.expirationCode;
    }

    public char getStrikeCode() {
        return this.strikeCode;
    }

    public static boolean matchesPattern(String symbolString) {
        return optionSymbolPattern.matcher(symbolString).matches();
    }

    public String getRoot() {
        return this.root;
    }

    public String toString() {
        return this.root + "+" + this.expirationCode + this.strikeCode;
    }
}

