/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.yahoo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import org.marketcetera.marketdata.yahoo.YahooClient;
import org.marketcetera.marketdata.yahoo.YahooFeedCredentials;
import org.marketcetera.marketdata.yahoo.YahooFeedServices;
import org.marketcetera.marketdata.yahoo.YahooRequest;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: YahooClientImpl.java 16154 2012-07-14 16:34:05Z colin $")
class YahooClientImpl
implements Runnable,
YahooClient {
    static final String QUERY_SEPARATOR = "&&/&&";
    private final YahooFeedServices feedServices;
    private volatile Thread thread;
    private volatile YahooFeedCredentials credentials;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    @GuardedBy(value="requests")
    private final Set<YahooRequest> requests = new HashSet<YahooRequest>();
    private final AtomicLong requestCounter = new AtomicLong(0L);

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public synchronized void start() {
        if (this.isRunning.get()) {
            return;
        }
        this.thread = new Thread((Runnable)this, "Yahoo Client Thread");
        this.thread.start();
        this.isRunning.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (!this.isRunning.get()) {
            return;
        }
        try {
            if (this.thread != null) {
                this.thread.interrupt();
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.thread = null;
            this.isRunning.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.isRunning.get()) {
                Set<YahooRequest> set = this.requests;
                synchronized (set) {
                    for (YahooRequest request : this.requests) {
                        this.feedServices.doDataReceived(request.getHandle(), this.submit(request));
                    }
                }
                Thread.sleep(this.feedServices.getRefreshInterval());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean login(YahooFeedCredentials inCredentials) {
        this.credentials = inCredentials;
        this.start();
        return this.isRunning();
    }

    @Override
    public void logout() {
        this.stop();
    }

    @Override
    public boolean isLoggedIn() {
        return this.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(YahooRequest inRequest) {
        Set<YahooRequest> set = this.requests;
        synchronized (set) {
            this.requests.add(inRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(YahooRequest inRequest) {
        Set<YahooRequest> set = this.requests;
        synchronized (set) {
            this.requests.remove(inRequest);
        }
    }

    @Override
    public long getRequestCounter() {
        return this.requestCounter.get();
    }

    @Override
    public void resetRequestcounter() {
        this.requestCounter.set(0L);
    }

    YahooClientImpl(YahooFeedServices inFeedServices) {
        this.feedServices = inFeedServices;
    }

    private String submit(YahooRequest inRequest) throws IOException {
        String str;
        StringBuilder response = new StringBuilder();
        String query = inRequest.getQuery();
        response.append(query).append(QUERY_SEPARATOR);
        URL url = new URL(this.credentials.getURL() + query.replaceAll(",", ""));
        SLF4JLoggerProxy.trace(YahooClientImpl.class, (String)"Submitting request for {}", (Object[])new Object[]{url});
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        this.requestCounter.incrementAndGet();
        while ((str = in.readLine()) != null) {
            response.append(str);
        }
        in.close();
        return response.toString();
    }
}

