/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.yahoo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.marketcetera.core.CoreException;
import org.marketcetera.event.AskEvent;
import org.marketcetera.event.BidEvent;
import org.marketcetera.event.Event;
import org.marketcetera.event.EventTranslator;
import org.marketcetera.event.EventType;
import org.marketcetera.event.HasEventType;
import org.marketcetera.event.QuoteAction;
import org.marketcetera.event.QuoteEvent;
import org.marketcetera.event.TradeEvent;
import org.marketcetera.event.impl.QuoteEventBuilder;
import org.marketcetera.event.impl.TradeEventBuilder;
import org.marketcetera.marketdata.DateUtils;
import org.marketcetera.marketdata.yahoo.Messages;
import org.marketcetera.marketdata.yahoo.YahooField;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Instrument;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: YahooFeedEventTranslator.java 16154 2012-07-14 16:34:05Z colin $")
@ThreadSafe
public enum YahooFeedEventTranslator implements EventTranslator
{
    INSTANCE;

    private final Map<Class<? extends Event>, Event> eventCache = new HashMap<Class<? extends Event>, Event>();
    private static final Comparator<Event> TRADE_COMPARATOR;
    private static final Comparator<Event> QUOTE_COMPARATOR;
    private static final Map<Class<? extends Event>, Comparator<Event>> comparators;
    private static final List<Event> EMPTY_EVENT_LIST;
    private static final String NO_ERROR = "\"N/A\"";

    public synchronized List<Event> toEvent(Object inData, String inHandle) throws CoreException {
        if (!(inData instanceof String)) {
            throw new UnsupportedOperationException(Messages.UNEXPECTED_DATA.getText((Object)inData.getClass().getName()));
        }
        String data = (String)inData;
        SLF4JLoggerProxy.debug(YahooFeedEventTranslator.class, (String)"Received [{}] {}", (Object[])new Object[]{inHandle, data});
        String[] components = data.split("&&/&&");
        String header = components[0];
        String completeFields = header.split("&f=")[1];
        String[] fields = completeFields.split(",");
        String completeValues = components[1];
        String[] values = completeValues.split(",");
        HashMap<YahooField, String> matchedData = new HashMap<YahooField, String>();
        for (int i = 0; i < fields.length; ++i) {
            YahooField field = YahooField.getFieldFor(fields[i]);
            if (field == null) {
                Messages.UNEXPECTED_FIELD_CODE.error(YahooFeedEventTranslator.class, (Object)fields[i]);
                continue;
            }
            matchedData.put(field, values[i]);
        }
        return this.getEventsFrom(matchedData);
    }

    public Object fromEvent(Event inEvent) throws CoreException {
        throw new UnsupportedOperationException();
    }

    private List<Event> getEventsFrom(Map<YahooField, String> inData) {
        SLF4JLoggerProxy.debug(YahooFeedEventTranslator.class, (String)"Getting events from {}", (Object[])new Object[]{inData});
        String errorIndication = inData.get((Object)YahooField.ERROR_INDICATION);
        if (!errorIndication.equals(NO_ERROR)) {
            SLF4JLoggerProxy.warn((Object)"user.messages", (String)errorIndication);
            return EMPTY_EVENT_LIST;
        }
        LinkedList<Event> events = new LinkedList<Event>();
        this.lookForBidEvent(inData, events);
        this.lookForAskEvent(inData, events);
        this.lookForTradeEvent(inData, events);
        this.lookForDividendEvent(inData, events);
        Iterator<Event> marker = events.descendingIterator();
        boolean markedFinal = false;
        while (marker.hasNext()) {
            Event event = marker.next();
            if (this.shouldSendEvent(event)) {
                if (!(event instanceof HasEventType)) continue;
                if (!markedFinal) {
                    ((HasEventType)event).setEventType(EventType.UPDATE_FINAL);
                    markedFinal = true;
                    continue;
                }
                ((HasEventType)event).setEventType(EventType.UPDATE_PART);
                continue;
            }
            marker.remove();
        }
        return events;
    }

    private boolean shouldSendEvent(Event inEvent) {
        Event cachedEvent = this.eventCache.get(inEvent.getClass());
        if (cachedEvent == null) {
            this.eventCache.put(inEvent.getClass(), inEvent);
            return true;
        }
        Comparator<Event> comparator = this.getComparator(inEvent);
        if (comparator == null) {
            throw new UnsupportedOperationException(Messages.NO_COMPARATOR.getText(inEvent.getClass()));
        }
        if (comparator.compare(cachedEvent, inEvent) == 0) {
            return false;
        }
        this.eventCache.put(inEvent.getClass(), inEvent);
        return true;
    }

    private Comparator<Event> getComparator(Event inEvent) {
        Comparator<Event> comparator;
        if (comparators.isEmpty()) {
            comparators.put(TradeEvent.class, TRADE_COMPARATOR);
            comparators.put(BidEvent.class, QUOTE_COMPARATOR);
            comparators.put(AskEvent.class, QUOTE_COMPARATOR);
        }
        if ((comparator = comparators.get(inEvent.getClass())) == null) {
            for (Map.Entry<Class<? extends Event>, Comparator<Event>> entry : comparators.entrySet()) {
                if (!entry.getKey().isAssignableFrom(inEvent.getClass())) continue;
                comparator = entry.getValue();
                comparators.put(inEvent.getClass(), comparator);
                break;
            }
        }
        return comparator;
    }

    private void lookForDividendEvent(Map<YahooField, String> inData, List<Event> inEvents) {
    }

    private <T extends QuoteEvent> void lookForQuoteEvent(Map<YahooField, String> inData, List<Event> inEvents, String inPrice, String inSize, String inSymbol, Instrument inInstrument, QuoteEventBuilder<T> inBuilder) {
        BigDecimal size;
        BigDecimal price;
        String exchange = inData.get((Object)YahooField.STOCK_EXCHANGE);
        if (exchange == null || inPrice == null || inSize == null) {
            return;
        }
        try {
            price = new BigDecimal(inPrice);
            size = new BigDecimal(inSize);
        }
        catch (Exception e) {
            return;
        }
        Date date = new Date();
        inBuilder.withAction(QuoteAction.ADD).withExchange(exchange).withPrice(price).withProviderSymbol(inSymbol).withQuoteDate(DateUtils.dateToString((Date)date)).withSize(size).withTimestamp(date);
        this.addFutureAttributes(inBuilder, inInstrument, inData);
        this.addOptionAttributes(inBuilder, inInstrument, inData);
        inEvents.add(inBuilder.create());
    }

    private void lookForBidEvent(Map<YahooField, String> inData, List<Event> inEvents) {
        String bidPrice = inData.get((Object)YahooField.REAL_TIME_BID);
        String bidSize = inData.get((Object)YahooField.BID_SIZE);
        String symbol = inData.get((Object)YahooField.SYMBOL);
        if (symbol == null || bidPrice == null || bidSize == null) {
            return;
        }
        Instrument instrument = this.getInstrumentFrom(symbol);
        QuoteEventBuilder builder = QuoteEventBuilder.bidEvent((Instrument)instrument);
        this.lookForQuoteEvent(inData, inEvents, bidPrice, bidSize, symbol, instrument, builder);
    }

    private void lookForAskEvent(Map<YahooField, String> inData, List<Event> inEvents) {
        String askPrice = inData.get((Object)YahooField.REAL_TIME_ASK);
        String askSize = inData.get((Object)YahooField.ASK_SIZE);
        String symbol = inData.get((Object)YahooField.SYMBOL);
        if (symbol == null || askPrice == null || askSize == null) {
            return;
        }
        Instrument instrument = this.getInstrumentFrom(symbol);
        QuoteEventBuilder builder = QuoteEventBuilder.askEvent((Instrument)instrument);
        this.lookForQuoteEvent(inData, inEvents, askPrice, askSize, symbol, instrument, builder);
    }

    private void lookForTradeEvent(Map<YahooField, String> inData, List<Event> inEvents) {
        BigDecimal size;
        BigDecimal price;
        String tradePrice = inData.get((Object)YahooField.LAST_TRADE_PRICE_ONLY);
        String tradeSize = inData.get((Object)YahooField.LAST_TRADE_SIZE);
        String tradeDate = inData.get((Object)YahooField.LAST_TRADE_DATE);
        String tradeTime = inData.get((Object)YahooField.LAST_TRADE_TIME);
        String symbol = inData.get((Object)YahooField.SYMBOL);
        String exchange = inData.get((Object)YahooField.STOCK_EXCHANGE);
        if (symbol == null || exchange == null || tradePrice == null || tradeSize == null || tradeDate == null || tradeTime == null) {
            return;
        }
        Instrument instrument = this.getInstrumentFrom(symbol);
        try {
            price = new BigDecimal(tradePrice);
            size = new BigDecimal(tradeSize);
        }
        catch (Exception e) {
            return;
        }
        TradeEventBuilder builder = TradeEventBuilder.tradeEvent((Instrument)instrument);
        Date date = new Date();
        builder.withExchange(exchange).withPrice(price).withProviderSymbol(symbol).withSize(size).withTimestamp(date).withTradeDate(String.format("%s %s", tradeDate, tradeTime));
        this.addFutureAttributes(builder, instrument, inData);
        this.addOptionAttributes(builder, instrument, inData);
        inEvents.add(builder.create());
    }

    private <T extends TradeEvent> void addFutureAttributes(TradeEventBuilder<T> inBuilder, Instrument inInstrument, Map<YahooField, String> inData) {
    }

    private <T extends TradeEvent> void addOptionAttributes(TradeEventBuilder<T> inBuilder, Instrument inInstrument, Map<YahooField, String> inData) {
    }

    private <T extends QuoteEvent> void addFutureAttributes(QuoteEventBuilder<T> inBuilder, Instrument inInstrument, Map<YahooField, String> inData) {
    }

    private <T extends QuoteEvent> void addOptionAttributes(QuoteEventBuilder<T> inBuilder, Instrument inInstrument, Map<YahooField, String> inData) {
    }

    private Instrument getInstrumentFrom(String inSymbol) {
        return new Equity(inSymbol);
    }

    static {
        TRADE_COMPARATOR = new Comparator<Event>(){

            @Override
            public int compare(Event inO1, Event inO2) {
                TradeEvent trade1 = (TradeEvent)inO1;
                TradeEvent trade2 = (TradeEvent)inO2;
                int result = trade1.getInstrumentAsString().compareTo(trade2.getInstrumentAsString());
                if (result != 0) {
                    return result;
                }
                return trade1.getTradeDate().compareTo(trade2.getTradeDate());
            }
        };
        QUOTE_COMPARATOR = new Comparator<Event>(){

            @Override
            public int compare(Event inO1, Event inO2) {
                QuoteEvent quote1 = (QuoteEvent)inO1;
                QuoteEvent quote2 = (QuoteEvent)inO2;
                int result = quote1.getClass().getName().compareTo(quote2.getClass().getName());
                if (result != 0) {
                    return result;
                }
                result = quote1.getInstrumentAsString().compareTo(quote2.getInstrumentAsString());
                if (result != 0) {
                    return result;
                }
                return quote1.getQuoteDate().compareTo(quote2.getQuoteDate());
            }
        };
        comparators = new HashMap<Class<? extends Event>, Comparator<Event>>();
        EMPTY_EVENT_LIST = new ArrayList<Event>();
    }
}

