/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.yahoo;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.marketcetera.core.CoreException;
import org.marketcetera.marketdata.AbstractMarketDataModule;
import org.marketcetera.marketdata.MarketDataFeed;
import org.marketcetera.marketdata.yahoo.Messages;
import org.marketcetera.marketdata.yahoo.YahooFeed;
import org.marketcetera.marketdata.yahoo.YahooFeedCredentials;
import org.marketcetera.marketdata.yahoo.YahooFeedFactory;
import org.marketcetera.marketdata.yahoo.YahooFeedMXBean;
import org.marketcetera.marketdata.yahoo.YahooFeedModuleFactory;
import org.marketcetera.marketdata.yahoo.YahooFeedToken;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: YahooFeedModule.java 16154 2012-07-14 16:34:05Z colin $")
public class YahooFeedModule
extends AbstractMarketDataModule<YahooFeedToken, YahooFeedCredentials>
implements YahooFeedMXBean {
    private final YahooFeed feed = new YahooFeedFactory().getMarketDataFeed();
    private volatile String url = "http://finance.yahoo.com/d/quotes.csv";
    private volatile int refreshInterval = 250;

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void setURL(String inURL) {
        this.url = StringUtils.trimToNull((String)inURL);
        Validate.notNull((Object)this.url, (String)Messages.MISSING_URL.getText());
    }

    @Override
    public String getRefreshInterval() {
        return Integer.toString(this.refreshInterval);
    }

    @Override
    public void setRefreshInterval(String inRefreshInterval) {
        String rawInterval = StringUtils.trimToNull((String)inRefreshInterval);
        this.refreshInterval = rawInterval == null ? 0 : Integer.parseInt(rawInterval);
        this.feed.setRefreshInterval(this.refreshInterval);
    }

    @Override
    public long getRequestCounter() {
        return this.feed.getRequestCounter();
    }

    @Override
    public void resetRequestCounter() {
        this.feed.resetCounter();
    }

    YahooFeedModule() throws CoreException {
        super(YahooFeedModuleFactory.INSTANCE_URN, (MarketDataFeed)new YahooFeedFactory().getMarketDataFeed());
    }

    protected YahooFeedCredentials getCredentials() throws CoreException {
        return new YahooFeedCredentials(this.url);
    }
}

