/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.yahoo;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.marketcetera.marketdata.Content;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.marketdata.yahoo.YahooField;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: YahooRequest.java 16154 2012-07-14 16:34:05Z colin $")
@ThreadSafe
class YahooRequest {
    private static final List<YahooField> commonFields = Arrays.asList(YahooField.STOCK_EXCHANGE, YahooField.ERROR_INDICATION, YahooField.SYMBOL);
    @GuardedBy(value="fields")
    private static final Multimap<Content, YahooField> fields = HashMultimap.create();
    private final MarketDataRequest request;
    private final String symbol;
    private final int id = counter.incrementAndGet();
    private volatile String handle;
    private static final AtomicInteger counter = new AtomicInteger(0);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof YahooRequest)) {
            return false;
        }
        YahooRequest other = (YahooRequest)obj;
        return this.id == other.id;
    }

    YahooRequest(MarketDataRequest inRequest, String inSymbol) {
        this.request = inRequest;
        this.symbol = StringUtils.trimToNull((String)inSymbol);
    }

    String getHandle() {
        return this.handle;
    }

    void setHandle(String inHandle) {
        this.handle = inHandle;
    }

    String getQuery() {
        StringBuilder query = new StringBuilder();
        query.append("?s=");
        query.append(this.symbol);
        if (this.request.getExchange() != null) {
            query.append('.').append(this.request.getExchange());
        }
        query.append("&f=");
        for (Content content : this.request.getContent()) {
            query.append(this.getFieldsFor(content));
        }
        for (YahooField field : commonFields) {
            query.append(field.getCode()).append(",");
        }
        return query.toString();
    }

    MarketDataRequest getRequest() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFieldsFor(Content inContent) {
        Multimap<Content, YahooField> multimap = fields;
        synchronized (multimap) {
            if (fields.isEmpty()) {
                fields.putAll((Object)Content.DIVIDEND, Arrays.asList(YahooField.EXPECTED_DIVIDEND_DATE, YahooField.DIVIDEND_PAY_DATE, YahooField.DIVIDEND_YIELD));
                fields.putAll((Object)Content.LATEST_TICK, Arrays.asList(YahooField.LAST_TRADE_DATE, YahooField.LAST_TRADE_SIZE, YahooField.LAST_TRADE_PRICE_ONLY, YahooField.LAST_TRADE_TIME));
                fields.putAll((Object)Content.MARKET_STAT, Arrays.asList(YahooField.DAY_LOW, YahooField.DAY_HIGH, YahooField.HIGH_LIMIT, YahooField.LOW_LIMIT, YahooField.DAY_RANGE, YahooField.REAL_TIME_DAY_RANGE, YahooField.OPEN, YahooField.PREVIOUS_CLOSE, YahooField.VOLUME));
                fields.putAll((Object)Content.TOP_OF_BOOK, Arrays.asList(YahooField.REAL_TIME_BID, YahooField.REAL_TIME_ASK, YahooField.BID_SIZE, YahooField.ASK_SIZE));
            }
        }
        StringBuilder builder = new StringBuilder();
        for (YahooField field : fields.get((Object)inContent)) {
            builder.append(field.getCode()).append(",");
        }
        return builder.toString();
    }
}

