/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.yahoo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import org.marketcetera.core.NoMoreIDsException;
import org.marketcetera.marketdata.AbstractMarketDataFeed;
import org.marketcetera.marketdata.AssetClass;
import org.marketcetera.marketdata.Capability;
import org.marketcetera.marketdata.FeedException;
import org.marketcetera.marketdata.IFeedComponent;
import org.marketcetera.marketdata.MarketDataFeedTokenSpec;
import org.marketcetera.marketdata.yahoo.YahooClient;
import org.marketcetera.marketdata.yahoo.YahooClientFactory;
import org.marketcetera.marketdata.yahoo.YahooFeedCredentials;
import org.marketcetera.marketdata.yahoo.YahooFeedEventTranslator;
import org.marketcetera.marketdata.yahoo.YahooFeedMessageTranslator;
import org.marketcetera.marketdata.yahoo.YahooFeedServices;
import org.marketcetera.marketdata.yahoo.YahooFeedToken;
import org.marketcetera.marketdata.yahoo.YahooRequest;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
class YahooFeed
extends AbstractMarketDataFeed<YahooFeedToken, YahooFeedCredentials, YahooFeedMessageTranslator, YahooFeedEventTranslator, List<YahooRequest>, YahooFeed>
implements YahooFeedServices {
    private volatile int refreshInterval = 250;
    private static final Set<AssetClass> assetClasses = new HashSet<AssetClass>(Arrays.asList(AssetClass.EQUITY, AssetClass.OPTION, AssetClass.FUTURE));
    private static final Set<Capability> capabilities = new HashSet<Capability>(Arrays.asList(Capability.TOP_OF_BOOK, Capability.LATEST_TICK, Capability.MARKET_STAT, Capability.EVENT_BOUNDARY));
    @GuardedBy(value="requests")
    private final Map<String, YahooRequest> requests = new HashMap<String, YahooRequest>();
    private final AtomicLong counter = new AtomicLong(0L);
    private final YahooClient client;

    public Set<Capability> getCapabilities() {
        return capabilities;
    }

    public Set<AssetClass> getSupportedAssetClasses() {
        return assetClasses;
    }

    @Override
    public void doDataReceived(String inHandle, Object inData) {
        this.dataReceived(inHandle, inData);
    }

    @Override
    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    void resetCounter() {
        this.client.resetRequestcounter();
    }

    long getRequestCounter() {
        return this.client.getRequestCounter();
    }

    YahooFeed(String inProviderName, YahooClientFactory inFactory) throws NoMoreIDsException {
        super(IFeedComponent.FeedType.DELAYED, inProviderName);
        this.client = inFactory.getClient(this);
    }

    void setRefreshInterval(int inRefreshInterval) {
        this.refreshInterval = inRefreshInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCancel(String inHandle) {
        Map<String, YahooRequest> map = this.requests;
        synchronized (map) {
            YahooRequest request = this.requests.remove(inHandle);
            if (request != null) {
                this.client.cancel(request);
            }
        }
    }

    protected boolean doLogin(YahooFeedCredentials inCredentials) {
        return this.client.login(inCredentials);
    }

    protected void doLogout() {
        this.client.logout();
    }

    protected boolean isLoggedIn() {
        return this.client.isLoggedIn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> doMarketDataRequest(List<YahooRequest> inRequests) throws FeedException {
        ArrayList<String> handles = new ArrayList<String>();
        Map<String, YahooRequest> map = this.requests;
        synchronized (map) {
            for (YahooRequest request : inRequests) {
                String handle = this.generateHandle();
                handles.add(handle);
                request.setHandle(handle);
                this.requests.put(handle, request);
                this.client.request(request);
            }
            return handles;
        }
    }

    protected YahooFeedToken generateToken(MarketDataFeedTokenSpec inTokenSpec) throws FeedException {
        return new YahooFeedToken(inTokenSpec, this);
    }

    protected YahooFeedEventTranslator getEventTranslator() {
        return YahooFeedEventTranslator.INSTANCE;
    }

    protected YahooFeedMessageTranslator getMessageTranslator() {
        return YahooFeedMessageTranslator.INSTANCE;
    }

    private String generateHandle() {
        return String.format("yahoo-%s", this.counter.incrementAndGet());
    }
}

