/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.csv;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataFlowInfo;
import org.marketcetera.module.DataFlowStep;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.module.IllegalRequestParameterValue;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.module.ModuleState;
import org.marketcetera.module.ModuleTestBase;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.SinkDataListener;
import org.marketcetera.module.SinkModuleFactory;
import org.marketcetera.module.UnsupportedRequestParameterType;
import org.marketcetera.modules.csv.CSVEmitterFactory;
import org.marketcetera.modules.csv.Messages;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: EmitterTest.java 16154 2012-07-14 16:34:05Z colin $")
public class EmitterTest
extends ModuleTestBase {
    private ModuleManager mManager;
    private static final int NUM_ROWS = 3141;
    private static final File INPUTS_DIR = new File("src/test/sample_data", "inputs");
    private static final File VALID_CSV_FILE = new File(INPUTS_DIR, "table.csv");
    private static final File INVALID_CSV_FILE = new File(INPUTS_DIR, "insufficient_rows.csv");

    @BeforeClass
    public static void logSetup() {
        LoggerConfiguration.logSetup();
    }

    @Test
    public void invalidRequests() throws Exception {
        new ExpectedFailure<IllegalRequestParameterValue>((I18NMessage)org.marketcetera.module.Messages.ILLEGAL_REQ_PARM_VALUE, new Object[]{CSVEmitterFactory.INSTANCE_URN.toString(), null}){

            protected void run() throws Exception {
                EmitterTest.this.mManager.createDataFlow(new DataRequest[]{new DataRequest(CSVEmitterFactory.INSTANCE_URN, null)});
            }
        };
        final Object invalidParam = new Object();
        new ExpectedFailure<UnsupportedRequestParameterType>((I18NMessage)org.marketcetera.module.Messages.UNSUPPORTED_REQ_PARM_TYPE, new Object[]{CSVEmitterFactory.INSTANCE_URN.toString(), invalidParam.getClass().getName()}){

            protected void run() throws Exception {
                EmitterTest.this.mManager.createDataFlow(new DataRequest[]{new DataRequest(CSVEmitterFactory.INSTANCE_URN, invalidParam)});
            }
        };
    }

    @Test(timeout=60000L)
    public void invalidFile() throws Exception {
        Assert.assertTrue((boolean)this.mManager.getDataFlows(true).isEmpty());
        File csv = new File("does/not/exist");
        Assert.assertFalse((boolean)csv.exists());
        DataFlowID id = this.mManager.createDataFlow(new DataRequest[]{new DataRequest(CSVEmitterFactory.INSTANCE_URN, (Object)csv.getAbsolutePath())});
        while (!this.mManager.getDataFlows(true).isEmpty()) {
            Thread.sleep(1000L);
        }
        List history = this.mManager.getDataFlowHistory();
        Assert.assertEquals((long)1L, (long)history.size());
        DataFlowInfo info = (DataFlowInfo)history.get(0);
        EmitterTest.assertFlowInfo((DataFlowInfo)info, (DataFlowID)id, (int)2, (boolean)true, (boolean)true, null, (ModuleURN)CSVEmitterFactory.INSTANCE_URN);
        DataFlowStep flowStep = info.getFlowSteps()[0];
        Assert.assertEquals((Object)CSVEmitterFactory.INSTANCE_URN, (Object)flowStep.getModuleURN());
        Assert.assertEquals((Object)true, (Object)flowStep.isEmitter());
        Assert.assertEquals((long)0L, (long)flowStep.getNumEmitted());
        Assert.assertEquals((long)1L, (long)flowStep.getNumEmitErrors());
        Pattern p = Pattern.compile(Messages.UNEXPECTED_ERROR.getText((Object)".*"));
        Assert.assertTrue((String)flowStep.getLastEmitError(), (boolean)p.matcher(flowStep.getLastEmitError()).matches());
        Assert.assertEquals((Object)false, (Object)flowStep.isReceiver());
        Assert.assertEquals((long)0L, (long)flowStep.getNumReceived());
        Assert.assertEquals((long)0L, (long)flowStep.getNumReceiveErrors());
        Assert.assertEquals(null, (Object)flowStep.getLastReceiveError());
        Assert.assertEquals((Object)CSVEmitterFactory.INSTANCE_URN, (Object)flowStep.getRequest().getRequestURN());
        Assert.assertEquals((Object)csv.getAbsolutePath(), (Object)flowStep.getRequest().getData());
        EmitterTest.assertFlowStep((DataFlowStep)info.getFlowSteps()[1], (ModuleURN)SinkModuleFactory.INSTANCE_URN, (boolean)false, (int)0, (int)0, null, (boolean)true, (int)0, (int)0, null, (ModuleURN)SinkModuleFactory.INSTANCE_URN, null);
    }

    @Test(timeout=60000L)
    public void insufficientInput() throws Exception {
        Assert.assertTrue((String)INVALID_CSV_FILE.getAbsolutePath(), (boolean)INVALID_CSV_FILE.exists());
        DataFlowID id = this.mManager.createDataFlow(new DataRequest[]{new DataRequest(CSVEmitterFactory.INSTANCE_URN, (Object)INVALID_CSV_FILE.getAbsolutePath())});
        while (!this.mManager.getDataFlows(true).isEmpty()) {
            Thread.sleep(1000L);
        }
        List history = this.mManager.getDataFlowHistory();
        Assert.assertEquals((long)1L, (long)history.size());
        DataFlowInfo info = (DataFlowInfo)history.get(0);
        EmitterTest.assertFlowInfo((DataFlowInfo)info, (DataFlowID)id, (int)2, (boolean)true, (boolean)true, null, (ModuleURN)CSVEmitterFactory.INSTANCE_URN);
        EmitterTest.assertFlowStep((DataFlowStep)info.getFlowSteps()[0], (ModuleURN)CSVEmitterFactory.INSTANCE_URN, (boolean)true, (int)0, (int)1, (String)Messages.INSUFFICIENT_DATA.getText((Object)1), (boolean)false, (int)0, (int)0, null, (ModuleURN)CSVEmitterFactory.INSTANCE_URN, (Object)INVALID_CSV_FILE.getAbsolutePath());
        EmitterTest.assertFlowStep((DataFlowStep)info.getFlowSteps()[1], (ModuleURN)SinkModuleFactory.INSTANCE_URN, (boolean)false, (int)0, (int)0, null, (boolean)true, (int)0, (int)0, null, (ModuleURN)SinkModuleFactory.INSTANCE_URN, null);
    }

    @Test(timeout=60000L)
    public void emitCSVStringFile() throws Exception {
        Assert.assertTrue((String)VALID_CSV_FILE.getAbsolutePath(), (boolean)VALID_CSV_FILE.exists());
        new ExpectedFailure<MalformedURLException>(){

            protected void run() throws Exception {
                new URL(VALID_CSV_FILE.getAbsolutePath());
            }
        };
        this.checkEmitCSV(VALID_CSV_FILE.getAbsolutePath(), false);
    }

    @Test(timeout=60000L)
    public void emitCSVStringFileReverse() throws Exception {
        Assert.assertTrue((String)VALID_CSV_FILE.getAbsolutePath(), (boolean)VALID_CSV_FILE.exists());
        new ExpectedFailure<MalformedURLException>(){

            protected void run() throws Exception {
                new URL("r:" + VALID_CSV_FILE.getAbsolutePath());
            }
        };
        this.checkEmitCSV("r:" + VALID_CSV_FILE.getAbsolutePath(), true);
    }

    @Test(timeout=60000L)
    public void emitCSVStringURL() throws Exception {
        Assert.assertTrue((String)VALID_CSV_FILE.getAbsolutePath(), (boolean)VALID_CSV_FILE.exists());
        this.checkEmitCSV(VALID_CSV_FILE.toURI().toURL().toString(), false);
    }

    @Test(timeout=60000L)
    public void emitCSVStringURLReverse() throws Exception {
        Assert.assertTrue((String)VALID_CSV_FILE.getAbsolutePath(), (boolean)VALID_CSV_FILE.exists());
        this.checkEmitCSV("r:" + VALID_CSV_FILE.toURI().toURL().toString(), true);
    }

    @Test(timeout=60000L)
    public void emitCSVFile() throws Exception {
        Assert.assertTrue((String)VALID_CSV_FILE.getAbsolutePath(), (boolean)VALID_CSV_FILE.exists());
        this.checkEmitCSV(VALID_CSV_FILE, false);
    }

    @Test(timeout=60000L)
    public void emitCSVURL() throws Exception {
        Assert.assertTrue((String)VALID_CSV_FILE.getAbsolutePath(), (boolean)VALID_CSV_FILE.exists());
        this.checkEmitCSV(VALID_CSV_FILE.toURI().toURL(), false);
    }

    @Test
    public void info() throws Exception {
        EmitterTest.assertProviderInfo((ModuleManager)this.mManager, (ModuleURN)CSVEmitterFactory.PROVIDER_URN, (String[])new String[0], (Class[])new Class[0], (String)Messages.PROVIDER_DESCRIPTION.getText(), (boolean)false, (boolean)false);
        EmitterTest.assertModuleInfo((ModuleManager)this.mManager, (ModuleURN)CSVEmitterFactory.INSTANCE_URN, (ModuleState)ModuleState.STARTED, null, null, (boolean)false, (boolean)true, (boolean)false, (boolean)true, (boolean)false);
    }

    @Before
    public void setup() throws Exception {
        this.mManager = new ModuleManager();
        this.mManager.init();
    }

    @After
    public void cleanup() throws Exception {
        this.mManager.stop();
        this.mManager = null;
    }

    private void checkEmitCSV(Object inRequestParam, boolean inReverse) throws Exception {
        Assert.assertTrue((boolean)this.mManager.getDataFlows(true).isEmpty());
        FirstAndLastTracker tracker = new FirstAndLastTracker();
        this.mManager.addSinkListener((SinkDataListener)tracker);
        DataFlowID flowID = this.mManager.createDataFlow(new DataRequest[]{new DataRequest(CSVEmitterFactory.INSTANCE_URN, inRequestParam)});
        while (!this.mManager.getDataFlows(true).isEmpty()) {
            Thread.sleep(1000L);
        }
        List history = this.mManager.getDataFlowHistory();
        Assert.assertEquals((long)1L, (long)history.size());
        DataFlowInfo info = (DataFlowInfo)history.get(0);
        EmitterTest.assertFlowInfo((DataFlowInfo)info, (DataFlowID)flowID, (int)2, (boolean)true, (boolean)true, null, (ModuleURN)CSVEmitterFactory.INSTANCE_URN);
        EmitterTest.assertFlowStep((DataFlowStep)info.getFlowSteps()[0], (ModuleURN)CSVEmitterFactory.INSTANCE_URN, (boolean)true, (int)3141, (int)1, (String)Messages.NO_MORE_DATA.getText(), (boolean)false, (int)0, (int)0, null, (ModuleURN)CSVEmitterFactory.INSTANCE_URN, (Object)inRequestParam.toString());
        EmitterTest.assertFlowStep((DataFlowStep)info.getFlowSteps()[1], (ModuleURN)SinkModuleFactory.INSTANCE_URN, (boolean)false, (int)0, (int)0, null, (boolean)true, (int)3141, (int)0, null, (ModuleURN)SinkModuleFactory.INSTANCE_URN, null);
        Assert.assertNotNull((Object)tracker.getFirst());
        Assert.assertTrue((boolean)(tracker.getFirst() instanceof Map));
        Assert.assertEquals((Object)this.createMap("2008-10-02", "16.77", "16.85", "15.54", "15.58", "23416200", "15.58"), (Object)(inReverse ? tracker.getLast() : tracker.getFirst()));
        Assert.assertNotNull((Object)tracker.getLast());
        Assert.assertTrue((boolean)(tracker.getLast() instanceof Map));
        Assert.assertEquals((Object)this.createMap("1996-04-12", "25.25", "43.00", "24.50", "33.00", "408720000", "1.38"), (Object)(inReverse ? tracker.getFirst() : tracker.getLast()));
    }

    private Map createMap(String inDate, String inOpen, String inHigh, String inLow, String inClose, String inVolume, String inAdjClose) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Date", inDate);
        map.put("Open", inOpen);
        map.put("High", inHigh);
        map.put("Low", inLow);
        map.put("Close", inClose);
        map.put("Volume", inVolume);
        map.put("Adj Close", inAdjClose);
        return map;
    }

    private static class FirstAndLastTracker
    implements SinkDataListener {
        private volatile Object mFirst;
        private volatile Object mLast;

        private FirstAndLastTracker() {
        }

        public void receivedData(DataFlowID inFlowID, Object inData) {
            this.mLast = inData;
            if (this.mFirst == null) {
                this.mFirst = inData;
            }
        }

        public Object getFirst() {
            return this.mFirst;
        }

        public Object getLast() {
            return this.mLast;
        }
    }
}

