/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.async;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataReceiver;
import org.marketcetera.module.Module;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ReceiveDataException;
import org.marketcetera.modules.async.BlockingModuleFactory;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: BlockingReceiverModule.java 16154 2012-07-14 16:34:05Z colin $")
public class BlockingReceiverModule
extends Module
implements DataReceiver {
    private final BlockingQueue<Object> mData = new SynchronousQueue<Object>();
    private final Semaphore mSemaphore = new Semaphore(0);

    BlockingReceiverModule() {
        super(BlockingModuleFactory.INSTANCE_URN, true);
    }

    protected void preStart() throws ModuleException {
    }

    protected void preStop() throws ModuleException {
    }

    public void receiveData(DataFlowID inFlowID, Object inData) throws ReceiveDataException {
        try {
            this.mSemaphore.release();
            this.mData.put(inData);
        }
        catch (InterruptedException e) {
            throw new ReceiveDataException((Throwable)e);
        }
    }

    Object getNextData() throws InterruptedException {
        return this.mData.take();
    }

    Semaphore getSemaphore() {
        return this.mSemaphore;
    }
}

