/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.csv;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVStrategy;
import org.marketcetera.module.DataEmitter;
import org.marketcetera.module.DataEmitterSupport;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.IllegalRequestParameterValue;
import org.marketcetera.module.Module;
import org.marketcetera.module.RequestID;
import org.marketcetera.module.UnsupportedRequestParameterType;
import org.marketcetera.modules.csv.CSVEmitterFactory;
import org.marketcetera.modules.csv.Messages;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.misc.NamedThreadFactory;
import org.marketcetera.util.unicode.DecodingStrategy;
import org.marketcetera.util.unicode.UnicodeInputStreamReader;

@ClassVersion(value="$Id: CSVEmitter.java 16841 2014-02-20 19:59:04Z colin $")
public class CSVEmitter
extends Module
implements DataEmitter {
    private ExecutorService mService;
    private final Map<RequestID, Future<Boolean>> mRequests = new Hashtable<RequestID, Future<Boolean>>();
    static final String PREFIX_REVERSE = "r:";

    protected CSVEmitter() {
        super(CSVEmitterFactory.INSTANCE_URN, true);
    }

    protected void preStart() {
        this.mService = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("CSVEmitter-"));
    }

    protected void preStop() {
        this.mService.shutdownNow();
    }

    public void requestData(DataRequest inRequest, DataEmitterSupport inSupport) throws UnsupportedRequestParameterType, IllegalRequestParameterValue {
        Object obj = inRequest.getData();
        if (obj == null) {
            throw new IllegalRequestParameterValue(this.getURN(), null);
        }
        boolean isReverse = false;
        try {
            URL csv;
            if (obj instanceof String) {
                String s = (String)obj;
                if (s.startsWith(PREFIX_REVERSE)) {
                    isReverse = true;
                    s = s.substring(PREFIX_REVERSE.length());
                }
                try {
                    csv = new URL(s);
                }
                catch (MalformedURLException ignore) {
                    csv = new File(s).toURI().toURL();
                }
            } else if (obj instanceof File) {
                csv = ((File)obj).toURI().toURL();
            } else if (obj instanceof URL) {
                csv = (URL)obj;
            } else {
                throw new UnsupportedRequestParameterType(this.getURN(), obj);
            }
            CSVReader reader = new CSVReader(csv, inSupport, isReverse);
            Future<Boolean> future = this.mService.submit(reader);
            this.mRequests.put(inSupport.getRequestID(), future);
        }
        catch (MalformedURLException e) {
            throw new IllegalRequestParameterValue(this.getURN(), obj, (Throwable)e);
        }
    }

    public void cancel(DataFlowID inFlowID, RequestID inRequestID) {
        Future<Boolean> future = this.mRequests.remove(inRequestID);
        if (future != null) {
            future.cancel(true);
        }
    }

    private static class CSVReader
    implements Callable<Boolean> {
        private final URL mSource;
        private final boolean mReverse;
        private final DataEmitterSupport mSupport;

        private CSVReader(URL inSource, DataEmitterSupport inSupport, boolean inReverse) {
            this.mSource = inSource;
            this.mSupport = inSupport;
            this.mReverse = inReverse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            InputStream is = null;
            try {
                is = this.mSource.openStream();
                String[][] rows = new CSVParser((Reader)new UnicodeInputStreamReader(is, DecodingStrategy.SIG_REQ), CSVStrategy.EXCEL_STRATEGY).getAllValues();
                if (rows == null || rows.length < 2) {
                    this.mSupport.dataEmitError((I18NBoundMessage)new I18NBoundMessage1P(Messages.INSUFFICIENT_DATA, (Serializable)Integer.valueOf(rows == null ? 0 : rows.length)), true);
                    Boolean bl = false;
                    return bl;
                }
                if (this.mReverse) {
                    for (int i = rows.length - 1; i > 0; --i) {
                        this.mSupport.send(this.createMap(rows[0], rows[i]));
                    }
                } else {
                    for (int i = 1; i < rows.length; ++i) {
                        this.mSupport.send(this.createMap(rows[0], rows[i]));
                    }
                }
                this.mSupport.dataEmitError((I18NBoundMessage)Messages.NO_MORE_DATA, true);
            }
            catch (Throwable e) {
                this.mSupport.dataEmitError((I18NBoundMessage)new I18NBoundMessage1P(Messages.UNEXPECTED_ERROR, (Serializable)((Object)e.getLocalizedMessage())), true);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            return true;
        }

        private Map<String, String> createMap(String[] inKeys, String[] inValues) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < inKeys.length; ++i) {
                map.put(inKeys[i], i < inValues.length ? inValues[i] : "");
            }
            return map;
        }
    }
}

