/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.headwater;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import org.marketcetera.module.DataEmitter;
import org.marketcetera.module.DataEmitterSupport;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.Module;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.RequestDataException;
import org.marketcetera.module.RequestID;
import org.marketcetera.modules.headwater.HeadwaterModuleFactory;
import org.marketcetera.util.log.SLF4JLoggerProxy;

public class HeadwaterModule
extends Module
implements DataEmitter {
    private final Map<DataFlowID, DataEmitterSupport> dataSupport = Maps.newHashMap();
    private static final Map<String, HeadwaterModule> instances = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HeadwaterModule getInstance(String inInstanceName) {
        Map<String, HeadwaterModule> map = instances;
        synchronized (map) {
            if (instances.containsKey(inInstanceName)) {
                return instances.get(inInstanceName);
            }
            ModuleManager moduleManager = ModuleManager.getInstance();
            if (moduleManager == null) {
                throw new IllegalStateException("ModuleManager not intialized");
            }
            moduleManager.createModule(HeadwaterModuleFactory.PROVIDER_URN, new Object[]{inInstanceName});
            return instances.get(inInstanceName);
        }
    }

    public static ModuleURN createHeadwaterModule(String inHeadwaterInstance, ModuleManager inModuleManager) {
        ModuleURN headwaterUrn = inModuleManager.createModule(HeadwaterModuleFactory.PROVIDER_URN, new Object[]{inHeadwaterInstance});
        return headwaterUrn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emit(Object inData, DataFlowID ... inDataFlowIds) {
        HashSet targets = Sets.newHashSet();
        Map<DataFlowID, DataEmitterSupport> map = this.dataSupport;
        synchronized (map) {
            if (inDataFlowIds == null || inDataFlowIds.length == 0) {
                targets.addAll(this.dataSupport.values());
            } else {
                for (DataFlowID dataFlowId : inDataFlowIds) {
                    DataEmitterSupport dataEmitterSupport = this.dataSupport.get(dataFlowId);
                    if (dataEmitterSupport == null) {
                        SLF4JLoggerProxy.warn((Object)((Object)this), (String)"{} has no target for {}", (Object[])new Object[]{this.getURN(), dataFlowId});
                        continue;
                    }
                    targets.add(dataEmitterSupport);
                }
            }
        }
        for (DataEmitterSupport target : targets) {
            SLF4JLoggerProxy.trace((Object)((Object)this), (String)"{} sending {} to {}", (Object[])new Object[]{this.getURN(), inData, target});
            target.send(inData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HeadwaterModule(ModuleURN inUrn, String inInstanceName) {
        super(inUrn, true);
        Map<String, HeadwaterModule> map = instances;
        synchronized (map) {
            if (instances.containsKey(inInstanceName)) {
                throw new UnsupportedOperationException("Duplicate instance: " + inInstanceName);
            }
            instances.put(inInstanceName, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestData(DataRequest inRequest, DataEmitterSupport inSupport) throws RequestDataException {
        Map<DataFlowID, DataEmitterSupport> map = this.dataSupport;
        synchronized (map) {
            this.dataSupport.put(inSupport.getFlowID(), inSupport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(DataFlowID inFlowID, RequestID inRequestID) {
        Map<DataFlowID, DataEmitterSupport> map = this.dataSupport;
        synchronized (map) {
            this.dataSupport.remove(inFlowID);
        }
    }

    protected void preStart() throws ModuleException {
    }

    protected void preStop() throws ModuleException {
    }
}

