/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.marketcetera.core.ApplicationBase;
import org.marketcetera.ors.DBInit;
import org.marketcetera.ors.ORSTestClient;
import org.marketcetera.ors.OrderRoutingSystem;
import org.marketcetera.ors.brokers.Broker;
import org.marketcetera.ors.brokers.Brokers;
import org.marketcetera.ors.exchange.Event;
import org.marketcetera.ors.exchange.FromAppEvent;
import org.marketcetera.ors.exchange.LogonEvent;
import org.marketcetera.ors.exchange.SampleExchange;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.TypesTestBase;
import org.marketcetera.util.test.TestCaseBase;
import quickfix.CharField;
import quickfix.DecimalField;
import quickfix.Message;
import quickfix.SessionID;
import quickfix.StringField;
import quickfix.UtcTimeStampField;
import quickfix.field.AvgPx;
import quickfix.field.ClOrdID;
import quickfix.field.CumQty;
import quickfix.field.CxlRejResponseTo;
import quickfix.field.ExecID;
import quickfix.field.ExecTransType;
import quickfix.field.ExecType;
import quickfix.field.LeavesQty;
import quickfix.field.OrdStatus;
import quickfix.field.OrderID;
import quickfix.field.OrigClOrdID;
import quickfix.field.SendingTime;
import quickfix.field.Side;
import quickfix.field.Symbol;

public class ORSTestBase
extends TestCaseBase {
    protected static final String BROKER_URL = "tcp://localhost:61616";
    private static SampleExchange mExchange;
    private static OrderRoutingSystem sORS;
    private static Thread sORSThread;
    private static ORSTestClient sAdminClient;
    private static AtomicInteger sNextOrderID;

    protected static void startORS(String[] args) throws Exception {
        Event event;
        DBInit.initORSDB();
        mExchange = new SampleExchange(ApplicationBase.CONF_DIR + "exchange.xml");
        mExchange.start();
        Thread.sleep(1000L);
        sORS = new OrderRoutingSystem(args);
        sORSThread = new Thread("testThread"){

            @Override
            public void run() {
                ORSTestBase.getORS().startWaitingForever();
            }
        };
        sORSThread.start();
        while (!ORSTestBase.getORS().isWaitingForever()) {
            Thread.sleep(1000L);
        }
        int logonCount = 0;
        while (!((event = ORSTestBase.getExchange().getNext()) instanceof LogonEvent) || ++logonCount < 2) {
        }
        sAdminClient = new ORSTestClient(ORSTestBase.getORS().getAuth().getUser(), ORSTestBase.getORS().getAuth().getPassword());
    }

    protected static void startORS() throws Exception {
        ORSTestBase.startORS(new String[0]);
    }

    protected static void stopORS() throws Exception {
        if (ORSTestBase.getAdminClient() != null) {
            ORSTestBase.getAdminClient().close();
            sAdminClient = null;
        }
        if (sORSThread != null) {
            sORSThread.interrupt();
            while (sORSThread.isAlive()) {
                Thread.sleep(1000L);
            }
            sORSThread = null;
        }
        if (ORSTestBase.getORS() != null) {
            ORSTestBase.getORS().stop();
            sORS = null;
        }
        if (ORSTestBase.getExchange() != null) {
            ORSTestBase.getExchange().stop();
            mExchange = null;
        }
    }

    protected static SampleExchange getExchange() {
        return mExchange;
    }

    protected static OrderRoutingSystem getORS() {
        return sORS;
    }

    protected static ORSTestClient getAdminClient() {
        return sAdminClient;
    }

    protected static Brokers getBrokers() {
        return ORSTestBase.getORS().getBrokers();
    }

    protected static BrokerID getFirstBrokerID() {
        return ((Broker)ORSTestBase.getBrokers().getBrokers().get(0)).getBrokerID();
    }

    protected static void emulateBrokerResponse(BrokerID brokerID, Message msg) throws Exception {
        if (!msg.getHeader().isSetField(52)) {
            msg.getHeader().setField((UtcTimeStampField)new SendingTime(new Date()));
        }
        SessionID id = ORSTestBase.getBrokers().getBroker(brokerID).getSessionID();
        SampleExchange.sendMessage(msg, new SessionID(id.getBeginString(), id.getTargetCompID(), id.getSenderCompID()));
    }

    protected static void emulateFirstBrokerResponse(Message msg) throws Exception {
        ORSTestBase.emulateBrokerResponse(ORSTestBase.getFirstBrokerID(), msg);
    }

    protected static Message getNextExchangeMessage() throws InterruptedException {
        Event event;
        while (!((event = ORSTestBase.getExchange().getNext()) instanceof FromAppEvent)) {
        }
        return ((FromAppEvent)event).getMessage();
    }

    protected static void completeExecReport(Message msg) {
        if (!msg.isSetField(6)) {
            msg.setField((DecimalField)new AvgPx(0.0));
        }
        if (!msg.isSetField(11)) {
            msg.setField((StringField)new ClOrdID("ID" + sNextOrderID.getAndIncrement()));
        }
        if (!msg.isSetField(14)) {
            msg.setField((DecimalField)new CumQty(0.0));
        }
        if (!msg.isSetField(17)) {
            msg.setField((StringField)new ExecID("ID" + sNextOrderID.getAndIncrement()));
        }
        if (!msg.isSetField(20)) {
            msg.setField((CharField)new ExecTransType('0'));
        }
        if (!msg.isSetField(150)) {
            msg.setField((CharField)new ExecType('0'));
        }
        if (!msg.isSetField(151)) {
            msg.setField((DecimalField)new LeavesQty(0.0));
        }
        if (!msg.isSetField(39)) {
            msg.setField((CharField)new OrdStatus('0'));
        }
        if (!msg.isSetField(37)) {
            msg.setField((StringField)new OrderID("ID" + sNextOrderID.getAndIncrement()));
        }
        if (!msg.isSetField(54)) {
            msg.setField((CharField)new Side('1'));
        }
        if (!msg.isSetField(55)) {
            msg.setField((StringField)new Symbol("IBM"));
        }
    }

    protected static Message createEmptyOrderCancelReject() {
        return TypesTestBase.getSystemMessageFactory().newOrderCancelReject();
    }

    protected static void completeOrderCancelReject(Message msg) {
        if (!msg.isSetField(11)) {
            msg.setField((StringField)new ClOrdID("ID" + sNextOrderID.getAndIncrement()));
        }
        if (!msg.isSetField(434)) {
            msg.setField((CharField)new CxlRejResponseTo('1'));
        }
        if (!msg.isSetField(39)) {
            msg.setField((CharField)new OrdStatus('0'));
        }
        if (!msg.isSetField(37)) {
            msg.setField((StringField)new OrderID("ID" + sNextOrderID.getAndIncrement()));
        }
        if (!msg.isSetField(41)) {
            msg.setField((StringField)new OrigClOrdID("ID" + sNextOrderID.getAndIncrement()));
        }
    }

    protected static Message createEmptyBusinessMessageReject() {
        return TypesTestBase.getSystemMessageFactory().newBusinessMessageReject("QQ", 3, "Bad message type");
    }

    @BeforeClass
    public static void setupORSTestBase() throws Exception {
        ORSTestBase.startORS();
    }

    @AfterClass
    public static void tearDownORSTestBase() throws Exception {
        ORSTestBase.stopORS();
    }

    static {
        sNextOrderID = new AtomicInteger(0);
    }
}

