/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.beans.ExceptionListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.junit.Assert;
import org.marketcetera.client.BrokerStatusListener;
import org.marketcetera.client.Client;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.ReportListener;
import org.marketcetera.client.ServerStatusListener;
import org.marketcetera.client.brokers.BrokerStatus;
import org.marketcetera.ors.config.SpringConfig;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.ReportBase;

public class ORSTestClient {
    private final Client mClient;
    private final ExceptionListenerImpl mExceptionListener;
    private final ReportListenerImpl mReportListener;
    private final BrokerStatusListenerImpl mBrokerStatusListener;
    private final ServerStatusListenerImpl mServerStatusListener;

    public ORSTestClient(String user, char[] password) throws Exception {
        ClientManager.init((ClientParameters)new ClientParameters(user, password, "tcp://localhost:61616", SpringConfig.getSingleton().getServerHost(), SpringConfig.getSingleton().getServerPort()));
        this.mClient = ClientManager.getInstance();
        this.mExceptionListener = new ExceptionListenerImpl();
        this.getClient().addExceptionListener((ExceptionListener)this.getExceptionListener());
        this.mReportListener = new ReportListenerImpl();
        this.getClient().addReportListener((ReportListener)this.getReportListener());
        this.mBrokerStatusListener = new BrokerStatusListenerImpl();
        this.getClient().addBrokerStatusListener((BrokerStatusListener)this.getBrokerStatusListener());
        this.mServerStatusListener = new ServerStatusListenerImpl();
        this.getClient().addServerStatusListener((ServerStatusListener)this.getServerStatusListener());
    }

    public void close() throws Exception {
        Thread.sleep(5000L);
        this.getClient().close();
        Assert.assertFalse((boolean)((Boolean)this.getServerStatusListener().getNext()));
        this.assertEmptyAccumulators();
    }

    public Client getClient() {
        return this.mClient;
    }

    public ExceptionListenerImpl getExceptionListener() {
        return this.mExceptionListener;
    }

    public ReportListenerImpl getReportListener() {
        return this.mReportListener;
    }

    public BrokerStatusListenerImpl getBrokerStatusListener() {
        return this.mBrokerStatusListener;
    }

    public ServerStatusListenerImpl getServerStatusListener() {
        return this.mServerStatusListener;
    }

    public void assertEmptyAccumulators() {
        this.getExceptionListener().assertEmpty();
        this.getBrokerStatusListener().assertEmpty();
        this.getReportListener().assertEmpty();
        this.getServerStatusListener().assertEmpty();
    }

    public static class ServerStatusListenerImpl
    extends Accumulator<Boolean>
    implements ServerStatusListener {
        public void receiveServerStatus(boolean status) {
            this.add(status);
        }
    }

    public static class BrokerStatusListenerImpl
    extends Accumulator<BrokerStatus>
    implements BrokerStatusListener {
        public void receiveBrokerStatus(BrokerStatus status) {
            this.add(status);
        }
    }

    public static class ReportListenerImpl
    extends Accumulator<ReportBase>
    implements ReportListener {
        public void receiveExecutionReport(ExecutionReport report) {
            this.add(report);
        }

        public void receiveCancelReject(OrderCancelReject report) {
            this.add(report);
        }
    }

    public static class ExceptionListenerImpl
    extends Accumulator<Exception>
    implements ExceptionListener {
        @Override
        public void exceptionThrown(Exception exception) {
            this.add(exception);
        }
    }

    public static class Accumulator<T> {
        private BlockingQueue<T> mItems = new LinkedBlockingQueue<T>();

        public void add(T item) {
            this.mItems.add(item);
        }

        public T getNext() throws InterruptedException {
            return this.mItems.take();
        }

        public void clear() {
            this.mItems.clear();
        }

        public void assertEmpty() {
            Assert.assertEquals((long)0L, (long)this.mItems.size());
        }
    }
}

