/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.io.File;
import java.util.Collection;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.ors.Messages;
import org.marketcetera.ors.OptionRootUnderlyingMap;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.test.TestCaseBase;

@ClassVersion(value="$Id: OptionRootUnderlyingMapTest.java 16154 2012-07-14 16:34:05Z colin $")
public class OptionRootUnderlyingMapTest
extends TestCaseBase {
    private static final String MAPPING_FILE = DIR_ROOT + File.separator + "optionRootMapping.txt";

    @BeforeClass
    public static void logSetup() {
        OptionRootUnderlyingMapTest.setLevel((String)OptionRootUnderlyingMap.class.getName(), (Level)Level.INFO);
    }

    @After
    public void clearAppender() {
        this.getLogAssist().resetAppender();
    }

    @Test
    public void basic() throws Exception {
        OptionRootUnderlyingMap map = OptionRootUnderlyingMapTest.createMap(MAPPING_FILE);
        OptionRootUnderlyingMapTest.verifyMappingEmpty(map);
        map.afterPropertiesSet();
        Assert.assertEquals((long)55L, (long)map.getNumOptionRoots());
        Assert.assertEquals((long)51L, (long)map.getNumUnderlyings());
        Assert.assertNull((Object)map.getUnderlying(null));
        Assert.assertEquals(null, (Object)map.getOptionRoots(null));
        Assert.assertArrayEquals((Object[])new String[]{"K"}, (Object[])map.getOptionRoots("K").toArray(new String[1]));
        Assert.assertEquals((Object)"K", (Object)map.getUnderlying("K"));
        Assert.assertEquals(null, (Object)map.getUnderlying("Zee"));
        Assert.assertEquals(null, (Object)map.getOptionRoots("Bee"));
    }

    @Test
    public void unmodifiableOptionRootCollection() throws Exception {
        OptionRootUnderlyingMap map = OptionRootUnderlyingMapTest.createMap(MAPPING_FILE);
        map.afterPropertiesSet();
        final Collection roots = map.getOptionRoots("JNPR");
        Assert.assertArrayEquals((Object[])new String[]{"JUL", "JUP", "JUQ", "JUS", "JUX"}, (Object[])roots.toArray(new String[roots.size()]));
        new ExpectedFailure<UnsupportedOperationException>(){

            protected void run() throws Exception {
                roots.clear();
            }
        };
    }

    @Test
    public void nonExistentFile() throws Exception {
        String filename = "notexist.txt";
        OptionRootUnderlyingMap map = OptionRootUnderlyingMapTest.createMap(filename);
        map.afterPropertiesSet();
        this.assertLastEvent(Level.ERROR, null, Messages.ORUM_LOG_ERROR_LOADING_FILE.getText((Object)filename), null);
        OptionRootUnderlyingMapTest.verifyMappingEmpty(map);
    }

    @Test
    public void nullFile() throws Exception {
        OptionRootUnderlyingMap map = OptionRootUnderlyingMapTest.createMap(null);
        map.afterPropertiesSet();
        this.assertLastEvent(Level.INFO, null, Messages.ORUM_LOG_SKIP_LOAD_FILE.getText(), null);
        OptionRootUnderlyingMapTest.verifyMappingEmpty(map);
    }

    @Test
    public void includeFiltering() throws Exception {
        final OptionRootUnderlyingMap map = OptionRootUnderlyingMapTest.createMap(MAPPING_FILE);
        map.afterPropertiesSet();
        Assert.assertArrayEquals((Object[])new String[]{"JUL", "JUP", "JUQ", "JUS", "JUX"}, (Object[])map.getOptionRoots("JNPR").toArray(new String[2]));
        Assert.assertEquals((Object)"JNPR", (Object)map.getUnderlying("JUP"));
        Assert.assertArrayEquals((Object[])new String[]{"KBI"}, (Object[])map.getOptionRoots("NCR").toArray(new String[1]));
        Assert.assertEquals((Object)"NCR", (Object)map.getUnderlying("KBI"));
        map.setIncludeTypes(new String[]{"EU"});
        map.afterPropertiesSet();
        Assert.assertArrayEquals((Object[])new String[]{"JUL", "JUP", "JUQ", "JUS", "JUX"}, (Object[])map.getOptionRoots("JNPR").toArray(new String[5]));
        Assert.assertEquals((Object)"JNPR", (Object)map.getUnderlying("JUP"));
        Assert.assertEquals(null, (Object)map.getOptionRoots("NCR"));
        Assert.assertEquals(null, (Object)map.getUnderlying("KBI"));
        map.setIncludeTypes(new String[]{"SF"});
        map.afterPropertiesSet();
        Assert.assertEquals((long)6L, (long)map.getNumUnderlyings());
        Assert.assertEquals((long)7L, (long)map.getNumOptionRoots());
        Assert.assertEquals((Object)"KB", (Object)map.getUnderlying("KB1C"));
        Assert.assertArrayEquals((Object[])new String[]{"KB1C", "KB2C"}, (Object[])map.getOptionRoots("KB").toArray(new String[2]));
        map.setIncludeTypes(new String[0]);
        map.afterPropertiesSet();
        OptionRootUnderlyingMapTest.verifyMappingEmpty(map);
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                map.setIncludeTypes(null);
            }
        };
    }

    private static OptionRootUnderlyingMap createMap(String inFilename) {
        OptionRootUnderlyingMap map = new OptionRootUnderlyingMap();
        map.setFilename(inFilename);
        Assert.assertSame((Object)map, (Object)OptionRootUnderlyingMap.getInstance());
        return map;
    }

    private static void verifyMappingEmpty(OptionRootUnderlyingMap inMap) {
        Assert.assertEquals((long)0L, (long)inMap.getNumOptionRoots());
        Assert.assertEquals((long)0L, (long)inMap.getNumUnderlyings());
        Assert.assertEquals(null, (Object)inMap.getOptionRoots("K"));
        Assert.assertEquals(null, (Object)inMap.getUnderlying("K"));
    }
}

