/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.math.BigDecimal;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.event.HasFIXMessage;
import org.marketcetera.ors.ORSTestBase;
import org.marketcetera.ors.ORSTestClient;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.Side;
import quickfix.Message;

public class OrderCustomSendingTest
extends ORSTestBase {
    @Test(timeout=300000L)
    public void orderSending() throws Exception {
        ORSTestClient c = OrderCustomSendingTest.getAdminClient();
        Equity ibm = new Equity("IBM");
        OrderSingle order = Factory.getInstance().createOrderSingle();
        order.setOrderID(new OrderID("ID1"));
        order.setOrderType(OrderType.Limit);
        order.setQuantity(new BigDecimal("1"));
        order.setSide(Side.Buy);
        order.setInstrument((Instrument)ibm);
        order.setPrice(new BigDecimal("10"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Integer.toString(526), "ID2");
        order.setCustomFields(map);
        order.setOrderID(new OrderID("ID1"));
        order.setBrokerID(new BrokerID("broker1"));
        c.getClient().sendOrder(order);
        Message msg = ((HasFIXMessage)c.getReportListener().getNext()).getMessage();
        Assert.assertFalse((boolean)msg.isSetField(526));
        order.setOrderID(new OrderID("ID2"));
        order.setBrokerID(new BrokerID("broker2"));
        c.getClient().sendOrder(order);
        msg = ((HasFIXMessage)c.getReportListener().getNext()).getMessage();
        Assert.assertEquals((Object)"ID2", (Object)msg.getString(526));
        OrderCustomSendingTest.getNextExchangeMessage();
    }
}

