/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.ors.SimpleOrderInfo;
import org.marketcetera.ors.SimpleOrderInfoCache;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.UserID;
import org.marketcetera.util.test.TestCaseBase;

public class OrderInfoCacheTest
extends TestCaseBase {
    protected static final UserID TEST_ACTOR_ID1 = new UserID(1L);
    protected static final UserID TEST_ACTOR_ID2 = new UserID(2L);
    protected static final OrderID TEST_ORDER_ID1 = new OrderID("o1");
    protected static final OrderID TEST_ORDER_ID2 = new OrderID("o2");

    @Test
    public void cacheOperation() {
        SimpleOrderInfoCache cache = new SimpleOrderInfoCache();
        SimpleOrderInfo info = cache.put(TEST_ORDER_ID1, TEST_ORDER_ID2, TEST_ACTOR_ID1);
        Assert.assertSame((Object)info, (Object)cache.get(TEST_ORDER_ID1));
        cache.remove(TEST_ORDER_ID1);
        Assert.assertNull((Object)cache.get(TEST_ORDER_ID1));
    }

    @Test
    public void entryFieldRetrieval() {
        SimpleOrderInfoCache cache = new SimpleOrderInfoCache();
        SimpleOrderInfo info = cache.put(TEST_ORDER_ID1, TEST_ORDER_ID2, TEST_ACTOR_ID1);
        Assert.assertSame((Object)TEST_ORDER_ID1, (Object)info.getOrderID());
        Assert.assertSame((Object)TEST_ORDER_ID2, (Object)info.getOrigOrderID());
        Assert.assertSame((Object)TEST_ACTOR_ID1, (Object)info.getActorID());
        Assert.assertFalse((boolean)info.isViewerIDSet());
        info.setViewerID(TEST_ACTOR_ID2);
        Assert.assertSame((Object)TEST_ACTOR_ID2, (Object)info.getViewerID());
        Assert.assertTrue((boolean)info.isViewerIDSet());
        Assert.assertNull((Object)info.getERPersisted());
        Assert.assertNull((Object)info.getAckExpected());
        Assert.assertNull((Object)info.getAckProcessed());
        Assert.assertNull((Object)info.getResponseExpected());
        Assert.assertNull((Object)info.getResponseProcessed());
        info.setERPersisted(false);
        Assert.assertFalse((boolean)info.getERPersisted());
        Assert.assertSame((Object)info, (Object)cache.get(TEST_ORDER_ID1));
        info.setAckExpected(false);
        Assert.assertFalse((boolean)info.getAckExpected());
        Assert.assertSame((Object)info, (Object)cache.get(TEST_ORDER_ID1));
        info.setAckProcessed(false);
        Assert.assertFalse((boolean)info.getAckProcessed());
        Assert.assertSame((Object)info, (Object)cache.get(TEST_ORDER_ID1));
        info.setResponseExpected(false);
        Assert.assertFalse((boolean)info.getResponseExpected());
        Assert.assertNull((Object)cache.get(TEST_ORDER_ID1));
        info.setResponseProcessed(false);
        Assert.assertFalse((boolean)info.getResponseProcessed());
        Assert.assertNull((Object)cache.get(TEST_ORDER_ID1));
    }

    @Test
    public void entryFieldRetrievalNoParentOrderIF() {
        SimpleOrderInfoCache cache = new SimpleOrderInfoCache();
        SimpleOrderInfo info = cache.put(TEST_ORDER_ID1, null, TEST_ACTOR_ID1);
        Assert.assertNull((Object)info.getOrigOrderID());
        Assert.assertSame((Object)TEST_ACTOR_ID1, (Object)info.getActorID());
        Assert.assertTrue((boolean)info.isViewerIDSet());
        Assert.assertSame((Object)TEST_ACTOR_ID1, (Object)info.getViewerID());
    }
}

