/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.math.BigDecimal;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.event.HasFIXMessage;
import org.marketcetera.ors.ORSTestBase;
import org.marketcetera.ors.ORSTestClient;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.ExecutionType;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.PositionEffect;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.TypesTestBase;
import quickfix.Message;

public class OrderOptionSendingTest
extends ORSTestBase {
    @Test(timeout=300000L)
    public void orderSending() throws Exception {
        ORSTestClient c = OrderOptionSendingTest.getAdminClient();
        Equity ibm = new Equity("IBM");
        OrderSingle order = Factory.getInstance().createOrderSingle();
        order.setOrderID(new OrderID("ID1"));
        order.setOrderType(OrderType.Limit);
        order.setQuantity(new BigDecimal("1"));
        order.setSide(Side.Buy);
        order.setInstrument((Instrument)ibm);
        order.setPrice(new BigDecimal("10"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Integer.toString(77), Character.toString('O'));
        order.setCustomFields(map);
        c.getClient().sendOrder(order);
        ExecutionReport er = (ExecutionReport)c.getReportListener().getNext();
        TypesTestBase.assertExecReportValues((ExecutionReport)er, null, (BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("0"), (ExecutionType)ExecutionType.PendingNew, null, (BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("1"), (BigDecimal)new BigDecimal("1"), (OrderType)OrderType.Limit, (Side)Side.Buy, (Instrument)ibm, null, null, (PositionEffect)PositionEffect.Open, (boolean)true);
        Message msg = ((HasFIXMessage)er).getMessage();
        Assert.assertEquals((long)79L, (long)msg.getChar(77));
        msg = OrderOptionSendingTest.getNextExchangeMessage();
        Assert.assertEquals((Object)"ID1", (Object)msg.getString(11));
    }
}

