/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ors;

import java.math.BigDecimal;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import junit.framework.Test;
import org.junit.Ignore;
import org.marketcetera.core.ApplicationBase;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.core.FIXVersionTestSuite;
import org.marketcetera.core.FIXVersionedTestCase;
import org.marketcetera.ors.QuickFIXApplication;
import org.marketcetera.ors.TopicListener;
import org.marketcetera.ors.filters.MessageRouteManager;
import org.marketcetera.quickfix.FIXDataDictionary;
import org.marketcetera.quickfix.FIXMessageFactory;
import org.marketcetera.quickfix.FIXMessageUtilTest;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.quickfix.NullQuickFIXSender;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.adapter.MessageListenerAdapter;
import quickfix.Message;
import quickfix.StringField;
import quickfix.field.OrderID;

@Ignore
@ClassVersion(value="$Id: OrderRoutingSystemTest.java 16154 2012-07-14 16:34:05Z colin $")
public class OrderRoutingSystemTest
extends FIXVersionedTestCase {
    private static ClassPathXmlApplicationContext appContext = null;
    private static JmsTemplate jmsQueueSender;
    private static NullQuickFIXSender qfSender;

    public OrderRoutingSystemTest(String inName, FIXVersion version) {
        super(inName, version);
    }

    public static Test suite() {
        return new FIXVersionTestSuite(OrderRoutingSystemTest.class, new FIXVersion[]{FIXVersion.FIX42});
    }

    protected void setUp() throws Exception {
        OrderRoutingSystemTest.springSetup();
        super.setUp();
    }

    private static void springSetup() {
        if (appContext == null) {
            try {
                appContext = new ClassPathXmlApplicationContext(new String[]{"message-modifiers.xml", "order-limits.xml", "ors-shared.xml", "it-ors.xml", "ors_orm_vendor.xml", "ors_orm.xml", "ors_db.xml", "file:" + ApplicationBase.CONF_DIR + "main.xml", "file:" + ApplicationBase.CONF_DIR + "ors_base.xml"});
                jmsQueueSender = (JmsTemplate)appContext.getBean("outgoingJmsTemplate");
                qfSender = (NullQuickFIXSender)appContext.getBean("quickfixSender");
                QuickFIXApplication qfApp = (QuickFIXApplication)appContext.getBean("qfApplication");
                qfApp.onLogon(null);
            }
            catch (Exception e) {
                SLF4JLoggerProxy.error((Object)OrderRoutingSystemTest.class.getName(), (Throwable)e, (String)"Unable to initialize ORS", (Object[])new Object[0]);
                OrderRoutingSystemTest.fail((String)("Unable to init ORS: " + e.getMessage()));
            }
        }
    }

    public void testEndToEndOrderFilling() throws Exception {
        Semaphore sema = new Semaphore(0);
        ArrayBlockingQueue<Message> topicMsgs = new ArrayBlockingQueue<Message>(1);
        MessageListenerAdapter recieveAdapter = (MessageListenerAdapter)appContext.getBean("replyListener");
        recieveAdapter.setDelegate((Object)new TopicListener(topicMsgs));
        qfSender.setSemaphore(sema);
        this.oneOrderRoundtripHelper(topicMsgs, sema, '1');
        this.oneOrderRoundtripHelper(topicMsgs, sema, '2');
        this.oneOrderRoundtripHelper(topicMsgs, sema, '5');
    }

    public void testSpringCreation() throws Exception {
        ClassPathXmlApplicationContext appCtx = new ClassPathXmlApplicationContext("/message-modifiers.xml");
        MessageRouteManager orm = (MessageRouteManager)appCtx.getBean("orderRouting", MessageRouteManager.class);
        OrderRoutingSystemTest.assertFalse((boolean)orm.isSeparateSuffix());
    }

    private void oneOrderRoundtripHelper(ArrayBlockingQueue<Message> topicMsgs, Semaphore sema, char inSide) throws Exception {
        SLF4JLoggerProxy.debug((Object)((Object)this), (String)"Before sending for {} sema is {}", (Object[])new Object[]{this.fixDD.getHumanFieldValue(54, "" + inSide), sema.getQueueLength()});
        Message buyOrder = FIXMessageUtilTest.createNOS((String)"TOLI", (BigDecimal)new BigDecimal("12.34"), (BigDecimal)new BigDecimal("32"), (char)inSide, (FIXMessageFactory)this.msgFactory);
        qfSender.getCapturedMessages().clear();
        topicMsgs.clear();
        jmsQueueSender.convertAndSend((Object)buyOrder);
        sema.acquire();
        OrderRoutingSystemTest.assertEquals((String)"too many outgoing fix messages registered", (int)1, (int)qfSender.getCapturedMessages().size());
        OrderRoutingSystemTest.assertEquals((String)buyOrder.toString(), (String)((Message)qfSender.getCapturedMessages().getFirst()).toString());
        Message execReport = topicMsgs.take();
        execReport.setField((StringField)new OrderID("fake-order-id"));
        FIXMessageUtilTest.verifyExecutionReport((Message)execReport, (String)"32", (String)"TOLI", (char)inSide, (FIXMessageFactory)this.msgFactory, (FIXDataDictionary)this.fixDD);
        OrderRoutingSystemTest.assertEquals((String)"12.34", (String)execReport.getString(44));
    }
}

